/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.http.socket;

import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.aoju.bus.core.io.ByteString;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.http.Httpv;
import org.aoju.bus.http.Request;
import org.aoju.bus.http.Response;
import org.aoju.bus.http.Results;
import org.aoju.bus.http.Toable;
import org.aoju.bus.http.magic.RealResult;
import org.aoju.bus.http.metric.Cancelable;
import org.aoju.bus.http.metric.Convertor;
import org.aoju.bus.http.metric.TaskExecutor;
import org.aoju.bus.http.metric.TaskListener;
import org.aoju.bus.http.metric.http.CoverHttp;
import org.aoju.bus.http.socket.WebSocket;
import org.aoju.bus.http.socket.WebSocketListener;
import org.aoju.bus.http.socket.WebSocketMessage;

public class WebSocketCover
extends CoverHttp<WebSocketCover> {
    private Sockets.Listener<Results> onOpen;
    private Sockets.Listener<Throwable> onException;
    private Sockets.Listener<Sockets.Message> onMessage;
    private Sockets.Listener<Sockets.Close> onClosing;
    private Sockets.Listener<Sockets.Close> onClosed;
    private boolean openOnIO;
    private boolean exceptionOnIO;
    private boolean messageOnIO;
    private boolean closingOnIO;
    private boolean closedOnIO;

    public WebSocketCover(Httpv httpClient, String url) {
        super(httpClient, url);
    }

    public Sockets listen() {
        String bodyType = this.getBodyType();
        String msgType = "form".equalsIgnoreCase(bodyType) ? "json" : bodyType;
        WebSocketImpl socket = new WebSocketImpl(this.httpClient.executor(), msgType);
        this.registeTagTask(socket);
        this.httpClient.preprocess(this, () -> {
            WebSocketImpl webSocketImpl = socket;
            synchronized (webSocketImpl) {
                if (socket.cancelOrClosed) {
                    this.removeTagTask();
                } else {
                    Request request = this.prepareRequest("GET");
                    this.httpClient.webSocket(request, new MessageListener(socket));
                }
            }
        }, this.skipPreproc, this.skipSerialPreproc);
        return socket;
    }

    private void execute(Runnable command, boolean onIo) {
        this.httpClient.executor().execute(command, onIo);
    }

    public WebSocketCover setOnOpen(Sockets.Listener<Results> onOpen) {
        this.onOpen = onOpen;
        this.openOnIO = this.nextOnIO;
        this.nextOnIO = false;
        return this;
    }

    public WebSocketCover setOnException(Sockets.Listener<Throwable> onException) {
        this.onException = onException;
        this.exceptionOnIO = this.nextOnIO;
        this.nextOnIO = false;
        return this;
    }

    public WebSocketCover setOnMessage(Sockets.Listener<Sockets.Message> onMessage) {
        this.onMessage = onMessage;
        this.messageOnIO = this.nextOnIO;
        this.nextOnIO = false;
        return this;
    }

    public WebSocketCover setOnClosing(Sockets.Listener<Sockets.Close> onClosing) {
        this.onClosing = onClosing;
        this.closingOnIO = this.nextOnIO;
        this.nextOnIO = false;
        return this;
    }

    public WebSocketCover setOnClosed(Sockets.Listener<Sockets.Close> onClosed) {
        this.onClosed = onClosed;
        this.closedOnIO = this.nextOnIO;
        this.nextOnIO = false;
        return this;
    }

    class MessageListener
    extends WebSocketListener {
        WebSocketImpl webSocket;
        Charset charset;

        public MessageListener(WebSocketImpl webSocket) {
            this.webSocket = webSocket;
        }

        @Override
        public void onOpen(WebSocket webSocket, Response response) {
            this.charset = WebSocketCover.this.charset(response);
            this.webSocket.setCharset(this.charset);
            this.webSocket.setWebSocket(webSocket);
            TaskListener<Results> listener = WebSocketCover.this.httpClient.executor().getResponseListener();
            RealResult result = new RealResult(WebSocketCover.this, response, WebSocketCover.this.httpClient.executor());
            if (listener != null) {
                if (listener.listen(WebSocketCover.this, result) && WebSocketCover.this.onOpen != null) {
                    WebSocketCover.this.execute(() -> WebSocketCover.this.onOpen.on(this.webSocket, result), WebSocketCover.this.openOnIO);
                }
            } else if (WebSocketCover.this.onOpen != null) {
                WebSocketCover.this.execute(() -> WebSocketCover.this.onOpen.on(this.webSocket, result), WebSocketCover.this.openOnIO);
            }
        }

        @Override
        public void onMessage(WebSocket webSocket, String text) {
            if (WebSocketCover.this.onMessage != null) {
                WebSocketCover.this.execute(() -> WebSocketCover.this.onMessage.on(this.webSocket, new WebSocketMessage(text, WebSocketCover.this.httpClient.executor(), this.charset)), WebSocketCover.this.messageOnIO);
            }
        }

        @Override
        public void onMessage(WebSocket webSocket, ByteString bytes) {
            if (WebSocketCover.this.onMessage != null) {
                WebSocketCover.this.execute(() -> WebSocketCover.this.onMessage.on(this.webSocket, new WebSocketMessage(bytes, WebSocketCover.this.httpClient.executor(), this.charset)), WebSocketCover.this.messageOnIO);
            }
        }

        @Override
        public void onClosing(WebSocket webSocket, int code, String reason) {
            if (WebSocketCover.this.onClosing != null) {
                WebSocketCover.this.execute(() -> WebSocketCover.this.onClosing.on(this.webSocket, new Sockets.Close(code, reason)), WebSocketCover.this.closingOnIO);
            }
        }

        @Override
        public void onClosed(WebSocket webSocket, int code, String reason) {
            this.doOnClose(Results.State.RESPONSED, code, reason);
        }

        private void doOnClose(Results.State state, int code, String reason) {
            TaskListener<Results.State> listener = WebSocketCover.this.httpClient.executor().getCompleteListener();
            if (listener != null) {
                if (listener.listen(WebSocketCover.this, state) && WebSocketCover.this.onClosed != null) {
                    WebSocketCover.this.execute(() -> WebSocketCover.this.onClosed.on(this.webSocket, this.toClose(state, code, reason)), WebSocketCover.this.closedOnIO);
                }
            } else if (WebSocketCover.this.onClosed != null) {
                WebSocketCover.this.execute(() -> WebSocketCover.this.onClosed.on(this.webSocket, this.toClose(state, code, reason)), WebSocketCover.this.closedOnIO);
            }
        }

        private Sockets.Close toClose(Results.State state, int code, String reason) {
            if (state == Results.State.CANCELED) {
                return new Sockets.Close(Sockets.Close.CANCELED, "Canceled");
            }
            if (state == Results.State.EXCEPTION) {
                return new Sockets.Close(Sockets.Close.CANCELED, reason);
            }
            if (state == Results.State.NETWORK_ERROR) {
                return new Sockets.Close(Sockets.Close.NETWORK_ERROR, reason);
            }
            if (state == Results.State.TIMEOUT) {
                return new Sockets.Close(Sockets.Close.TIMEOUT, reason);
            }
            return new Sockets.Close(code, reason);
        }

        @Override
        public void onFailure(WebSocket webSocket, Throwable t, Response response) {
            IOException e = t instanceof IOException ? (IOException)t : new IOException(t.getMessage(), t);
            this.doOnClose(WebSocketCover.this.toState(e), 0, t.getMessage());
            TaskListener<IOException> listener = WebSocketCover.this.httpClient.executor().getExceptionListener();
            if (listener != null) {
                if (listener.listen(WebSocketCover.this, e) && WebSocketCover.this.onException != null) {
                    WebSocketCover.this.execute(() -> WebSocketCover.this.onException.on(this.webSocket, t), WebSocketCover.this.exceptionOnIO);
                }
            } else if (WebSocketCover.this.onException != null) {
                WebSocketCover.this.execute(() -> WebSocketCover.this.onException.on(this.webSocket, t), WebSocketCover.this.exceptionOnIO);
            } else if (!WebSocketCover.this.nothrow) {
                throw new InstrumentException("WebSocket exception", t);
            }
        }
    }

    static class WebSocketImpl
    implements Sockets {
        private final List<Object> queues = new ArrayList<Object>();
        private boolean cancelOrClosed;
        private WebSocket webSocket;
        private TaskExecutor taskExecutor;
        private Charset charset;
        private String msgType;

        public WebSocketImpl(TaskExecutor taskExecutor, String msgType) {
            this.taskExecutor = taskExecutor;
            this.msgType = msgType;
        }

        public void setCharset(Charset charset) {
            this.charset = charset;
        }

        @Override
        public synchronized boolean cancel() {
            if (this.webSocket != null) {
                this.webSocket.cancel();
            }
            this.cancelOrClosed = true;
            return true;
        }

        @Override
        public synchronized boolean close(int code, String reason) {
            if (this.webSocket != null) {
                this.webSocket.close(code, reason);
            }
            this.cancelOrClosed = true;
            return true;
        }

        @Override
        public void msgType(String type) {
            if (type == null || type.equalsIgnoreCase("form")) {
                throw new IllegalArgumentException("msgType \u4e0d\u53ef\u4e3a\u7a7a \u6216 form");
            }
            this.msgType = type;
        }

        @Override
        public long queueSize() {
            if (this.webSocket != null) {
                return this.webSocket.queueSize();
            }
            return this.queues.size();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean send(Object msg) {
            if (msg == null) {
                return false;
            }
            List<Object> list = this.queues;
            synchronized (list) {
                if (this.webSocket != null) {
                    return this.send(this.webSocket, msg);
                }
                this.queues.add(msg);
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void setWebSocket(WebSocket webSocket) {
            List<Object> list = this.queues;
            synchronized (list) {
                for (Object msg : this.queues) {
                    this.send(webSocket, msg);
                }
                this.webSocket = webSocket;
                this.queues.clear();
            }
        }

        boolean send(WebSocket webSocket, Object msg) {
            if (msg == null) {
                return false;
            }
            if (msg instanceof String) {
                return webSocket.send((String)msg);
            }
            if (msg instanceof ByteString) {
                return webSocket.send((ByteString)msg);
            }
            if (msg instanceof byte[]) {
                return webSocket.send(ByteString.of((byte[])msg));
            }
            byte[] bytes = (byte[])this.taskExecutor.doMsgConvert((String)this.msgType, (TaskExecutor.ConvertFunc<byte[]>)LambdaMetafactory.metafactory(null, null, null, (Lorg/aoju/bus/http/metric/Convertor;)Ljava/lang/Object;, lambda$send$0(java.lang.Object org.aoju.bus.http.metric.Convertor ), (Lorg/aoju/bus/http/metric/Convertor;)[B)((WebSocketImpl)this, (Object)msg)).data;
            return webSocket.send(new String(bytes, this.charset));
        }

        private /* synthetic */ byte[] lambda$send$0(Object msg, Convertor c) {
            return c.serialize(msg, this.charset);
        }
    }

    public static interface Sockets
    extends Cancelable {
        public long queueSize();

        public boolean send(Object var1);

        public boolean close(int var1, String var2);

        public void msgType(String var1);

        public static class Close {
            public static int CANCELED = 0;
            public static int EXCEPTION = -1;
            public static int NETWORK_ERROR = -2;
            public static int TIMEOUT = -3;
            private int code;
            private String reason;

            public Close(int code, String reason) {
                this.code = code;
                this.reason = reason;
            }

            public int getCode() {
                return this.code;
            }

            public String getReason() {
                return this.reason;
            }

            public boolean isCanceled() {
                return this.code == CANCELED;
            }

            public boolean isException() {
                return this.code == EXCEPTION;
            }

            public boolean isNetworkError() {
                return this.code == NETWORK_ERROR;
            }

            public boolean isTimeout() {
                return this.code == TIMEOUT;
            }

            public String toString() {
                return "Close [code=" + this.code + ", reason=" + this.reason + "]";
            }
        }

        public static interface Listener<T> {
            public void on(Sockets var1, T var2);
        }

        public static interface Message
        extends Toable {
            public boolean isText();
        }
    }
}

