/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.image;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.aoju.bus.core.toolkit.StreamKit;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.image.Status;
import org.aoju.bus.image.UID;
import org.aoju.bus.image.galaxy.data.Attributes;
import org.aoju.bus.image.galaxy.data.BulkData;
import org.aoju.bus.image.galaxy.data.ElementDictionary;
import org.aoju.bus.image.galaxy.data.VR;
import org.aoju.bus.image.galaxy.io.ImageInputStream;
import org.aoju.bus.image.galaxy.io.ImageOutputStream;
import org.aoju.bus.image.metric.Progress;
import org.aoju.bus.image.nimble.codec.jpeg.JPEGHeader;
import org.aoju.bus.image.nimble.codec.mpeg.MPEGHeader;
import org.aoju.bus.logger.Logger;

public class Builder {
    public static final int APP_CONTEXT = 16;
    public static final int RQ_PRES_CONTEXT = 32;
    public static final int AC_PRES_CONTEXT = 33;
    public static final int ABSTRACT_SYNTAX = 48;
    public static final int TRANSFER_SYNTAX = 64;
    public static final int USER_INFO = 80;
    public static final int MAX_PDU_LENGTH = 81;
    public static final int IMPL_CLASS_UID = 82;
    public static final int ASYNC_OPS_WINDOW = 83;
    public static final int ROLE_SELECTION = 84;
    public static final int IMPL_VERSION_NAME = 85;
    public static final int EXT_NEG = 86;
    public static final int COMMON_EXT_NEG = 87;
    public static final int RQ_USER_IDENTITY = 88;
    public static final int AC_USER_IDENTITY = 89;
    public static final int MAGIC_LEN = 64507;
    public static final int KNOWN_INCONSISTENCIES = 65535;
    public static final int NO_KNOWN_INCONSISTENCIES = 0;
    public static final int IN_USE = 65535;
    public static final int IN_ACTIVE = 0;
    public static final String FAILED = "FAILED";
    public static final String WARNING = "WARNING";
    public static final String COMPLETED = "COMPLETED";
    public static final int FILE_BUFFER = 4096;
    public static final String SegmentSequenceError = "100";
    public static final String RequiredFieldMissing = "101";
    public static final String DataTypeError = "102";
    public static final String TableValueNotFound = "103";
    public static final String UnsupportedMessageType = "200";
    public static final String UnsupportedEventCode = "201";
    public static final String UnsupportedProcessingID = "202";
    public static final String UnsupportedVersionID = "203";
    public static final String UnknownKeyIdentifier = "204";
    public static final String DuplicateKeyIdentifier = "205";
    public static final String ApplicationRecordLocked = "206";
    public static final String ApplicationInternalError = "207";
    public static final String UnknownSendingApplication = "MSH^1^3";
    public static final String UnknownSendingFacility = "MSH^1^4";
    public static final String UnknownReceivingApplication = "MSH^1^5";
    public static final String UnknownReceivingFacility = "MSH^1^6";
    public static final int MAX_PACKAGE_LEN = 65536;
    public static final int A_ASSOCIATE_RQ = 1;
    public static final int A_ASSOCIATE_AC = 2;
    public static final int A_ASSOCIATE_RJ = 3;
    public static final int P_DATA_TF = 4;
    public static final int A_RELEASE_RQ = 5;
    public static final int A_RELEASE_RP = 6;
    public static final int A_ABORT = 7;
    public static final int DATA = 0;
    public static final int COMMAND = 1;
    public static final int PENDING = 0;
    public static final int LAST = 2;
    public static final String IMAGE_ORIGINAL_SUFFIX = ".dcm";
    public static final String IMAGE_CONVERT_SUFFIX = ".jpg";
    private static final int INIT_BUFFER_SIZE = 8192;
    private static final int MAX_BUFFER_SIZE = 0xA00008;

    public static String toUID(String uid) {
        return "*".equals(uid = uid.trim()) || Character.isDigit(uid.charAt(0)) ? uid : UID.forName(uid);
    }

    public static String[] toUIDs(String s) {
        if ("*".equals(s)) {
            return new String[]{"*"};
        }
        String[] uids = StringKit.split((CharSequence)s, ",");
        for (int i = 0; i < uids.length; ++i) {
            uids[i] = Builder.toUID(uids[i]);
        }
        return uids;
    }

    public static void close(ImageInputStream in) {
        if (in != null) {
            for (File file : in.getBulkDataFiles()) {
                Builder.delete(file);
            }
        }
    }

    public static void close(AutoCloseable object) {
        if (object != null) {
            try {
                object.close();
            }
            catch (Exception e) {
                Logger.error("Cannot close AutoCloseable", e);
            }
        }
    }

    public static void forceGettingAttributes(Status dcmState, AutoCloseable closeable) {
        Progress p = dcmState.getProgress();
        if (p != null) {
            Builder.close(closeable);
        }
    }

    public static void getAllFilesInDirectory(File directory, List<File> files, boolean recursive) {
        File[] fList;
        for (File f : fList = directory.listFiles()) {
            if (f.isFile()) {
                files.add(f);
                continue;
            }
            if (!recursive || !f.isDirectory()) continue;
            Builder.getAllFilesInDirectory(f, files, recursive);
        }
    }

    private static boolean deleteFile(File fileOrDirectory) {
        try {
            Files.delete(fileOrDirectory.toPath());
        }
        catch (Exception e) {
            Logger.error("Cannot delete", e);
            return false;
        }
        return true;
    }

    public static boolean delete(File fileOrDirectory) {
        File[] files;
        if (fileOrDirectory == null || !fileOrDirectory.exists()) {
            return false;
        }
        if (fileOrDirectory.isDirectory() && (files = fileOrDirectory.listFiles()) != null) {
            for (File child : files) {
                Builder.delete(child);
            }
        }
        return Builder.deleteFile(fileOrDirectory);
    }

    public static void prepareToWriteFile(File file) throws IOException {
        File outputDir;
        if (!(file.exists() || (outputDir = file.getParentFile()) == null || outputDir.exists() || outputDir.mkdirs())) {
            throw new IOException("Cannot write parent directory of " + file.getPath());
        }
    }

    public static String humanReadableByte(long bytes, boolean si) {
        int unit;
        int n = unit = si ? 1000 : 1024;
        if (bytes < (long)unit) {
            return bytes + " B";
        }
        int exp = (int)(Math.log(bytes) / Math.log(unit));
        String pre = (si ? "kMGTPE" : "KMGTPE").charAt(exp - 1) + (si ? "" : "i");
        return String.format("%.1f %sB", (double)bytes / Math.pow(unit, exp), pre);
    }

    public static void notify(Status state, String iuid, String cuid, int intStatus, String status, int numberOfSuboperations) {
        state.setStatus(intStatus);
        Progress p = state.getProgress();
        if (p != null) {
            Attributes cmd = Optional.ofNullable(p.getAttributes()).orElseGet(Attributes::new);
            cmd.setInt(2304, VR.US, intStatus);
            cmd.setString(4096, VR.UI, iuid);
            cmd.setString(2, VR.UI, cuid);
            Builder.notify(p, cmd, status, numberOfSuboperations);
            p.setAttributes(cmd);
        }
    }

    public static void notify(Progress progress, Attributes attributes, String status, int numberOfSuboperations) {
        if (progress != null && attributes != null) {
            int r;
            int w;
            int f;
            int c;
            if (progress.getAttributes() == null) {
                c = 0;
                f = 0;
                w = 0;
                r = numberOfSuboperations;
            } else {
                c = progress.getNumberOfCompletedSuboperations();
                f = progress.getNumberOfFailedSuboperations();
                w = progress.getNumberOfWarningSuboperations();
                r = numberOfSuboperations - (c + f + w);
            }
            if (r < 1) {
                r = 1;
            }
            if (COMPLETED.equals(status) || FAILED.equals(status) || WARNING.equals(status)) {
                // empty if block
            }
            attributes.setInt(4129, VR.US, ++c);
            attributes.setInt(4130, VR.US, ++f);
            attributes.setInt(4131, VR.US, ++w);
            attributes.setInt(4128, VR.US, r - 1);
        }
    }

    public static void pdf(Attributes attrs, File pdfFile, File dcmFile) throws IOException {
        attrs.setString(524310, VR.UI, "1.2.840.10008.5.1.4.1.1.104.1");
        Builder.ensureString(attrs, 524293, VR.CS, "ISO_IR 192");
        Builder.ensureUID(attrs, 0x20000D);
        Builder.ensureUID(attrs, 0x20000E);
        Builder.ensureUID(attrs, 524312);
        Builder.setCreationDate(attrs);
        BulkData bulk = new BulkData(pdfFile.toURI().toString(), 0L, (int)pdfFile.length(), false);
        attrs.setValue(4325393, VR.OB, bulk);
        attrs.setString(4325394, VR.LO, "application/pdf");
        Attributes fmi = attrs.createFileMetaInformation("1.2.840.10008.1.2.1");
        try (ImageOutputStream dos = new ImageOutputStream(dcmFile);){
            dos.writeDataset(fmi, attrs);
        }
    }

    public static void jpeg(Attributes attrs, File jpgFile, File dcmFile, boolean noAPPn) {
        Builder.build(attrs, jpgFile, dcmFile, noAPPn, false);
    }

    public static void mpeg2(Attributes attrs, File mpegFile, File dcmFile) {
        Builder.build(attrs, mpegFile, dcmFile, false, true);
    }

    private static void build(Attributes attrs, File jpgFile, File dcmFile, boolean noAPPn, boolean mpeg) {
        Parameters p = new Parameters();
        p.fileLength = (int)jpgFile.length();
        try (BufferedInputStream bis = new BufferedInputStream(new FileInputStream(jpgFile));){
            if (!Builder.readPixelHeader(p, attrs, bis, mpeg)) {
                throw new IOException("Cannot read the header of " + jpgFile.getPath());
            }
            int itemLen = p.fileLength;
            try (ImageOutputStream dos = new ImageOutputStream(dcmFile);){
                Builder.ensureString(attrs, 524293, VR.CS, "ISO_IR 192");
                Builder.ensureUID(attrs, 0x20000D);
                Builder.ensureUID(attrs, 0x20000E);
                Builder.ensureUID(attrs, 524312);
                Builder.setCreationDate(attrs);
                dos.writeDataset(attrs.createFileMetaInformation(mpeg ? "1.2.840.10008.1.2.4.100" : "1.2.840.10008.1.2.4.50"), attrs);
                dos.writeHeader(2145386512, VR.OB, -1);
                dos.writeHeader(-73728, null, 0);
                if (p.jpegHeader != null && noAPPn) {
                    int offset = p.jpegHeader.offsetAfterAPP();
                    dos.writeHeader(-73728, null, (itemLen -= offset - 3) + 1 & 0xFFFFFFFE);
                    dos.write(-1);
                    dos.write(-40);
                    dos.write(-1);
                    dos.write(p.buffer, offset, p.realBufferLength - offset);
                } else {
                    dos.writeHeader(-73728, null, itemLen + 1 & 0xFFFFFFFE);
                    dos.write(p.buffer, 0, p.realBufferLength);
                }
                StreamKit.copy((InputStream)bis, (OutputStream)dos, p.buffer);
                if ((itemLen & 1) != 0) {
                    dos.write(0);
                }
                dos.writeHeader(-73507, null, 0);
            }
        }
        catch (Exception e) {
            Logger.error("Building {}", mpeg ? "mpeg" : "jpg", e);
        }
    }

    private static boolean readPixelHeader(Parameters p, Attributes metadata, InputStream in, boolean mpeg) throws IOException {
        int grow = 8192;
        while (p.realBufferLength == p.buffer.length && p.realBufferLength < 0xA00008) {
            boolean jpgHeader;
            p.buffer = Arrays.copyOf(p.buffer, grow += p.realBufferLength);
            p.realBufferLength += StreamKit.readAvailable(in, p.buffer, p.realBufferLength, p.buffer.length - p.realBufferLength);
            if (mpeg) {
                MPEGHeader mpegHeader = new MPEGHeader(p.buffer);
                jpgHeader = mpegHeader.toAttributes(metadata, p.fileLength) != null;
            } else {
                p.jpegHeader = new JPEGHeader(p.buffer, 218);
                boolean bl = jpgHeader = p.jpegHeader.toAttributes(metadata) != null;
            }
            if (!jpgHeader) continue;
            Builder.ensureString(metadata, 524310, VR.UI, mpeg ? "1.2.840.10008.5.1.4.1.1.77.1.4.1" : "1.2.840.10008.5.1.4.1.1.77.1.4");
            return true;
        }
        return false;
    }

    private static void setCreationDate(Attributes attrs) {
        Date now = new Date();
        attrs.setDate(524306, VR.DA, now);
        attrs.setDate(524307, VR.TM, now);
    }

    private static void ensureString(Attributes attrs, int tag, VR vr, String value) {
        if (!attrs.containsValue(tag)) {
            attrs.setString(tag, vr, value);
        }
    }

    private static void ensureUID(Attributes attrs, int tag) {
        if (!attrs.containsValue(tag)) {
            attrs.setString(tag, VR.UI, UID.createUID());
        }
    }

    public static boolean updateAttributes(Attributes data, Attributes attrs, String uidSuffix) {
        if (attrs.isEmpty() && uidSuffix == null) {
            return false;
        }
        if (uidSuffix != null) {
            data.setString(0x20000D, VR.UI, data.getString(0x20000D) + uidSuffix);
            data.setString(0x20000E, VR.UI, data.getString(0x20000E) + uidSuffix);
            data.setString(524312, VR.UI, data.getString(524312) + uidSuffix);
        }
        data.update(Attributes.UpdatePolicy.OVERWRITE, attrs, null);
        return true;
    }

    public static int toTag(String tagOrKeyword) {
        try {
            return Integer.parseInt(tagOrKeyword, 16);
        }
        catch (IllegalArgumentException e) {
            int tag = ElementDictionary.tagForKeyword(tagOrKeyword, null);
            if (tag == -1) {
                throw new IllegalArgumentException(tagOrKeyword);
            }
            return tag;
        }
    }

    private static class Parameters {
        int realBufferLength = 0;
        byte[] buffer = new byte[0];
        int fileLength = 0;
        JPEGHeader jpegHeader;

        private Parameters() {
        }
    }
}

