/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.image.centre;

import java.io.IOException;
import java.net.URL;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.toolkit.ObjectKit;
import org.aoju.bus.image.centre.AbstractCentre;
import org.aoju.bus.image.metric.Connection;
import org.aoju.bus.image.metric.TransferCapability;
import org.aoju.bus.image.plugin.StoreSCP;

public class StoreSCPCentre
extends AbstractCentre {
    protected StoreSCP storeSCP;
    protected ExecutorService executor;
    protected ScheduledExecutorService scheduledExecutor;

    public static StoreSCPCentre Builder() {
        return new StoreSCPCentre();
    }

    @Override
    public boolean isRunning() {
        return this.storeSCP.getConnection().isListening();
    }

    @Override
    public synchronized void start() {
        if (this.isRunning()) {
            throw new InstrumentException("Cannot start a Listener because it is already running.");
        }
        this.storeSCP.setStatus(0);
        Connection conn = this.storeSCP.getConnection();
        if (this.args.isBindCallingAet()) {
            this.args.configureBind(this.storeSCP.getApplicationEntity(), conn, this.node);
        } else {
            this.args.configureBind(conn, this.node);
        }
        this.args.configure(conn);
        try {
            this.args.configureTLS(conn, null);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.storeSCP.getApplicationEntity().setAcceptedCallingAETitles(this.args.getAcceptedCallingAETitles());
        URL transferCapabilityFile = this.args.getTransferCapabilityFile();
        if (transferCapabilityFile != null) {
            this.storeSCP.loadDefaultTransferCapability(transferCapabilityFile);
        } else {
            this.storeSCP.getApplicationEntity().addTransferCapability(new TransferCapability(null, "*", TransferCapability.Role.SCP, "*"));
        }
        this.device.start();
    }

    @Override
    public synchronized void stop() {
        if (this.device != null) {
            this.device.stop();
        }
        if (this.executor != null) {
            this.executor.shutdown();
            this.scheduledExecutor = null;
        }
        if (this.scheduledExecutor != null) {
            this.scheduledExecutor.shutdown();
            this.executor = null;
        }
    }

    @Override
    public StoreSCPCentre build() {
        if (this.executor != null) {
            throw new IllegalStateException("Already started");
        }
        if (ObjectKit.isEmpty((Object)this.node)) {
            throw new NullPointerException("The node cannot be null.");
        }
        if (ObjectKit.isEmpty((Object)this.args)) {
            throw new NullPointerException("The args cannot be null.");
        }
        if (ObjectKit.isEmpty((Object)this.device)) {
            throw new NullPointerException("The device cannot be null.");
        }
        if (this.rollers != null) {
            this.storeSCP.setRollers(this.rollers);
        }
        this.executor = this.executerService();
        this.scheduledExecutor = this.scheduledExecuterService();
        this.device.setExecutor(this.executor);
        this.device.setScheduledExecutor(this.scheduledExecutor);
        return this;
    }

    public StoreSCP getStoreSCP() {
        return this.storeSCP;
    }

    public void setStoreSCP(String path) {
        this.storeSCP = new StoreSCP(path);
    }

    protected ExecutorService executerService() {
        return Executors.newCachedThreadPool();
    }

    protected ScheduledExecutorService scheduledExecuterService() {
        return Executors.newSingleThreadScheduledExecutor();
    }
}

