/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.image.plugin;

import java.io.File;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.concurrent.ExecutorService;
import org.aoju.bus.core.toolkit.IoKit;
import org.aoju.bus.image.Builder;
import org.aoju.bus.image.Device;
import org.aoju.bus.image.Status;
import org.aoju.bus.image.galaxy.data.Attributes;
import org.aoju.bus.image.galaxy.data.ElementDictionary;
import org.aoju.bus.image.galaxy.data.VR;
import org.aoju.bus.image.galaxy.io.ImageInputStream;
import org.aoju.bus.image.galaxy.io.ImageOutputStream;
import org.aoju.bus.image.metric.ApplicationEntity;
import org.aoju.bus.image.metric.Association;
import org.aoju.bus.image.metric.Connection;
import org.aoju.bus.image.metric.DimseRSPHandler;
import org.aoju.bus.image.metric.ImageException;
import org.aoju.bus.image.metric.PDVInputStream;
import org.aoju.bus.image.metric.Progress;
import org.aoju.bus.image.metric.internal.pdu.AAssociateRQ;
import org.aoju.bus.image.metric.internal.pdu.ExtendedNegotiate;
import org.aoju.bus.image.metric.internal.pdu.Presentation;
import org.aoju.bus.image.metric.internal.pdu.RoleSelection;
import org.aoju.bus.image.metric.service.BasicCStoreSCP;
import org.aoju.bus.image.metric.service.ServiceHandler;
import org.aoju.bus.logger.Logger;

public class GetSCU
implements AutoCloseable {
    private static final int[] DEF_IN_FILTER = new int[]{524312, 0x20000D, 0x20000E};
    private static final String TMP_DIR = "tmp";
    private final Device device = new Device("getscu");
    private final ApplicationEntity ae;
    private final Connection conn = new Connection();
    private final Connection remote = new Connection();
    private final AAssociateRQ rq = new AAssociateRQ();
    private final Status state;
    private int priority;
    private InformationModel model;
    private File storageDir;
    private Attributes keys = new Attributes();
    private int[] inFilter = DEF_IN_FILTER;
    private Association as;
    private DimseRSPHandler rspHandler;
    private BasicCStoreSCP storageSCP = new BasicCStoreSCP(new String[]{"*"}){

        @Override
        protected void store(Association as, Presentation pc, Attributes rq, PDVInputStream data, Attributes rsp) throws IOException {
            if (GetSCU.this.storageDir == null) {
                return;
            }
            String iuid = rq.getString(4096);
            String cuid = rq.getString(2);
            String tsuid = pc.getTransferSyntax();
            File file = new File(GetSCU.this.storageDir, GetSCU.TMP_DIR + File.separator + iuid);
            try {
                GetSCU.storeTo(as, as.createFileMetaInformation(iuid, cuid, tsuid), data, file);
                GetSCU.renameTo(as, file, new File(GetSCU.this.storageDir, iuid));
            }
            catch (Exception e) {
                throw new ImageException(272, (Throwable)e);
            }
            GetSCU.this.updateProgress(as, null);
        }
    };

    public GetSCU() {
        this(null);
    }

    public GetSCU(Progress progress) {
        this.ae = new ApplicationEntity("GETSCU");
        this.device.addConnection(this.conn);
        this.device.addApplicationEntity(this.ae);
        this.ae.addConnection(this.conn);
        this.device.setDimseRQHandler(this.createServiceRegistry());
        this.state = new Status(progress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void storeTo(Association as, Attributes fmi, PDVInputStream data, File file) throws IOException {
        Logger.debug("{}: M-WRITE {}", as, file);
        file.getParentFile().mkdirs();
        ImageOutputStream out = new ImageOutputStream(file);
        try {
            out.writeFileMetaInformation(fmi);
            data.copyTo(out);
        }
        finally {
            IoKit.close(out);
        }
    }

    private static void renameTo(Association as, File from, File dest) throws IOException {
        Logger.info("{}: M-RENAME {} to {}", as, from, dest);
        Builder.prepareToWriteFile(dest);
        if (!from.renameTo(dest)) {
            throw new IOException("Failed to rename " + from + " to " + dest);
        }
    }

    public ApplicationEntity getApplicationEntity() {
        return this.ae;
    }

    public Connection getRemoteConnection() {
        return this.remote;
    }

    public AAssociateRQ getAAssociateRQ() {
        return this.rq;
    }

    public Association getAssociation() {
        return this.as;
    }

    public Device getDevice() {
        return this.device;
    }

    public Attributes getKeys() {
        return this.keys;
    }

    private ServiceHandler createServiceRegistry() {
        ServiceHandler serviceHandler = new ServiceHandler();
        serviceHandler.addService(this.storageSCP);
        return serviceHandler;
    }

    public void setStorageDirectory(File storageDir) {
        if (storageDir != null && storageDir.mkdirs()) {
            System.out.println("M-WRITE " + storageDir);
        }
        this.storageDir = storageDir;
    }

    public final void setPriority(int priority) {
        this.priority = priority;
    }

    public final void setInformationModel(InformationModel model, String[] tss, boolean relational) {
        this.model = model;
        this.rq.addPresentationContext(new Presentation(1, model.cuid, tss));
        if (relational) {
            this.rq.addExtendedNegotiate(new ExtendedNegotiate(model.cuid, new byte[]{1}));
        }
        if (model.level != null) {
            this.addLevel(model.level);
        }
    }

    public void addLevel(String s) {
        this.keys.setString(524370, VR.CS, s);
    }

    public void addKey(int tag, String ... ss) {
        VR vr = ElementDictionary.vrOf(tag, this.keys.getPrivateCreator(tag));
        this.keys.setString(tag, vr, ss);
    }

    public final void setInputFilter(int[] inFilter) {
        this.inFilter = inFilter;
    }

    public void addOfferedStorageSOPClass(String cuid, String ... tsuids) {
        if (!this.rq.containsPresentationContextFor(cuid)) {
            this.rq.addRoleSelection(new RoleSelection(cuid, false, true));
        }
        this.rq.addPresentationContext(new Presentation(2 * this.rq.getNumberOfPresentationContexts() + 1, cuid, tsuids));
    }

    public void open() throws IOException, InterruptedException, GeneralSecurityException {
        this.as = this.ae.connect(this.conn, this.remote, this.rq);
    }

    @Override
    public void close() throws IOException, InterruptedException {
        if (this.as != null && this.as.isReadyForDataTransfer()) {
            this.as.waitForOutstandingRSP();
            this.as.release();
        }
    }

    public void retrieve(File f) throws IOException, InterruptedException {
        Attributes attrs = new Attributes();
        try (ImageInputStream dis = new ImageInputStream(f);){
            attrs.addSelected(dis.readDataset(-1, -1), this.inFilter);
        }
        attrs.addAll(this.keys);
        this.retrieve(attrs);
    }

    public void retrieve() throws IOException, InterruptedException {
        this.retrieve(this.keys);
    }

    private void retrieve(Attributes keys) throws IOException, InterruptedException {
        DimseRSPHandler rspHandler = new DimseRSPHandler(this.as.nextMessageID()){

            @Override
            public void onDimseRSP(Association as, Attributes cmd, Attributes data) {
                super.onDimseRSP(as, cmd, data);
                GetSCU.this.updateProgress(as, cmd);
            }
        };
        this.retrieve(keys, rspHandler);
    }

    public void retrieve(DimseRSPHandler rspHandler) throws IOException, InterruptedException {
        this.retrieve(this.keys, rspHandler);
    }

    private void retrieve(Attributes keys, DimseRSPHandler rspHandler) throws IOException, InterruptedException {
        this.rspHandler = rspHandler;
        this.as.cget(this.model.getCuid(), this.priority, keys, null, rspHandler);
    }

    public Connection getConnection() {
        return this.conn;
    }

    public Status getState() {
        return this.state;
    }

    public void stop() {
        try {
            this.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        ((ExecutorService)this.device.getExecutor()).shutdown();
        this.device.getScheduledExecutor().shutdown();
    }

    private void updateProgress(Association as, Attributes cmd) {
        Progress p = this.state.getProgress();
        if (p != null) {
            p.setAttributes(cmd);
            if (p.isCancel() && this.rspHandler != null) {
                try {
                    this.rspHandler.cancel(as);
                }
                catch (IOException e) {
                    Logger.error("Cancel C-GET", e);
                }
            }
        }
    }

    public static enum InformationModel {
        PatientRoot("1.2.840.10008.5.1.4.1.2.1.3", "STUDY"),
        StudyRoot("1.2.840.10008.5.1.4.1.2.2.3", "STUDY"),
        PatientStudyOnly("1.2.840.10008.5.1.4.1.2.3.3", "STUDY"),
        CompositeInstanceRoot("1.2.840.10008.5.1.4.1.2.4.3", "IMAGE"),
        WithoutBulkData("1.2.840.10008.5.1.4.1.2.5.3", null),
        HangingProtocol("1.2.840.10008.5.1.4.38.4", null),
        ColorPalette("1.2.840.10008.5.1.4.39.4", null);

        final String level;
        private final String cuid;

        private InformationModel(String cuid, String level) {
            this.cuid = cuid;
            this.level = level;
        }

        public String getCuid() {
            return this.cuid;
        }
    }
}

