/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.image.plugin;

import java.io.File;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.toolkit.IoKit;
import org.aoju.bus.image.Builder;
import org.aoju.bus.image.Dimse;
import org.aoju.bus.image.UID;
import org.aoju.bus.image.galaxy.data.Attributes;
import org.aoju.bus.image.galaxy.data.Sequence;
import org.aoju.bus.image.galaxy.data.VR;
import org.aoju.bus.image.galaxy.io.ImageOutputStream;
import org.aoju.bus.image.metric.ApplicationEntity;
import org.aoju.bus.image.metric.Association;
import org.aoju.bus.image.metric.Commands;
import org.aoju.bus.image.metric.Connection;
import org.aoju.bus.image.metric.DimseRSPHandler;
import org.aoju.bus.image.metric.ImageException;
import org.aoju.bus.image.metric.TransferCapability;
import org.aoju.bus.image.metric.internal.pdu.AAssociateRQ;
import org.aoju.bus.image.metric.internal.pdu.Presentation;
import org.aoju.bus.image.metric.service.AbstractService;
import org.aoju.bus.image.metric.service.BasicCEchoSCP;
import org.aoju.bus.image.metric.service.ImageService;
import org.aoju.bus.image.metric.service.ServiceHandler;
import org.aoju.bus.logger.Logger;

public class StgCmtSCU {
    private final ApplicationEntity ae;
    private final Connection remote;
    private final AAssociateRQ rq = new AAssociateRQ();
    private final HashSet<String> outstandingResults = new HashSet(2);
    private final HashMap<String, List<String>> map = new HashMap();
    private Attributes attrs;
    private String uidSuffix;
    private File storageDir;
    private boolean keepAlive;
    private int splitTag;
    private int status;
    private final ImageService stgcmtResultHandler = new AbstractService(new String[]{"1.2.840.10008.1.20.1"}){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onDimse(Association as, Presentation pc, Dimse dimse, Attributes cmd, Attributes data) throws IOException {
            if (dimse != Dimse.N_EVENT_REPORT_RQ) {
                throw new ImageException(529);
            }
            int eventTypeID = cmd.getInt(4098, 0);
            if (eventTypeID != 1 && eventTypeID != 2) {
                throw new ImageException(275).setEventTypeID(eventTypeID);
            }
            String tuid = data.getString(528789);
            try {
                Attributes rsp = Commands.mkNEventReportRSP(cmd, StgCmtSCU.this.status);
                Attributes rspAttrs = StgCmtSCU.this.eventRecord(as, cmd, data);
                as.writeDimseRSP(pc, rsp, rspAttrs);
            }
            catch (InstrumentException e) {
                Logger.warn("{} << N-EVENT-RECORD-RSP failed: {}", as, e.getMessage());
            }
            finally {
                StgCmtSCU.this.removeOutstandingResult(tuid);
            }
        }
    };
    private Association as;

    public StgCmtSCU(ApplicationEntity ae) {
        this.remote = new Connection();
        this.ae = ae;
        ServiceHandler serviceHandler = new ServiceHandler();
        serviceHandler.addService(new BasicCEchoSCP());
        serviceHandler.addService(this.stgcmtResultHandler);
        ae.setDimseRQHandler(serviceHandler);
    }

    public Connection getRemoteConnection() {
        return this.remote;
    }

    public AAssociateRQ getAAssociateRQ() {
        return this.rq;
    }

    public File getStorageDirectory() {
        return this.storageDir;
    }

    public void setStorageDirectory(File storageDir) {
        if (storageDir != null) {
            storageDir.mkdirs();
        }
        this.storageDir = storageDir;
    }

    public final void setUIDSuffix(String uidSuffix) {
        this.uidSuffix = uidSuffix;
    }

    public void setAttributes(Attributes attrs) {
        this.attrs = attrs;
    }

    public void setSplitTag(int splitTag) {
        this.splitTag = splitTag;
    }

    public void setKeepAlive(boolean keepAlive) {
        this.keepAlive = keepAlive;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public void setTransferSyntaxes(String[] tss) {
        this.rq.addPresentationContext(new Presentation(1, "1.2.840.10008.1.1", "1.2.840.10008.1.2"));
        this.rq.addPresentationContext(new Presentation(2, "1.2.840.10008.1.20.1", tss));
        this.ae.addTransferCapability(new TransferCapability(null, "1.2.840.10008.1.1", TransferCapability.Role.SCP, "1.2.840.10008.1.2"));
        this.ae.addTransferCapability(new TransferCapability(null, "1.2.840.10008.1.20.1", TransferCapability.Role.SCU, tss));
    }

    public boolean addInstance(Attributes inst) {
        String splitkey;
        Builder.updateAttributes(inst, this.attrs, this.uidSuffix);
        String cuid = inst.getString(524310);
        String iuid = inst.getString(524312);
        String string = splitkey = this.splitTag != 0 ? inst.getString(this.splitTag) : "";
        if (cuid == null || iuid == null || splitkey == null) {
            return false;
        }
        List<String> refSOPs = this.map.get(splitkey);
        if (refSOPs == null) {
            refSOPs = new ArrayList<String>();
            this.map.put(splitkey, refSOPs);
        }
        refSOPs.add(cuid);
        refSOPs.add(iuid);
        return true;
    }

    public void open() throws IOException, InterruptedException, InstrumentException, GeneralSecurityException {
        this.as = this.ae.connect(this.remote, this.rq);
    }

    public void echo() throws IOException, InterruptedException {
        this.as.cecho().next();
    }

    public void close() throws IOException, InterruptedException {
        if (this.as != null) {
            if (this.as.isReadyForDataTransfer()) {
                this.as.waitForOutstandingRSP();
                if (this.keepAlive) {
                    this.waitForOutstandingResults();
                }
                this.as.release();
            }
            this.as.waitForSocketClose();
        }
        this.waitForOutstandingResults();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addOutstandingResult(String tuid) {
        HashSet<String> hashSet = this.outstandingResults;
        synchronized (hashSet) {
            this.outstandingResults.add(tuid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeOutstandingResult(String tuid) {
        HashSet<String> hashSet = this.outstandingResults;
        synchronized (hashSet) {
            this.outstandingResults.remove(tuid);
            this.outstandingResults.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForOutstandingResults() throws InterruptedException {
        HashSet<String> hashSet = this.outstandingResults;
        synchronized (hashSet) {
            while (!this.outstandingResults.isEmpty()) {
                Logger.info("" + this.outstandingResults.size(), new Object[0]);
                this.outstandingResults.wait();
            }
        }
    }

    public Attributes makeActionInfo(List<String> refSOPs) {
        Attributes actionInfo = new Attributes(2);
        actionInfo.setString(528789, VR.UI, UID.createUID());
        int n = refSOPs.size() / 2;
        Sequence refSOPSeq = actionInfo.newSequence(528793, n);
        int i = 0;
        for (int j = 0; j < n; ++j) {
            Attributes refSOP = new Attributes(2);
            refSOP.setString(528720, VR.UI, refSOPs.get(i++));
            refSOP.setString(528725, VR.UI, refSOPs.get(i++));
            refSOPSeq.add(refSOP);
        }
        return actionInfo;
    }

    public void sendRequests() throws IOException, InterruptedException {
        for (List<String> refSOPs : this.map.values()) {
            this.sendRequest(this.makeActionInfo(refSOPs));
        }
    }

    private void sendRequest(Attributes actionInfo) throws IOException, InterruptedException {
        final String tuid = actionInfo.getString(528789);
        DimseRSPHandler rspHandler = new DimseRSPHandler(this.as.nextMessageID()){

            @Override
            public void onDimseRSP(Association as, Attributes cmd, Attributes data) {
                if (cmd.getInt(2304, -1) != 0) {
                    StgCmtSCU.this.removeOutstandingResult(tuid);
                }
                super.onDimseRSP(as, cmd, data);
            }
        };
        this.as.naction("1.2.840.10008.1.20.1", "1.2.840.10008.1.20.1.1", 1, actionInfo, null, rspHandler);
        this.addOutstandingResult(tuid);
    }

    private Attributes eventRecord(Association as, Attributes cmd, Attributes eventInfo) throws ImageException {
        if (this.storageDir == null) {
            return null;
        }
        String cuid = cmd.getString(2);
        String iuid = cmd.getString(4096);
        String tuid = eventInfo.getString(528789);
        File file = new File(this.storageDir, tuid);
        ImageOutputStream out = null;
        Logger.info("{}: M-WRITE {}", as, file);
        try {
            out = new ImageOutputStream(file);
            out.writeDataset(Attributes.createFileMetaInformation(iuid, cuid, "1.2.840.10008.1.2.1"), eventInfo);
        }
        catch (IOException e) {
            try {
                Logger.warn(as + ": Failed to store Storage Commitment Result:", e);
                throw new ImageException(272, (Throwable)e);
            }
            catch (Throwable throwable) {
                IoKit.close(out);
                throw throwable;
            }
        }
        IoKit.close(out);
        return null;
    }
}

