/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.mapper.handlers;

import java.lang.reflect.Proxy;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.SystemMetaObject;

public abstract class AbstractSqlHandler {
    public static final String DELEGATE_BOUNDSQL_SQL = "delegate.boundSql.sql";
    public static final String DELEGATE_MAPPED_STATEMENT = "delegate.mappedStatement";
    private static final Map<String, Boolean> SQL_PARSER_INFO_CACHE = new ConcurrentHashMap<String, Boolean>();

    protected static boolean getSqlParserInfo(MetaObject metaObject) {
        String id = AbstractSqlHandler.getMappedStatement(metaObject).getId();
        Boolean value = SQL_PARSER_INFO_CACHE.get(id);
        if (value != null) {
            return value;
        }
        String mapperName = id.substring(0, id.lastIndexOf("."));
        return SQL_PARSER_INFO_CACHE.getOrDefault(mapperName, false);
    }

    protected static MappedStatement getMappedStatement(MetaObject metaObject) {
        return (MappedStatement)metaObject.getValue(DELEGATE_MAPPED_STATEMENT);
    }

    protected static <T> T realTarget(Object target) {
        if (Proxy.isProxyClass(target.getClass())) {
            MetaObject metaObject = SystemMetaObject.forObject((Object)target);
            return AbstractSqlHandler.realTarget(metaObject.getValue("hi.target"));
        }
        return (T)target;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractSqlHandler)) {
            return false;
        }
        AbstractSqlHandler other = (AbstractSqlHandler)o;
        return other.canEqual(this);
    }

    protected boolean canEqual(Object other) {
        return other instanceof AbstractSqlHandler;
    }

    public int hashCode() {
        boolean result = true;
        return 1;
    }

    public String toString() {
        return "AbstractSqlHandler()";
    }
}

