/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.oauth.provider;

import com.alipay.api.AlipayApiException;
import com.alipay.api.AlipayClient;
import com.alipay.api.AlipayRequest;
import com.alipay.api.DefaultAlipayClient;
import com.alipay.api.request.AlipaySystemOauthTokenRequest;
import com.alipay.api.request.AlipayUserInfoShareRequest;
import com.alipay.api.response.AlipaySystemOauthTokenResponse;
import com.alipay.api.response.AlipayUserInfoShareResponse;
import org.aoju.bus.cache.metric.ExtendCache;
import org.aoju.bus.core.lang.Normal;
import org.aoju.bus.core.lang.exception.AuthorizedException;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.oauth.Builder;
import org.aoju.bus.oauth.Context;
import org.aoju.bus.oauth.Registry;
import org.aoju.bus.oauth.magic.AccToken;
import org.aoju.bus.oauth.magic.Callback;
import org.aoju.bus.oauth.magic.Property;
import org.aoju.bus.oauth.provider.DefaultProvider;

public class AlipayProvider
extends DefaultProvider {
    private AlipayClient alipayClient;

    public AlipayProvider(Context context) {
        super(context, Registry.ALIPAY);
        this.alipayClient = new DefaultAlipayClient(Registry.ALIPAY.accessToken(), context.getAppKey(), context.getAppSecret(), "json", "UTF-8", context.getPublicKey(), "RSA2");
    }

    public AlipayProvider(Context context, ExtendCache extendCache) {
        super(context, Registry.ALIPAY, extendCache);
        this.alipayClient = new DefaultAlipayClient(Registry.ALIPAY.accessToken(), context.getAppKey(), context.getAppSecret(), "json", "UTF-8", context.getPublicKey(), "RSA2");
    }

    @Override
    protected AccToken getAccessToken(Callback Callback2) {
        AlipaySystemOauthTokenResponse response;
        AlipaySystemOauthTokenRequest request = new AlipaySystemOauthTokenRequest();
        request.setGrantType("authorization_code");
        request.setCode(Callback2.getAuth_code());
        try {
            response = (AlipaySystemOauthTokenResponse)this.alipayClient.execute((AlipayRequest)request);
        }
        catch (Exception e) {
            throw new AuthorizedException(e);
        }
        if (!response.isSuccess()) {
            throw new AuthorizedException(response.getSubMsg());
        }
        return AccToken.builder().accessToken(response.getAccessToken()).uid(response.getUserId()).expireIn(Integer.parseInt(response.getExpiresIn())).refreshToken(response.getRefreshToken()).build();
    }

    @Override
    protected Property getUserInfo(AccToken token) {
        AlipayUserInfoShareResponse response;
        String accessToken = token.getAccessToken();
        AlipayUserInfoShareRequest request = new AlipayUserInfoShareRequest();
        try {
            response = (AlipayUserInfoShareResponse)this.alipayClient.execute((AlipayRequest)request, accessToken);
        }
        catch (AlipayApiException e) {
            throw new AuthorizedException(e.getErrMsg(), e);
        }
        if (!response.isSuccess()) {
            throw new AuthorizedException(response.getSubMsg());
        }
        String province = response.getProvince();
        String city = response.getCity();
        String location = String.format("%s %s", StringKit.isEmpty(province) ? "" : province, StringKit.isEmpty(city) ? "" : city);
        return Property.builder().uuid(response.getUserId()).username(StringKit.isEmpty(response.getUserName()) ? response.getNickName() : response.getUserName()).nickname(response.getNickName()).avatar(response.getAvatar()).location(location).gender(Normal.Gender.getGender(response.getGender())).token(token).source(this.source.toString()).build();
    }

    @Override
    public String authorize(String state) {
        return Builder.fromUrl(this.source.authorize()).queryParam("app_id", this.context.getAppKey()).queryParam("scope", "auth_user").queryParam("redirect_uri", this.context.getRedirectUri()).queryParam("state", this.getRealState(state)).build();
    }
}

