/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.starter.image;

import org.aoju.bus.core.toolkit.FileKit;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.image.Args;
import org.aoju.bus.image.Centre;
import org.aoju.bus.image.Node;
import org.aoju.bus.image.Rollers;
import org.aoju.bus.image.centre.StoreSCPCentre;
import org.aoju.bus.image.nimble.opencv.OpenCVNativeLoader;
import org.aoju.bus.starter.image.ImageProperties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@EnableConfigurationProperties(value={ImageProperties.class})
public class ImageConfiguration {
    @Autowired
    ImageProperties properties;
    @Autowired
    Rollers rollers;

    @Bean(initMethod="start", destroyMethod="stop")
    public Centre onStoreSCP() {
        if (this.properties.opencv) {
            new OpenCVNativeLoader().init();
        }
        StoreSCPCentre store = StoreSCPCentre.Builder();
        Args args = new Args(true);
        if (StringKit.isNotEmpty(this.properties.relClass)) {
            args.setExtendSopClassesURL(FileKit.getResource(this.properties.relClass, ImageConfiguration.class));
        }
        if (StringKit.isNotEmpty(this.properties.sopClass)) {
            args.setTransferCapabilityFile(FileKit.getResource(this.properties.sopClass, ImageConfiguration.class));
        }
        store.setArgs(args);
        store.setNode(new Node(this.properties.aeTitle, this.properties.host, Integer.valueOf(this.properties.port)));
        store.setRollers(this.rollers);
        store.setStoreSCP(this.properties.dcmPath);
        store.setDevice(store.getStoreSCP().getDevice());
        return store.build();
    }
}

