/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.starter.mapper;

import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.Statements;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.starter.mapper.AbstractSqlParserHandler;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.executor.statement.CallableStatementHandler;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.SystemMetaObject;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.RowBounds;

@Intercepts(value={@Signature(type=Executor.class, method="update", args={MappedStatement.class, Object.class})})
public class ExplainSQLHandler
extends AbstractSqlParserHandler
implements Interceptor {
    public Object intercept(Invocation invocation) throws Throwable {
        Object[] args = invocation.getArgs();
        MappedStatement ms = (MappedStatement)args[0];
        if (ms.getSqlCommandType() == SqlCommandType.DELETE || ms.getSqlCommandType() == SqlCommandType.UPDATE) {
            Object target;
            Object parameter = args[1];
            Configuration configuration = ms.getConfiguration();
            StatementHandler handler = configuration.newStatementHandler((Executor)(target = invocation.getTarget()), ms, parameter, RowBounds.DEFAULT, null, null);
            MetaObject metaObject = SystemMetaObject.forObject((Object)handler);
            if (null != metaObject) {
                Object originalObject = metaObject.getOriginalObject();
                StatementHandler statementHandler = (StatementHandler)ExplainSQLHandler.realTarget(originalObject);
                StatementHandler statementHandler2 = statementHandler = metaObject.hasGetter("delegate") ? (StatementHandler)metaObject.getValue("delegate") : statementHandler;
                if (!(statementHandler instanceof CallableStatementHandler)) {
                    boolean sqlChangedFlag = false;
                    String sql = (String)metaObject.getValue("delegate.boundSql.sql");
                    if (this.allowProcess(metaObject)) {
                        try {
                            StringBuilder sqlStringBuilder = new StringBuilder();
                            Statements statements = CCJSqlParserUtil.parseStatements((String)this.parser(metaObject, sql));
                            int i = 0;
                            for (Statement statement : statements.getStatements()) {
                                if (null == statement) continue;
                                if (i++ > 0) {
                                    sqlStringBuilder.append(';');
                                }
                                sqlStringBuilder.append(this.processParser(statement));
                            }
                            if (sqlStringBuilder.length() > 0) {
                                sql = sqlStringBuilder.toString();
                                sqlChangedFlag = true;
                            }
                        }
                        catch (JSQLParserException e) {
                            throw new InstrumentException("Failed to process, please exclude the tableName or statementId.\n Error SQL: %s", new Object[]{e, sql});
                        }
                    }
                    if (sqlChangedFlag) {
                        metaObject.setValue("delegate.boundSql.sql", (Object)sql);
                    }
                }
            }
        }
        return invocation.proceed();
    }

    public Object plugin(Object object) {
        if (object instanceof Executor) {
            return Plugin.wrap((Object)object, (Interceptor)this);
        }
        return object;
    }

    @Override
    public String toString() {
        return "ExplainSQLHandler()";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExplainSQLHandler)) {
            return false;
        }
        ExplainSQLHandler other = (ExplainSQLHandler)o;
        return other.canEqual(this);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ExplainSQLHandler;
    }

    @Override
    public int hashCode() {
        boolean result = true;
        return 1;
    }
}

