/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.toolkit;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.AbstractQueue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Deque;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.Stack;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.aoju.bus.core.collection.ArrayIterator;
import org.aoju.bus.core.collection.IteratorEnumeration;
import org.aoju.bus.core.compare.PropertyCompare;
import org.aoju.bus.core.convert.Convert;
import org.aoju.bus.core.convert.ConverterRegistry;
import org.aoju.bus.core.lang.Editor;
import org.aoju.bus.core.lang.Filter;
import org.aoju.bus.core.lang.Matcher;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.toolkit.ArrayKit;
import org.aoju.bus.core.toolkit.BeanKit;
import org.aoju.bus.core.toolkit.ClassKit;
import org.aoju.bus.core.toolkit.IterKit;
import org.aoju.bus.core.toolkit.MapKit;
import org.aoju.bus.core.toolkit.MathKit;
import org.aoju.bus.core.toolkit.ObjectKit;
import org.aoju.bus.core.toolkit.ReflectKit;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.core.toolkit.TypeKit;

public class CollKit {
    public static boolean isEmpty(Collection<?> collection) {
        return collection == null || collection.isEmpty();
    }

    public static boolean isEmpty(Map<?, ?> map) {
        return MapKit.isEmpty(map);
    }

    public static boolean isEmpty(Iterable<?> iterable) {
        return IterKit.isEmpty(iterable);
    }

    public static boolean isEmpty(Iterator<?> Iterator2) {
        return IterKit.isEmpty(Iterator2);
    }

    public static boolean isEmpty(Enumeration<?> enumeration) {
        return null == enumeration || false == enumeration.hasMoreElements();
    }

    public static boolean isNotEmpty(Collection<?> collection) {
        return false == CollKit.isEmpty(collection);
    }

    public static boolean isNotEmpty(Map<?, ?> map) {
        return MapKit.isNotEmpty(map);
    }

    public static boolean isNotEmpty(Iterable<?> iterable) {
        return IterKit.isNotEmpty(iterable);
    }

    public static boolean isNotEmpty(Iterator<?> Iterator2) {
        return IterKit.isNotEmpty(Iterator2);
    }

    public static boolean isNotEmpty(Enumeration<?> enumeration) {
        return null != enumeration && enumeration.hasMoreElements();
    }

    public static boolean hasNull(Iterable<?> iterable) {
        return IterKit.hasNull(iterable);
    }

    public static <T> Collection<T> union(Collection<T> coll1, Collection<T> coll2) {
        ArrayList<Object> list = new ArrayList<Object>();
        if (CollKit.isEmpty(coll1)) {
            list.addAll(coll2);
        } else if (CollKit.isEmpty(coll2)) {
            list.addAll(coll1);
        } else {
            Map<T, Integer> map1 = CollKit.countMap(coll1);
            Map<T, Integer> map2 = CollKit.countMap(coll2);
            HashSet<T> elts = CollKit.newHashSet(coll2);
            elts.addAll(coll1);
            for (Object t : elts) {
                int m = Math.max(Convert.toInt(map1.get(t), 0), Convert.toInt(map2.get(t), 0));
                for (int i = 0; i < m; ++i) {
                    list.add(t);
                }
            }
        }
        return list;
    }

    public static <T> Collection<T> union(Collection<T> coll1, Collection<T> coll2, Collection<T> ... otherColls) {
        Collection<T> union = CollKit.union(coll1, coll2);
        for (Collection<T> coll : otherColls) {
            union = CollKit.union(union, coll);
        }
        return union;
    }

    public static <T> Set<T> unionDistinct(Collection<T> coll1, Collection<T> coll2, Collection<T> ... otherColls) {
        LinkedHashSet<Object> result = CollKit.isEmpty(coll1) ? new LinkedHashSet() : new LinkedHashSet<T>(coll1);
        if (CollKit.isNotEmpty(coll2)) {
            result.addAll(coll2);
        }
        if (ArrayKit.isNotEmpty(otherColls)) {
            for (Collection<T> otherColl : otherColls) {
                result.addAll(otherColl);
            }
        }
        return result;
    }

    public static <T> List<T> unionAll(Collection<T> coll1, Collection<T> coll2, Collection<T> ... otherColls) {
        ArrayList<Object> result = CollKit.isEmpty(coll1) ? new ArrayList() : new ArrayList<T>(coll1);
        if (CollKit.isNotEmpty(coll2)) {
            result.addAll(coll2);
        }
        if (ArrayKit.isNotEmpty(otherColls)) {
            for (Collection<T> otherColl : otherColls) {
                result.addAll(otherColl);
            }
        }
        return result;
    }

    public static <T> Collection<T> intersection(Collection<T> coll1, Collection<T> coll2) {
        ArrayList list = new ArrayList();
        if (CollKit.isNotEmpty(coll1) && CollKit.isNotEmpty(coll2)) {
            Map<T, Integer> map1 = CollKit.countMap(coll1);
            Map<T, Integer> map2 = CollKit.countMap(coll2);
            HashSet elts = CollKit.newHashSet(coll2);
            for (Object t : elts) {
                int m = Math.min(Convert.toInt(map1.get(t), 0), Convert.toInt(map2.get(t), 0));
                for (int i = 0; i < m; ++i) {
                    list.add(t);
                }
            }
        }
        return list;
    }

    public static <T> Collection<T> intersection(Collection<T> coll1, Collection<T> coll2, Collection<T> ... otherColls) {
        Collection<T> intersection = CollKit.intersection(coll1, coll2);
        if (CollKit.isEmpty(intersection)) {
            return intersection;
        }
        for (Collection<T> coll : otherColls) {
            if (!CollKit.isEmpty(intersection = CollKit.intersection(intersection, coll))) continue;
            return intersection;
        }
        return intersection;
    }

    public static <T> Collection<T> subtract(Collection<T> coll1, Collection<T> coll2) {
        Collection<T> result = ObjectKit.clone(coll1);
        result.removeAll(coll2);
        return result;
    }

    public static <T> Collection<T> disjunction(Collection<T> coll1, Collection<T> coll2) {
        if (CollKit.isEmpty(coll1)) {
            return coll2;
        }
        if (CollKit.isEmpty(coll2)) {
            return coll1;
        }
        ArrayList result = new ArrayList();
        Map<T, Integer> map1 = CollKit.countMap(coll1);
        Map<T, Integer> map2 = CollKit.countMap(coll2);
        HashSet<T> elts = CollKit.newHashSet(coll2);
        elts.addAll(coll1);
        for (Object t : elts) {
            int m = Math.abs(Convert.toInt(map1.get(t), 0) - Convert.toInt(map2.get(t), 0));
            for (int i = 0; i < m; ++i) {
                result.add(t);
            }
        }
        return result;
    }

    public static <T> boolean contains(T[] array, T element) {
        if (array == null) {
            return false;
        }
        return Arrays.stream(array).anyMatch(x -> ObjectKit.nullSafeEquals(x, element));
    }

    public static boolean contains(Collection<?> collection, Object value) {
        return CollKit.isNotEmpty(collection) && collection.contains(value);
    }

    public static boolean contains(Iterator<?> iterator, Object element) {
        if (iterator != null) {
            while (iterator.hasNext()) {
                Object candidate = iterator.next();
                if (!ObjectKit.nullSafeEquals(candidate, element)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean contains(Enumeration<?> enumeration, Object element) {
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                Object candidate = enumeration.nextElement();
                if (!ObjectKit.nullSafeEquals(candidate, element)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean containsAny(Collection<?> coll1, Collection<?> coll2) {
        if (CollKit.isEmpty(coll1) || CollKit.isEmpty(coll2)) {
            return false;
        }
        if (coll1.size() < coll2.size()) {
            for (Object object : coll1) {
                if (!coll2.contains(object)) continue;
                return true;
            }
        } else {
            for (Object object : coll2) {
                if (!coll1.contains(object)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean containsAll(Collection<?> coll1, Collection<?> coll2) {
        if (CollKit.isEmpty(coll1)) {
            return CollKit.isEmpty(coll2);
        }
        if (CollKit.isEmpty(coll2)) {
            return true;
        }
        if (coll1.size() < coll2.size()) {
            return false;
        }
        for (Object object : coll2) {
            if (coll1.contains(object)) continue;
            return false;
        }
        return true;
    }

    public static <T> Map<T, Integer> countMap(Iterable<T> collection) {
        return IterKit.countMap(collection);
    }

    public static <T> String join(Iterable<T> iterable, CharSequence conjunction) {
        return IterKit.join(iterable, conjunction);
    }

    public static <T> String join(Iterator<T> iterator, CharSequence conjunction) {
        return IterKit.join(iterator, conjunction);
    }

    public static <T> String join(Iterable<T> iterable, CharSequence conjunction, String prefix, String suffix) {
        if (null == iterable) {
            return null;
        }
        return IterKit.join(iterable.iterator(), conjunction, prefix, suffix);
    }

    public static <T> List<T> popPart(Stack<T> surplusAlaDatas, int partSize) {
        if (CollKit.isEmpty(surplusAlaDatas)) {
            return null;
        }
        ArrayList<T> currentAlaDatas = new ArrayList<T>();
        int size = surplusAlaDatas.size();
        if (size > partSize) {
            for (int i = 0; i < partSize; ++i) {
                currentAlaDatas.add(surplusAlaDatas.pop());
            }
        } else {
            for (int i = 0; i < size; ++i) {
                currentAlaDatas.add(surplusAlaDatas.pop());
            }
        }
        return currentAlaDatas;
    }

    public static <T> List<T> popPart(Deque<T> surplusAlaDatas, int partSize) {
        if (CollKit.isEmpty(surplusAlaDatas)) {
            return null;
        }
        ArrayList<T> currentAlaDatas = new ArrayList<T>();
        int size = surplusAlaDatas.size();
        if (size > partSize) {
            for (int i = 0; i < partSize; ++i) {
                currentAlaDatas.add(surplusAlaDatas.pop());
            }
        } else {
            for (int i = 0; i < size; ++i) {
                currentAlaDatas.add(surplusAlaDatas.pop());
            }
        }
        return currentAlaDatas;
    }

    public static <K, V> HashMap<K, V> newHashMap() {
        return MapKit.newHashMap();
    }

    public static <K, V> HashMap<K, V> newHashMap(int size, boolean isOrder) {
        return MapKit.newHashMap(size, isOrder);
    }

    public static <K, V> HashMap<K, V> newHashMap(int size) {
        return MapKit.newHashMap(size);
    }

    public static <T> HashSet<T> newHashSet(T ... ts) {
        return CollKit.newHashSet(false, ts);
    }

    public static <T> LinkedHashSet<T> newLinkedHashSet(T ... ts) {
        return (LinkedHashSet)CollKit.newHashSet(true, ts);
    }

    public static <T> HashSet<T> newHashSet(boolean isSorted, T ... ts) {
        if (null == ts) {
            return isSorted ? new LinkedHashSet() : new HashSet();
        }
        int initialCapacity = Math.max((int)((float)ts.length / 0.75f) + 1, 16);
        HashSet set = isSorted ? new LinkedHashSet(initialCapacity) : new HashSet(initialCapacity);
        for (T t : ts) {
            set.add(t);
        }
        return set;
    }

    public static <T> HashSet<T> newHashSet(Collection<T> collection) {
        return CollKit.newHashSet(false, collection);
    }

    public static <T> HashSet<T> newHashSet(boolean isSorted, Collection<T> collection) {
        return isSorted ? new LinkedHashSet<T>(collection) : new HashSet<T>(collection);
    }

    public static <T> HashSet<T> newHashSet(boolean isSorted, Iterator<T> iter) {
        HashSet set;
        if (null == iter) {
            return CollKit.newHashSet(isSorted, (Object[])null);
        }
        HashSet hashSet = set = isSorted ? new LinkedHashSet() : new HashSet();
        while (iter.hasNext()) {
            set.add(iter.next());
        }
        return set;
    }

    public static <T> HashSet<T> newHashSet(boolean isSorted, Enumeration<T> enumration) {
        HashSet set;
        if (null == enumration) {
            return CollKit.newHashSet(isSorted, (Object[])null);
        }
        HashSet hashSet = set = isSorted ? new LinkedHashSet() : new HashSet();
        while (enumration.hasMoreElements()) {
            set.add(enumration.nextElement());
        }
        return set;
    }

    public static <T> List<T> list(boolean isLinked) {
        return isLinked ? new LinkedList() : new ArrayList();
    }

    public static <T> List<T> list(boolean isLinked, T ... values) {
        if (ArrayKit.isEmpty(values)) {
            return CollKit.list(isLinked);
        }
        AbstractList arrayList = isLinked ? new LinkedList() : new ArrayList(values.length);
        for (T t : values) {
            arrayList.add(t);
        }
        return arrayList;
    }

    public static <T> List<T> list(boolean isLinked, Collection<T> collection) {
        if (null == collection) {
            return CollKit.list(isLinked);
        }
        return isLinked ? new LinkedList<T>(collection) : new ArrayList<T>(collection);
    }

    public static <T> List<T> list(boolean isLinked, Iterable<T> iterable) {
        if (null == iterable) {
            return CollKit.list(isLinked);
        }
        return CollKit.list(isLinked, iterable.iterator());
    }

    public static <T> List<T> list(boolean isLinked, Iterator<T> iter) {
        List<T> list = CollKit.list(isLinked);
        if (null != iter) {
            while (iter.hasNext()) {
                list.add(iter.next());
            }
        }
        return list;
    }

    public static <T> List<T> list(boolean isLinked, Enumeration<T> enumration) {
        List<T> list = CollKit.list(isLinked);
        if (null != enumration) {
            while (enumration.hasMoreElements()) {
                list.add(enumration.nextElement());
            }
        }
        return list;
    }

    public static <T> ArrayList<T> newArrayList(T ... values) {
        return (ArrayList)CollKit.list(false, values);
    }

    public static <T> ArrayList<T> toList(T ... values) {
        return CollKit.newArrayList(values);
    }

    public static <T> ArrayList<T> newArrayList(Collection<T> collection) {
        return (ArrayList)CollKit.list(false, collection);
    }

    public static <T> ArrayList<T> newArrayList(Iterable<T> iterable) {
        return (ArrayList)CollKit.list(false, iterable);
    }

    public static <T> ArrayList<T> newArrayList(Iterator<T> iter) {
        return (ArrayList)CollKit.list(false, iter);
    }

    public static <T> ArrayList<T> newArrayList(Enumeration<T> enumration) {
        return (ArrayList)CollKit.list(false, enumration);
    }

    public static <T> LinkedList<T> newLinkedList(T ... values) {
        return (LinkedList)CollKit.list(true, values);
    }

    public static <T> CopyOnWriteArrayList<T> newCopyOnWriteArrayList(Collection<T> collection) {
        return null == collection ? new CopyOnWriteArrayList() : new CopyOnWriteArrayList<T>(collection);
    }

    public static <T> BlockingQueue<T> newBlockingQueue(int capacity, boolean isLinked) {
        AbstractQueue queue = isLinked ? new LinkedBlockingDeque(capacity) : new ArrayBlockingQueue(capacity);
        return queue;
    }

    public static <T> Collection<T> create(Class<?> collectionType) {
        Collection<Object> list;
        if (collectionType.isAssignableFrom(AbstractCollection.class)) {
            list = new ArrayList();
        } else if (collectionType.isAssignableFrom(HashSet.class)) {
            list = new HashSet();
        } else if (collectionType.isAssignableFrom(LinkedHashSet.class)) {
            list = new LinkedHashSet();
        } else if (collectionType.isAssignableFrom(TreeSet.class)) {
            list = new TreeSet();
        } else if (collectionType.isAssignableFrom(EnumSet.class)) {
            list = EnumSet.noneOf(ClassKit.getTypeArgument(collectionType));
        } else if (collectionType.isAssignableFrom(ArrayList.class)) {
            list = new ArrayList();
        } else if (collectionType.isAssignableFrom(LinkedList.class)) {
            list = new LinkedList();
        } else {
            try {
                list = (Collection)ReflectKit.newInstance(collectionType, new Object[0]);
            }
            catch (Exception e) {
                throw new InstrumentException(e);
            }
        }
        return list;
    }

    public static <K, V> Map<K, V> createMap(Class<?> mapType) {
        return MapKit.createMap(mapType);
    }

    public static <T> ArrayList<T> distinct(Collection<T> collection) {
        if (CollKit.isEmpty(collection)) {
            return new ArrayList();
        }
        if (collection instanceof Set) {
            return new ArrayList<T>(collection);
        }
        return new ArrayList<T>(new LinkedHashSet<T>(collection));
    }

    public static <T> List<T> sub(List<T> list, int start, int end) {
        return CollKit.sub(list, start, end, 1);
    }

    public static <T> List<T> sub(List<T> list, int start, int end, int step) {
        if (list == null) {
            return null;
        }
        if (list.isEmpty()) {
            return new ArrayList(0);
        }
        int size = list.size();
        if (start < 0) {
            start += size;
        }
        if (end < 0) {
            end += size;
        }
        if (start == size) {
            return new ArrayList(0);
        }
        if (start > end) {
            int tmp = start;
            start = end;
            end = tmp;
        }
        if (end > size) {
            if (start >= size) {
                return new ArrayList(0);
            }
            end = size;
        }
        if (step <= 1) {
            return list.subList(start, end);
        }
        ArrayList<T> result = new ArrayList<T>();
        for (int i = start; i < end; i += step) {
            result.add(list.get(i));
        }
        return result;
    }

    public static <T> List<T> sub(Collection<T> collection, int start, int end) {
        return CollKit.sub(collection, start, end, 1);
    }

    public static <T> List<T> sub(Collection<T> list, int start, int end, int step) {
        if (list == null || list.isEmpty()) {
            return null;
        }
        return CollKit.sub(new ArrayList<T>(list), start, end, step);
    }

    public static <T> List<List<T>> split(Collection<T> collection, int size) {
        ArrayList<List<T>> result = new ArrayList<List<T>>();
        if (CollKit.isEmpty(collection)) {
            return result;
        }
        ArrayList<T> subList = new ArrayList<T>(size);
        for (T t : collection) {
            if (subList.size() >= size) {
                result.add(subList);
                subList = new ArrayList(size);
            }
            subList.add(t);
        }
        result.add(subList);
        return result;
    }

    public static <T> Collection<T> filter(Collection<T> collection, Editor<T> editor) {
        Collection<T> collection2 = ObjectKit.clone(collection);
        try {
            collection2.clear();
        }
        catch (UnsupportedOperationException e) {
            collection2 = new ArrayList<T>();
        }
        for (T t : collection) {
            T modified = editor.edit(t);
            if (null == modified) continue;
            collection2.add(modified);
        }
        return collection2;
    }

    public static <T> List<T> filter(List<T> list, Editor<T> editor) {
        AbstractList list2 = list instanceof LinkedList ? new LinkedList() : new ArrayList(list.size());
        for (T t : list) {
            T modified = editor.edit(t);
            if (null == modified) continue;
            list2.add(modified);
        }
        return list2;
    }

    public static <T extends Iterable<E>, E> T filter(T iter, Filter<E> filter) {
        if (null == iter) {
            return null;
        }
        CollKit.filter(iter.iterator(), filter);
        return iter;
    }

    public static <E> Iterator<E> filter(Iterator<E> iter, Filter<E> filter) {
        if (null == iter || null == filter) {
            return iter;
        }
        while (iter.hasNext()) {
            if (filter.accept(iter.next())) continue;
            iter.remove();
        }
        return iter;
    }

    public static <T> Collection<T> removeNull(Collection<T> collection) {
        return CollKit.filter(collection, Objects::nonNull);
    }

    public static <T> Collection<T> removeAny(Collection<T> collection, T ... elesRemoved) {
        collection.removeAll(CollKit.newHashSet(elesRemoved));
        return collection;
    }

    public static <T extends CharSequence> Collection<T> removeEmpty(Collection<T> collection) {
        return CollKit.filter(collection, (E t) -> false == StringKit.isEmpty(t));
    }

    public static <T extends CharSequence> Collection<T> removeBlank(Collection<T> collection) {
        return CollKit.filter(collection, (E t) -> false == StringKit.isBlank(t));
    }

    public static List<Object> extract(Iterable<?> collection, Editor<Object> editor) {
        return CollKit.extract(collection, editor, false);
    }

    public static List<Object> extract(Iterable<?> collection, Editor<Object> editor, boolean ignoreNull) {
        return CollKit.map(collection, editor::edit, ignoreNull);
    }

    public static <T, R> List<R> map(Iterable<T> collection, Function<T, R> func, boolean ignoreNull) {
        ArrayList<R> fieldValueList = new ArrayList<R>();
        if (null == collection) {
            return fieldValueList;
        }
        for (T bean : collection) {
            R value = func.apply(bean);
            if (null == value && ignoreNull) continue;
            fieldValueList.add(value);
        }
        return fieldValueList;
    }

    public static List<Object> getFieldValues(Iterable<?> collection, String fieldName) {
        return CollKit.extract(collection, bean -> {
            if (bean instanceof Map) {
                return ((Map)bean).get(fieldName);
            }
            return ReflectKit.getFieldValue(bean, fieldName);
        });
    }

    public static <T> T findOne(Iterable<T> collection, Filter<T> filter) {
        if (null != collection) {
            for (T t : collection) {
                if (!filter.accept(t)) continue;
                return t;
            }
        }
        return null;
    }

    public static <T> T findOneByField(Iterable<T> collection, final String fieldName, final Object fieldValue) {
        return CollKit.findOne(collection, new Filter<T>(){

            @Override
            public boolean accept(T t) {
                if (t instanceof Map) {
                    Map map = (Map)t;
                    Object value = map.get(fieldName);
                    return ObjectKit.equal(value, fieldValue);
                }
                Object value = ReflectKit.getFieldValue(t, fieldName);
                return ObjectKit.equal(value, fieldValue);
            }
        });
    }

    public static <K, V> Map<K, V> filter(Map<K, V> map, Editor<Map.Entry<K, V>> editor) {
        return MapKit.filter(map, editor);
    }

    public static <K, V> Map<K, V> filter(Map<K, V> map, Filter<Map.Entry<K, V>> filter) {
        return MapKit.filter(map, filter);
    }

    public static <T> int count(Iterable<T> iterable, Matcher<T> matcher) {
        int count = 0;
        if (null != iterable) {
            for (T t : iterable) {
                if (null != matcher && !matcher.match(t)) continue;
                ++count;
            }
        }
        return count;
    }

    public static Map<String, String> zip(String keys, String values, String delimiter, boolean isOrder) {
        return ArrayKit.zip(StringKit.split((CharSequence)keys, delimiter), StringKit.split((CharSequence)values, delimiter), isOrder);
    }

    public static Map<String, String> zip(String keys, String values, String delimiter) {
        return CollKit.zip(keys, values, delimiter, false);
    }

    public static <K, V> Map<K, V> zip(Collection<K> keys, Collection<V> values) {
        if (CollKit.isEmpty(keys) || CollKit.isEmpty(values)) {
            return null;
        }
        ArrayList<K> keyList = new ArrayList<K>(keys);
        ArrayList<V> valueList = new ArrayList<V>(values);
        int size = Math.min(keys.size(), values.size());
        HashMap map = new HashMap((int)((double)size / 0.75));
        for (int i = 0; i < size; ++i) {
            map.put(keyList.get(i), valueList.get(i));
        }
        return map;
    }

    public static <K, V> HashMap<K, V> toMap(Iterable<Map.Entry<K, V>> entryIter) {
        return IterKit.toMap(entryIter);
    }

    public static HashMap<Object, Object> toMap(Object[] array) {
        return MapKit.of(array);
    }

    public static <T> TreeSet<T> toTreeSet(Collection<T> collection, Comparator<T> comparator) {
        TreeSet<T> treeSet = new TreeSet<T>(comparator);
        for (T t : collection) {
            treeSet.add(t);
        }
        return treeSet;
    }

    public static <E> Enumeration<E> asEnumeration(Iterator<E> iter) {
        return new IteratorEnumeration<E>(iter);
    }

    public static <E> Iterator<E> asIterator(Enumeration<E> e) {
        return IterKit.asIterator(e);
    }

    public static <E> Iterable<E> asIterable(Iterator<E> iter) {
        return IterKit.asIterable(iter);
    }

    public static <E> Collection<E> toCollection(Iterable<E> iterable) {
        return iterable instanceof Collection ? (ArrayList<E>)iterable : CollKit.newArrayList(iterable.iterator());
    }

    public static <K, V> Map<K, List<V>> toListMap(Iterable<? extends Map<K, V>> mapList) {
        return MapKit.toListMap(mapList);
    }

    public static <K, V> List<Map<K, V>> toMapList(Map<K, ? extends Iterable<V>> listMap) {
        return MapKit.toMapList(listMap);
    }

    public static <T> Collection<T> addAll(Collection<T> collection, Object value) {
        return CollKit.addAll(collection, value, TypeKit.getTypeArgument(collection.getClass()));
    }

    public static <T> Collection<T> addAll(Collection<T> collection, Object value, Type elementType) {
        Iterator<Object> iter;
        if (null == collection || null == value) {
            return collection;
        }
        if (TypeKit.isUnknow((Type)elementType)) {
            elementType = Object.class;
        }
        if (value instanceof Iterator) {
            iter = (Iterator)value;
        } else if (value instanceof Iterable) {
            iter = ((Iterable)value).iterator();
        } else if (value instanceof Enumeration) {
            iter = new IterKit.EnumerationIter((Enumeration)value);
        } else if (ArrayKit.isArray(value)) {
            iter = new ArrayIterator(value);
        } else if (value instanceof CharSequence) {
            String ArrayStr = StringKit.unWrap((CharSequence)value, '[', ']');
            iter = StringKit.splitTrim((CharSequence)ArrayStr, ',').iterator();
        } else {
            iter = CollKit.newArrayList(value).iterator();
        }
        ConverterRegistry convert = ConverterRegistry.getInstance();
        while (iter.hasNext()) {
            collection.add(convert.convert((Type)elementType, iter.next()));
        }
        return collection;
    }

    public static <T> Collection<T> addAll(Collection<T> collection, Iterator<T> iterator) {
        if (null != collection && null != iterator) {
            while (iterator.hasNext()) {
                collection.add(iterator.next());
            }
        }
        return collection;
    }

    public static <T> Collection<T> addAll(Collection<T> collection, Iterable<T> iterable) {
        return CollKit.addAll(collection, iterable.iterator());
    }

    public static <T> Collection<T> addAll(Collection<T> collection, Enumeration<T> enumeration) {
        if (null != collection && null != enumeration) {
            while (enumeration.hasMoreElements()) {
                collection.add(enumeration.nextElement());
            }
        }
        return collection;
    }

    public static <T> Collection<T> addAll(Collection<T> collection, T[] values) {
        if (null != collection && null != values) {
            for (T value : values) {
                collection.add(value);
            }
        }
        return collection;
    }

    public static List<String> addAll(List<String> list, String part, boolean isTrim, boolean ignoreEmpty) {
        if (isTrim) {
            part = StringKit.trim(part);
        }
        if (!ignoreEmpty || !part.isEmpty()) {
            list.add(part);
        }
        return list;
    }

    public static <T> List<T> addAllIfNotContains(List<T> list, List<T> otherList) {
        for (T t : otherList) {
            if (list.contains(t)) continue;
            list.add(t);
        }
        return list;
    }

    public static <T> T get(Collection<T> collection, int index) {
        if (null == collection) {
            return null;
        }
        int size = collection.size();
        if (0 == size) {
            return null;
        }
        if (index < 0) {
            index += size;
        }
        if (index >= size) {
            return null;
        }
        if (collection instanceof List) {
            List list = (List)collection;
            return (T)list.get(index);
        }
        int i = 0;
        for (T t : collection) {
            if (i > index) break;
            if (i == index) {
                return t;
            }
            ++i;
        }
        return null;
    }

    public static <T> List<T> getAny(Collection<T> collection, int ... indexes) {
        int size = collection.size();
        ArrayList<Object> result = new ArrayList<Object>();
        if (collection instanceof List) {
            List list = (List)collection;
            for (int index : indexes) {
                if (index < 0) {
                    index += size;
                }
                result.add(list.get(index));
            }
        } else {
            Object[] array = collection.toArray();
            for (int index : indexes) {
                if (index < 0) {
                    index += size;
                }
                result.add(array[index]);
            }
        }
        return result;
    }

    public static <T> T getFirst(Iterable<T> iterable) {
        return IterKit.getFirst(iterable);
    }

    public static <T> T getFirst(Iterator<T> iterator) {
        return IterKit.getFirst(iterator);
    }

    public static <T> T getLast(Collection<T> collection) {
        return CollKit.get(collection, -1);
    }

    public static Class<?> getElementType(Iterable<?> iterable) {
        return IterKit.getElementType(iterable);
    }

    public static Class<?> getElementType(Iterator<?> iterator) {
        return IterKit.getElementType(iterator);
    }

    public static <K, V> ArrayList<V> valuesOfKeys(Map<K, V> map, K ... keys) {
        ArrayList<V> values = new ArrayList<V>();
        for (K k : keys) {
            values.add(map.get(k));
        }
        return values;
    }

    public static <K, V> ArrayList<V> valuesOfKeys(Map<K, V> map, Iterable<K> keys) {
        return CollKit.valuesOfKeys(map, keys.iterator());
    }

    public static <K, V> ArrayList<V> valuesOfKeys(Map<K, V> map, Iterator<K> keys) {
        ArrayList<V> values = new ArrayList<V>();
        while (keys.hasNext()) {
            values.add(map.get(keys.next()));
        }
        return values;
    }

    public static <T> List<T> page(int pageNo, int pageSize, List<T> list) {
        if (CollKit.isEmpty(list)) {
            return new ArrayList(0);
        }
        int resultSize = list.size();
        if (resultSize <= pageSize) {
            if (pageNo <= 1) {
                return Collections.unmodifiableList(list);
            }
            return new ArrayList(0);
        }
        int[] startEnd = CollKit.transToStartEnd(pageNo, pageSize);
        if (startEnd[1] > resultSize) {
            startEnd[1] = resultSize;
        }
        return list.subList(startEnd[0], startEnd[1]);
    }

    private static <E> int sort(String name, boolean asc, E a, E b) throws Exception {
        Object value1 = CollKit.forceGetFieldValue(a, name);
        Object value2 = CollKit.forceGetFieldValue(b, name);
        String str1 = value1.toString();
        String str2 = value2.toString();
        if (value1 instanceof Number && value2 instanceof Number) {
            int maxlen = Math.max(str1.length(), str2.length());
            str1 = MathKit.addZero((Number)value1, maxlen);
            str2 = MathKit.addZero((Number)value2, maxlen);
        } else if (value1 instanceof Date && value2 instanceof Date) {
            long time1 = ((Date)value1).getTime();
            long time2 = ((Date)value2).getTime();
            int maxlen = Long.toString(Math.max(time1, time2)).length();
            str1 = MathKit.addZero(time1, maxlen);
            str2 = MathKit.addZero(time2, maxlen);
        }
        if (asc) {
            return str1.compareTo(str2);
        }
        return str2.compareTo(str1);
    }

    public static <T> List<T> sort(Collection<T> collection, Comparator<? super T> comparator) {
        ArrayList<T> list = new ArrayList<T>(collection);
        list.sort(comparator);
        return list;
    }

    public static <T> List<T> sort(List<T> list, Comparator<? super T> c) {
        list.sort(c);
        return list;
    }

    public static <K, V> TreeMap<K, V> sort(Map<K, V> map, Comparator<? super K> comparator) {
        TreeMap<K, V> result = new TreeMap<K, V>(comparator);
        result.putAll(map);
        return result;
    }

    public static <E> void sort(List<E> list, boolean asc, String ... name) {
        Collections.sort(list, (a, b) -> {
            int ret = 0;
            try {
                for (int i = 0; i < name.length && 0 == (ret = CollKit.sort(name[i], asc, a, b)); ++i) {
                }
            }
            catch (Exception e) {
                throw new InstrumentException(e);
            }
            return ret;
        });
    }

    public static <E> void sort(List<E> list, String[] name, boolean[] type) {
        if (name.length != type.length) {
            throw new RuntimeException("\u5c5e\u6027\u6570\u7ec4\u5143\u7d20\u4e2a\u6570\u548c\u5347\u964d\u5e8f\u6570\u7ec4\u5143\u7d20\u4e2a\u6570\u4e0d\u76f8\u7b49");
        }
        Collections.sort(list, (a, b) -> {
            int ret = 0;
            try {
                for (int i = 0; i < name.length && 0 == (ret = CollKit.sort(name[i], type[i], a, b)); ++i) {
                }
            }
            catch (Exception e) {
                throw new InstrumentException(e);
            }
            return ret;
        });
    }

    public static <T> List<T> sortPageAll(int pageNo, int pageSize, Comparator<T> comparator, Collection<T> ... colls) {
        ArrayList<T> list = new ArrayList<T>(pageNo * pageSize);
        for (Collection<T> coll : colls) {
            list.addAll(coll);
        }
        if (null != comparator) {
            list.sort(comparator);
        }
        return CollKit.page(pageNo, pageSize, list);
    }

    public static <T> List<T> sortByProperty(Collection<T> collection, String property) {
        return CollKit.sort(collection, new PropertyCompare(property));
    }

    public static <T> List<T> sortByProperty(List<T> list, String property) {
        return CollKit.sort(list, new PropertyCompare(property));
    }

    public static <K, V> LinkedHashMap<K, V> sortToMap(Collection<Map.Entry<K, V>> entryCollection, Comparator<Map.Entry<K, V>> comparator) {
        LinkedList<Map.Entry<K, V>> list = new LinkedList<Map.Entry<K, V>>(entryCollection);
        list.sort(comparator);
        LinkedHashMap result = new LinkedHashMap();
        for (Map.Entry entry : list) {
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    public static <K, V> LinkedHashMap<K, V> sortByEntry(Map<K, V> map, Comparator<Map.Entry<K, V>> comparator) {
        return CollKit.sortToMap(map.entrySet(), comparator);
    }

    public static <K, V> List<Map.Entry<K, V>> sortEntryToList(Collection<Map.Entry<K, V>> collection) {
        LinkedList<Map.Entry<K, V>> list = new LinkedList<Map.Entry<K, V>>(collection);
        list.sort((o1, o2) -> {
            Object v1 = o1.getValue();
            Object v2 = o2.getValue();
            if (v1 instanceof Comparable) {
                return ((Comparable)v1).compareTo(v2);
            }
            return v1.toString().compareTo(v2.toString());
        });
        return list;
    }

    public static <T> List<List<T>> group(Collection<T> collection, Hash<T> hash) {
        ArrayList<List<T>> result = new ArrayList<List<T>>();
        if (CollKit.isEmpty(collection)) {
            return result;
        }
        if (null == hash) {
            hash = t -> null == t ? 0 : t.hashCode();
        }
        for (T t2 : collection) {
            int index = hash.hash(t2);
            if (result.size() - 1 < index) {
                while (result.size() - 1 < index) {
                    result.add(null);
                }
                result.set(index, CollKit.newArrayList(t2));
                continue;
            }
            List subList = (List)result.get(index);
            if (null == subList) {
                result.set(index, CollKit.newArrayList(t2));
                continue;
            }
            subList.add(t2);
        }
        return result;
    }

    public static <T> List<List<T>> groupByField(Collection<T> collection, final String fieldName) {
        return CollKit.group(collection, new Hash<T>(){
            private final List<Object> fieldNameList = new ArrayList<Object>();

            @Override
            public int hash(T t) {
                if (null == t || !BeanKit.isBean(t.getClass())) {
                    return 0;
                }
                Object value = ReflectKit.getFieldValue(t, fieldName);
                int hash = this.fieldNameList.indexOf(value);
                if (hash < 0) {
                    this.fieldNameList.add(value);
                    return this.fieldNameList.size() - 1;
                }
                return hash;
            }
        });
    }

    public static <T> void forEach(Iterator<T> iterator, Consumer<T> consumer) {
        int index = 0;
        while (iterator.hasNext()) {
            consumer.accept(iterator.next(), index);
            ++index;
        }
    }

    public static <T> void forEach(Enumeration<T> enumeration, Consumer<T> consumer) {
        int index = 0;
        while (enumeration.hasMoreElements()) {
            consumer.accept(enumeration.nextElement(), index);
            ++index;
        }
    }

    public static <K, V> void forEach(Map<K, V> map, KVConsumer<K, V> kvConsumer) {
        int index = 0;
        for (Map.Entry<K, V> entry : map.entrySet()) {
            kvConsumer.accept(entry.getKey(), entry.getValue(), index);
            ++index;
        }
    }

    public static <T> List<T> reverse(List<T> list) {
        Collections.reverse(list);
        return list;
    }

    public static <T> List<T> reverse(List<T> list, boolean clone) {
        if (!clone) {
            return CollKit.reverse(list);
        }
        List<T> list2 = ObjectKit.clone(list);
        return CollKit.reverse(list2);
    }

    public static Object forceGetFieldValue(Object obj, String fieldName) throws Exception {
        Field field = ClassKit.getField(obj.getClass(), fieldName);
        boolean accessible = field.isAccessible();
        if (!accessible) {
            field.setAccessible(true);
            obj = field.get(obj);
            field.setAccessible(accessible);
            return obj;
        }
        return field.get(obj);
    }

    public static <T> List<T> setOrAppend(List<T> list, int index, T element) {
        if (index < list.size()) {
            list.set(index, element);
        } else {
            list.add(element);
        }
        return list;
    }

    public static int[] transToStartEnd(int pageNo, int pageSize) {
        if (pageNo < 1) {
            pageNo = 1;
        }
        if (pageSize < 1) {
            pageSize = 0;
        }
        int start = (pageNo - 1) * pageSize;
        int end = start + pageSize;
        return new int[]{start, end};
    }

    public static int totalPage(int totalCount, int pageSize) {
        if (pageSize == 0) {
            return 0;
        }
        return totalCount % pageSize == 0 ? totalCount / pageSize : totalCount / pageSize + 1;
    }

    public static int[] rainbow(int currentPage, int pageCount, int displayCount) {
        boolean isEven = displayCount % 2 == 0;
        int left = displayCount / 2;
        int right = displayCount / 2;
        int length = displayCount;
        if (isEven) {
            ++right;
        }
        if (pageCount < displayCount) {
            length = pageCount;
        }
        int[] result = new int[length];
        if (pageCount >= displayCount) {
            if (currentPage <= left) {
                for (int i = 0; i < result.length; ++i) {
                    result[i] = i + 1;
                }
            } else if (currentPage > pageCount - right) {
                for (int i = 0; i < result.length; ++i) {
                    result[i] = i + pageCount - displayCount + 1;
                }
            } else {
                for (int i = 0; i < result.length; ++i) {
                    result[i] = i + currentPage - left + (isEven ? 1 : 0);
                }
            }
        } else {
            for (int i = 0; i < result.length; ++i) {
                result[i] = i + 1;
            }
        }
        return result;
    }

    public static int[] rainbow(int currentPage, int pageCount) {
        return CollKit.rainbow(currentPage, pageCount, 10);
    }

    public static <T> Optional<T> firstNotNullElem(Collection<T> list) {
        if (CollKit.isEmpty(list)) {
            return Optional.empty();
        }
        for (T elem : list) {
            if (!ObjectKit.isNotNull(elem)) continue;
            return Optional.of(elem);
        }
        return Optional.empty();
    }

    public static <T> T[] concat(T[] one, T[] other, Class<T> clazz) {
        Object[] target = (Object[])Array.newInstance(clazz, one.length + other.length);
        System.arraycopy(one, 0, target, 0, one.length);
        System.arraycopy(other, 0, target, one.length, other.length);
        return target;
    }

    public static <E> Set<E> ofImmutableSet(E ... es) {
        Objects.requireNonNull(es, "args es is null.");
        return Arrays.stream(es).collect(Collectors.toSet());
    }

    public static <E> List<E> ofImmutableList(E ... es) {
        Objects.requireNonNull(es, "args es is null.");
        return Arrays.stream(es).collect(Collectors.toList());
    }

    public static <K> Set<K> keySet(Collection<Map<K, ?>> mapCollection) {
        if (CollKit.isEmpty(mapCollection)) {
            return new HashSet();
        }
        HashSet<K> set = new HashSet<K>(mapCollection.size() * 16);
        for (Map<K, ?> map : mapCollection) {
            set.addAll(map.keySet());
        }
        return set;
    }

    public static <V> List<V> values(Collection<Map<?, V>> mapCollection) {
        ArrayList<V> values = new ArrayList<V>();
        for (Map<?, V> map : mapCollection) {
            values.addAll(map.values());
        }
        return values;
    }

    public static <T extends Comparable<? super T>> T max(Collection<T> coll) {
        return (T)((Comparable)Collections.max(coll));
    }

    public static <T extends Comparable<? super T>> T min(Collection<T> coll) {
        return (T)((Comparable)Collections.min(coll));
    }

    public static <T> int[] indexOfAll(Collection<T> collection, Matcher<T> matcher) {
        ArrayList<Integer> indexList = new ArrayList<Integer>();
        if (null != collection) {
            int index = 0;
            for (T t : collection) {
                if (null == matcher || matcher.match(t)) {
                    indexList.add(index);
                }
                ++index;
            }
        }
        return Convert.convert(int[].class, indexList);
    }

    public static void clear(Collection<?> ... collections) {
        for (Collection<?> collection : collections) {
            if (!CollKit.isNotEmpty(collection)) continue;
            collection.clear();
        }
    }

    public static interface Hash<T> {
        public int hash(T var1);
    }

    public static interface KVConsumer<K, V> {
        public void accept(K var1, V var2, int var3);
    }

    public static interface Consumer<T> {
        public void accept(T var1, int var2);
    }
}

