/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.toolkit;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Year;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.aoju.bus.core.date.Between;
import org.aoju.bus.core.date.Boundary;
import org.aoju.bus.core.date.DateTime;
import org.aoju.bus.core.date.TimeInterval;
import org.aoju.bus.core.date.format.DateParser;
import org.aoju.bus.core.date.format.DatePeriod;
import org.aoju.bus.core.date.format.DatePrinter;
import org.aoju.bus.core.date.format.FormatBuilder;
import org.aoju.bus.core.lang.Fields;
import org.aoju.bus.core.lang.RegEx;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.toolkit.ArrayKit;
import org.aoju.bus.core.toolkit.CollKit;
import org.aoju.bus.core.toolkit.MathKit;
import org.aoju.bus.core.toolkit.PatternKit;
import org.aoju.bus.core.toolkit.StringKit;

public class DateKit {
    public static final int MIN_YEAR = 1850;
    public static final int MAX_YEAR = 2150;
    private int lyear;
    private int lmonth;
    private int ldate;
    private boolean isLeapMonth = false;
    private int leapMonth = 0;
    private GregorianCalendar solar = new GregorianCalendar();

    public DateKit() {
        this.lunar(this.solar.get(1), this.solar.get(2), this.solar.get(5));
    }

    public DateKit(int lyear, int lmonth, int ldate, boolean isleapMonth) {
        this.lunar(lyear, lmonth, ldate, isleapMonth);
    }

    public DateKit(Calendar calendar) {
        this.lunar(calendar.get(1), calendar.get(2), calendar.get(5));
    }

    public static String dateCN(String date) {
        return Fields.NORM_DATE_CN_FORMAT.format(date);
    }

    public static String weekCN(String date) {
        try {
            Calendar cal = Calendar.getInstance();
            Date d = Fields.PURE_DATETIME_FORMAT.parse(date);
            cal.setTime(d);
            int w = cal.get(7) - 1;
            if (w < 0) {
                w = 0;
            }
            return Fields.Week.of(w).toChinese("\u661f\u671f");
        }
        catch (ParseException e) {
            throw new InstrumentException(e);
        }
    }

    public static DateTime date() {
        return new DateTime();
    }

    public static DateTime date(Date date) {
        if (date instanceof DateTime) {
            return (DateTime)date;
        }
        return new DateTime(date);
    }

    public static DateTime date(long date) {
        return new DateTime(date);
    }

    public static DateTime date(Calendar calendar) {
        return new DateTime(calendar);
    }

    public static DateTime date(TemporalAccessor temporalAccessor) {
        return new DateTime(temporalAccessor);
    }

    public static Calendar calendar(Date date) {
        if (date instanceof DateTime) {
            return ((DateTime)date).toCalendar();
        }
        return DateKit.calendar(date.getTime());
    }

    public static Calendar calendar(long millis) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(millis);
        return cal;
    }

    public static String now() {
        return DateKit.formatDateTime(new DateTime());
    }

    public static long timestamp() {
        return System.currentTimeMillis();
    }

    public static long timestamp(boolean isNano) {
        return isNano ? System.nanoTime() : System.currentTimeMillis();
    }

    public static int year(Date date) {
        return DateTime.of(date).year();
    }

    public static int quarter(Date date) {
        return DateTime.of(date).quarter();
    }

    public static Fields.Quarter quarters(Date date) {
        return DateTime.of(date).quarterEnum();
    }

    public static int month(Date date) {
        return DateTime.of(date).month();
    }

    public static Fields.Month months(Date date) {
        return DateTime.of(date).monthEnum();
    }

    public static int weekOfYear(Date date) {
        return DateTime.of(date).weekOfYear();
    }

    public static int weekOfMonth(Date date) {
        return DateTime.of(date).weekOfMonth();
    }

    public static int dayOfMonth(Date date) {
        return DateTime.of(date).dayOfMonth();
    }

    public static int dayOfYear(Date date) {
        return DateTime.of(date).dayOfYear();
    }

    public static int dayOfWeek(Date date) {
        return DateTime.of(date).dayOfWeek();
    }

    public static Fields.Week dayOfWeeks(Date date) {
        return DateTime.of(date).dayOfWeekEnum();
    }

    public static int lengthOfYear(int year) {
        return Year.of(year).length();
    }

    public static int hour(Date date, boolean is24HourClock) {
        return DateTime.of(date).hour(is24HourClock);
    }

    public static int minute(Date date) {
        return DateTime.of(date).minute();
    }

    public static int second(Date date) {
        return DateTime.of(date).second();
    }

    public static int millsecond(Date date) {
        return DateTime.of(date).millsecond();
    }

    public static boolean isAM(Date date) {
        return DateTime.of(date).isAM();
    }

    public static boolean isAM(Calendar calendar) {
        return 0 == calendar.get(9);
    }

    public static boolean isPM(Date date) {
        return DateTime.of(date).isPM();
    }

    public static boolean isPM(Calendar calendar) {
        return 1 == calendar.get(9);
    }

    public static int thisYear() {
        return DateKit.year(DateKit.date());
    }

    public static int thisMonth() {
        return DateKit.month(DateKit.date());
    }

    public static Fields.Month thisMonthEnum() {
        return DateKit.months(DateKit.date());
    }

    public static int thisWeekOfYear() {
        return DateKit.weekOfYear(DateKit.date());
    }

    public static int thisWeekOfMonth() {
        return DateKit.weekOfMonth(DateKit.date());
    }

    public static int thisDayOfMonth() {
        return DateKit.dayOfMonth(DateKit.date());
    }

    public static int thisDayOfWeek() {
        return DateKit.dayOfWeek(DateKit.date());
    }

    public static Fields.Week thisDayOfWeekEnum() {
        return DateKit.dayOfWeeks(DateKit.date());
    }

    public static int thisHour(boolean is24HourClock) {
        return DateKit.hour(DateKit.date(), is24HourClock);
    }

    public static int thisMinute() {
        return DateKit.minute(DateKit.date());
    }

    public static int thisSecond() {
        return DateKit.second(DateKit.date());
    }

    public static int thisMillsecond() {
        return DateKit.millsecond(DateKit.date());
    }

    public static String yearAndQuarter(Date date) {
        return DateKit.yearAndQuarter(DateKit.calendar(date));
    }

    private static String yearAndQuarter(Calendar cal) {
        return "" + cal.get(1) + (cal.get(2) / 3 + 1);
    }

    public static LinkedHashSet<String> yearAndQuarter(Date startDate, Date endDate) {
        if (startDate == null || endDate == null) {
            return new LinkedHashSet<String>(0);
        }
        return DateKit.yearAndQuarter(startDate.getTime(), endDate.getTime());
    }

    public static LinkedHashSet<String> yearAndQuarter(long startDate, long endDate) {
        LinkedHashSet<String> quarters = new LinkedHashSet<String>();
        Calendar cal = DateKit.calendar(startDate);
        while (startDate <= endDate) {
            quarters.add(DateKit.yearAndQuarter(cal));
            cal.add(2, 3);
            startDate = cal.getTimeInMillis();
        }
        return quarters;
    }

    public static String format(Date date) {
        if (date != null) {
            SimpleDateFormat dstSdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            return dstSdf.format(date);
        }
        return "";
    }

    public static String format(Date date, String format) {
        TimeZone timeZone;
        if (null == date || StringKit.isBlank(format)) {
            return null;
        }
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        if (date instanceof DateTime && null != (timeZone = ((DateTime)date).getTimeZone())) {
            sdf.setTimeZone(timeZone);
        }
        return DateKit.format(date, sdf);
    }

    public static String format(Date date, DatePrinter format) {
        if (null == format || null == date) {
            return null;
        }
        return format.format(date);
    }

    public static String format(Date date, DateFormat format) {
        if (null == format || null == date) {
            return null;
        }
        return format.format(date);
    }

    public static String format(String srcDate, String srcPattern, String destPattern) {
        try {
            SimpleDateFormat srcSdf = new SimpleDateFormat(srcPattern);
            SimpleDateFormat dstSdf = new SimpleDateFormat(destPattern);
            return dstSdf.format(srcSdf.parse(srcDate));
        }
        catch (ParseException e) {
            return "";
        }
    }

    public static long format(String date) {
        try {
            return Fields.NORM_DATETIME_FORMAT.parse(date).getTime();
        }
        catch (ParseException e) {
            throw new InstrumentException(e);
        }
    }

    public static String format(long timestamp) {
        return Fields.NORM_DATETIME_FORMAT.format(new Date(timestamp));
    }

    public static String format(long timestamp, String format) {
        return new SimpleDateFormat(format).format(new Date(timestamp));
    }

    public static long format(String date, String format) {
        try {
            return new SimpleDateFormat(format).parse(date).getTime();
        }
        catch (ParseException e) {
            throw new InstrumentException(e);
        }
    }

    public static String format(LocalDateTime localDateTime) {
        return DateKit.format(localDateTime, "yyyy-MM-dd HH:mm:ss");
    }

    public static String format(LocalDateTime localDateTime, String format) {
        if (null == localDateTime || StringKit.isBlank(format)) {
            return null;
        }
        DateTimeFormatter df = DateTimeFormatter.ofPattern(format);
        return localDateTime.format(df);
    }

    public static String formatDate(Date date) {
        if (null == date) {
            return null;
        }
        return Fields.NORM_DATE_FORMAT.format(date);
    }

    public static String formatHttpDate(Date date) {
        if (null == date) {
            return null;
        }
        return Fields.HTTP_DATETIME_FORMAT.format(date);
    }

    public static String formatTime(Date date) {
        if (null == date) {
            return null;
        }
        return Fields.NORM_TIME_FORMAT.format(date);
    }

    public static String formatDateTime(Date date) {
        if (null == date) {
            return null;
        }
        return Fields.NORM_DATETIME_FORMAT.format(date);
    }

    public static DateTime parse(CharSequence dateCharSequence) {
        if (StringKit.isBlank(dateCharSequence)) {
            return null;
        }
        String dateStr = dateCharSequence.toString();
        dateStr = StringKit.removeAll((CharSequence)dateStr.trim(), '\u65e5', '\u79d2');
        int length = dateStr.length();
        if (MathKit.isNumber(dateStr)) {
            if (length == "yyyyMMddHHmmss".length()) {
                return DateKit.parse(dateStr, Fields.PURE_DATETIME_FORMAT);
            }
            if (length == "yyyyMMddHHmmssSSS".length()) {
                return DateKit.parse(dateStr, Fields.PURE_DATETIME_MS_FORMAT);
            }
            if (length == "yyyyMMdd".length()) {
                return DateKit.parse(dateStr, Fields.PURE_DATE_FORMAT);
            }
            if (length == "HHmmss".length()) {
                return DateKit.parse(dateStr, Fields.PURE_TIME_FORMAT);
            }
        } else {
            if (PatternKit.isMatch(RegEx.TIME, (CharSequence)dateStr)) {
                return DateKit.parseTimeToday(dateStr);
            }
            if (StringKit.containsAnyIgnoreCase(dateStr, Fields.WTB)) {
                return DateKit.parseCST(dateStr);
            }
            if (StringKit.contains((CharSequence)dateStr, 'T')) {
                return DateKit.parseUTC(dateStr);
            }
        }
        if (PatternKit.isMatch(Fields.REGEX_NORM, (CharSequence)(dateStr = DateKit.normalize(dateStr)))) {
            int colonCount = StringKit.count((CharSequence)dateStr, ":");
            switch (colonCount) {
                case 0: {
                    return DateKit.parse(dateStr, Fields.NORM_DATE_FORMAT);
                }
                case 1: {
                    return DateKit.parse(dateStr, Fields.NORM_DATETIME_MINUTE_FORMAT);
                }
                case 2: {
                    return DateKit.parse(dateStr, Fields.NORM_DATETIME_FORMAT);
                }
            }
        }
        if (length >= "yyyy-MM-dd HH:mm:ss.SSS".length() - 2) {
            return DateKit.parse(dateStr, Fields.NORM_DATETIME_MS_FORMAT);
        }
        throw new InstrumentException("No format fit for date String [{}] !", dateStr);
    }

    public static LocalDateTime parse(CharSequence dateStr, String format) {
        dateStr = DateKit.normalize(dateStr);
        DateTimeFormatter df = DateTimeFormatter.ofPattern(format);
        try {
            return LocalDateTime.parse(dateStr, df);
        }
        catch (DateTimeParseException e) {
            return LocalDate.parse(dateStr, df).atStartOfDay();
        }
    }

    public static DateTime parse(String dateStr, DateFormat dateFormat) {
        return new DateTime((CharSequence)dateStr, dateFormat);
    }

    public static DateTime parse(String dateStr, DateParser parser) {
        return new DateTime((CharSequence)dateStr, parser);
    }

    public static DateTime parse(String dateStr, String format) {
        return new DateTime((CharSequence)dateStr, format);
    }

    public static DateTime parseDate(String dateString) {
        return DateKit.parse(DateKit.normalize(dateString), Fields.NORM_DATE_FORMAT);
    }

    public static DateTime parseTime(String timeString) {
        return DateKit.parse(DateKit.normalize(timeString), Fields.NORM_TIME_FORMAT);
    }

    public static DateTime parseDateTime(String dateString) {
        return DateKit.parse(DateKit.normalize(dateString), Fields.NORM_DATETIME_FORMAT);
    }

    public static DateTime parseTimeToday(String timeString) {
        timeString = StringKit.format("{} {}", DateKit.formatDate(new DateTime()), timeString);
        if (1 == StringKit.count((CharSequence)timeString, ':')) {
            return DateKit.parse(timeString, "yyyy-MM-dd HH:mm");
        }
        return DateKit.parse(timeString, Fields.NORM_DATETIME_FORMAT);
    }

    public static DateTime parseCST(CharSequence cstString) {
        if (cstString == null) {
            return null;
        }
        return DateKit.parse((String)cstString, Fields.JDK_DATETIME_FORMAT);
    }

    public static DateTime parseUTC(String utcString) {
        if (utcString == null) {
            return null;
        }
        int length = utcString.length();
        if (StringKit.contains((CharSequence)utcString, 'Z')) {
            if (length == "yyyy-MM-dd'T'HH:mm:ss'Z'".length() - 4) {
                return DateKit.parse(utcString, Fields.UTC_FORMAT);
            }
            if (length == "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'".length() - 4) {
                return DateKit.parse(utcString, Fields.OUTPUT_MSEC_FORMAT);
            }
        } else {
            if (length == "yyyy-MM-dd'T'HH:mm:ssZ".length() + 2 || length == "yyyy-MM-dd'T'HH:mm:ssZ".length() + 3) {
                return DateKit.parse(utcString, FormatBuilder.getInstance("yyyy-MM-dd'T'HH:mm:ssZ", TimeZone.getTimeZone("UTC")));
            }
            if (length == "yyyy-MM-dd'T'HH:mm:ss.SSSZ".length() + 2 || length == "yyyy-MM-dd'T'HH:mm:ss.SSSZ".length() + 3) {
                return DateKit.parse(utcString, Fields.MSEC_FORMAT);
            }
        }
        throw new InstrumentException("No format fit for date String [{}] !", utcString);
    }

    public static DateTime truncate(Date date, Fields.DateField dateField) {
        return new DateTime(DateKit.truncate(DateKit.calendar(date), dateField));
    }

    public static Calendar truncate(Calendar calendar, Fields.DateField dateField) {
        return DateKit.modify(calendar, dateField.getValue(), Fields.ModifyType.TRUNCATE);
    }

    public static DateTime round(Date date, Fields.DateField dateField) {
        return new DateTime(DateKit.round(DateKit.calendar(date), dateField));
    }

    public static Calendar round(Calendar calendar, Fields.DateField dateField) {
        return DateKit.modify(calendar, dateField.getValue(), Fields.ModifyType.ROUND);
    }

    public static DateTime ceiling(Date date, Fields.DateField dateField) {
        return new DateTime(DateKit.ceiling(DateKit.calendar(date), dateField));
    }

    public static Calendar ceiling(Calendar calendar, Fields.DateField dateField) {
        return DateKit.modify(calendar, dateField.getValue(), Fields.ModifyType.CEILING);
    }

    public static DateTime beginOfSecond(Date date) {
        return new DateTime(DateKit.beginOfSecond(DateKit.calendar(date)));
    }

    public static DateTime endOfSecond(Date date) {
        return new DateTime(DateKit.endOfSecond(DateKit.calendar(date)));
    }

    public static Calendar beginOfSecond(Calendar calendar) {
        return DateKit.truncate(calendar, Fields.DateField.SECOND);
    }

    public static Calendar endOfSecond(Calendar calendar) {
        return DateKit.ceiling(calendar, Fields.DateField.SECOND);
    }

    public static DateTime beginOfDay(Date date) {
        return new DateTime(DateKit.beginOfDay(DateKit.calendar(date)));
    }

    public static DateTime endOfDay(Date date) {
        return new DateTime(DateKit.endOfDay(DateKit.calendar(date)));
    }

    public static Calendar beginOfDay(Calendar calendar) {
        return DateKit.truncate(calendar, Fields.DateField.DAY_OF_MONTH);
    }

    public static Calendar endOfDay(Calendar calendar) {
        return DateKit.ceiling(calendar, Fields.DateField.DAY_OF_MONTH);
    }

    public static DateTime beginOfWeek(Date date) {
        return new DateTime(DateKit.beginOfWeek(DateKit.calendar(date)));
    }

    public static DateTime endOfWeek(Date date) {
        return new DateTime(DateKit.endOfWeek(DateKit.calendar(date)));
    }

    public static Calendar beginOfWeek(Calendar calendar) {
        return DateKit.beginOfWeek(calendar, true);
    }

    public static Calendar beginOfWeek(Calendar calendar, boolean isMondayAsFirstDay) {
        calendar.setFirstDayOfWeek(isMondayAsFirstDay ? 2 : 1);
        return DateKit.truncate(calendar, Fields.DateField.WEEK_OF_MONTH);
    }

    public static Calendar endOfWeek(Calendar calendar) {
        return DateKit.endOfWeek(calendar, true);
    }

    public static Calendar endOfWeek(Calendar calendar, boolean isSundayAsLastDay) {
        calendar.setFirstDayOfWeek(isSundayAsLastDay ? 2 : 1);
        return DateKit.ceiling(calendar, Fields.DateField.WEEK_OF_MONTH);
    }

    public static DateTime beginOfMonth(Date date) {
        return new DateTime(DateKit.beginOfMonth(DateKit.calendar(date)));
    }

    public static DateTime endOfMonth(Date date) {
        return new DateTime(DateKit.endOfMonth(DateKit.calendar(date)));
    }

    public static Calendar beginOfMonth(Calendar calendar) {
        return DateKit.truncate(calendar, Fields.DateField.MONTH);
    }

    public static Calendar endOfMonth(Calendar calendar) {
        return DateKit.ceiling(calendar, Fields.DateField.MONTH);
    }

    public static DateTime beginOfQuarter(Date date) {
        return new DateTime(DateKit.beginOfQuarter(DateKit.calendar(date)));
    }

    public static DateTime endOfQuarter(Date date) {
        return new DateTime(DateKit.endOfQuarter(DateKit.calendar(date)));
    }

    public static Calendar beginOfQuarter(Calendar calendar) {
        calendar.set(2, calendar.get(Fields.DateField.MONTH.getValue()) / 3 * 3);
        calendar.set(5, 1);
        return DateKit.beginOfDay(calendar);
    }

    public static Calendar endOfQuarter(Calendar calendar) {
        calendar.set(2, calendar.get(Fields.DateField.MONTH.getValue()) / 3 * 3 + 2);
        calendar.set(5, calendar.getActualMaximum(5));
        return DateKit.endOfDay(calendar);
    }

    public static DateTime beginOfYear(Date date) {
        return new DateTime(DateKit.beginOfYear(DateKit.calendar(date)));
    }

    public static DateTime endOfYear(Date date) {
        return new DateTime(DateKit.endOfYear(DateKit.calendar(date)));
    }

    public static Calendar beginOfYear(Calendar calendar) {
        return DateKit.truncate(calendar, Fields.DateField.YEAR);
    }

    public static Calendar endOfYear(Calendar calendar) {
        return DateKit.ceiling(calendar, Fields.DateField.YEAR);
    }

    public static DateTime yesterday() {
        return DateKit.offsetDay(new DateTime(), -1);
    }

    public static DateTime tomorrow() {
        return DateKit.offsetDay(new DateTime(), 1);
    }

    public static DateTime lastWeek() {
        return DateKit.offsetWeek(new DateTime(), -1);
    }

    public static DateTime nextWeek() {
        return DateKit.offsetWeek(new DateTime(), 1);
    }

    public static DateTime lastMonth() {
        return DateKit.offsetMonth(new DateTime(), -1);
    }

    public static DateTime nextMonth() {
        return DateKit.offsetMonth(new DateTime(), 1);
    }

    public static DateTime offsetMillisecond(Date date, int offset) {
        return DateKit.offset(date, Fields.DateField.MILLISECOND, offset);
    }

    public static DateTime offsetSecond(Date date, int offset) {
        return DateKit.offset(date, Fields.DateField.SECOND, offset);
    }

    public static DateTime offsetMinute(Date date, int offset) {
        return DateKit.offset(date, Fields.DateField.MINUTE, offset);
    }

    public static DateTime offsetHour(Date date, int offset) {
        return DateKit.offset(date, Fields.DateField.HOUR_OF_DAY, offset);
    }

    public static DateTime offsetDay(Date date, int offset) {
        return DateKit.offset(date, Fields.DateField.DAY_OF_YEAR, offset);
    }

    public static DateTime offsetWeek(Date date, int offset) {
        return DateKit.offset(date, Fields.DateField.WEEK_OF_YEAR, offset);
    }

    public static DateTime offsetMonth(Date date, int offset) {
        return DateKit.offset(date, Fields.DateField.MONTH, offset);
    }

    public static DateTime offset(Date date, Fields.DateField dateField, int offset) {
        return new DateTime(date).offset(dateField, offset);
    }

    public static long between(Date beginDate, Date endDate, Fields.Unit unit) {
        return DateKit.between(beginDate, endDate, unit, true);
    }

    public static long between(Date beginDate, Date endDate, Fields.Unit unit, boolean isAbs) {
        return new Between(beginDate, endDate, isAbs).between(unit);
    }

    public static long betweenMs(Date beginDate, Date endDate) {
        return new Between(beginDate, endDate).between(Fields.Unit.MS);
    }

    public static long betweenDay(Date beginDate, Date endDate, boolean isReset) {
        if (isReset) {
            beginDate = DateKit.beginOfDay(beginDate);
            endDate = DateKit.beginOfDay(endDate);
        }
        return DateKit.between(beginDate, endDate, Fields.Unit.DAY);
    }

    public static long betweenMonth(Date beginDate, Date endDate, boolean isReset) {
        return new Between(beginDate, endDate).betweenMonth(isReset);
    }

    public static long betweenYear(Date beginDate, Date endDate, boolean isReset) {
        return new Between(beginDate, endDate).betweenYear(isReset);
    }

    public static String formatBetween(Date beginDate, Date endDate, Fields.Level level) {
        return DateKit.formatBetween(DateKit.between(beginDate, endDate, Fields.Unit.MS), level);
    }

    public static String formatBetween(Date beginDate, Date endDate) {
        return DateKit.formatBetween(DateKit.between(beginDate, endDate, Fields.Unit.MS));
    }

    public static String formatBetween(long betweenMs, Fields.Level level) {
        return new DatePeriod(betweenMs, level).format();
    }

    public static String formatBetween(long betweenMs) {
        return new DatePeriod(betweenMs, Fields.Level.MILLSECOND).format();
    }

    public static long spendNt(long preTime) {
        return System.nanoTime() - preTime;
    }

    public static long spendMs(long preTime) {
        return System.currentTimeMillis() - preTime;
    }

    public static int toIntSecond(Date date) {
        return Integer.parseInt(DateKit.format(date, "yyMMddHHmm"));
    }

    public static int weekCount(Date start, Date end) {
        Calendar startCalendar = Calendar.getInstance();
        startCalendar.setTime(start);
        Calendar endCalendar = Calendar.getInstance();
        endCalendar.setTime(end);
        int startWeekofYear = startCalendar.get(3);
        int endWeekofYear = endCalendar.get(3);
        int count = endWeekofYear - startWeekofYear + 1;
        if (1 != startCalendar.get(7)) {
            --count;
        }
        return count;
    }

    public static TimeInterval timer() {
        return new TimeInterval();
    }

    public static boolean isLeapYear(int year) {
        return new GregorianCalendar().isLeapYear(year);
    }

    public static boolean isIn(Date date, Date beginDate, Date endDate) {
        if (date instanceof DateTime) {
            return ((DateTime)date).isIn(beginDate, endDate);
        }
        return new DateTime(date).isIn(beginDate, endDate);
    }

    public static int getAge(Date birthDay) {
        return DateKit.getAge(birthDay, DateKit.date());
    }

    public static int getAge(String birthday) {
        Date birthDay = new Date(Long.parseLong(birthday));
        Calendar cal = Calendar.getInstance();
        if (cal.before(birthDay)) {
            throw new IllegalArgumentException("The birthDay is before Now.It's unbelievable!");
        }
        int yearNow = cal.get(1);
        int monthNow = cal.get(2);
        int dayOfMonthNow = cal.get(5);
        cal.setTime(birthDay);
        int yearBirth = cal.get(1);
        int monthBirth = cal.get(2);
        int dayOfMonthBirth = cal.get(5);
        int age = yearNow - yearBirth;
        if (monthNow <= monthBirth) {
            if (monthNow == monthBirth) {
                if (dayOfMonthNow < dayOfMonthBirth) {
                    --age;
                }
            } else {
                --age;
            }
        }
        return age;
    }

    public static int getAge(Date birthDay, Date dateToCompare) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(dateToCompare);
        if (cal.before(birthDay)) {
            throw new IllegalArgumentException(StringKit.format("Birthday is after date {}!", DateKit.formatDate(dateToCompare)));
        }
        int year = cal.get(1);
        int month = cal.get(2);
        int dayOfMonth = cal.get(5);
        boolean isLastDayOfMonth = dayOfMonth == cal.getActualMaximum(5);
        cal.setTime(birthDay);
        int age = year - cal.get(1);
        int monthBirth = cal.get(2);
        if (month == monthBirth) {
            boolean isLastDayOfMonthBirth;
            int dayOfMonthBirth = cal.get(5);
            boolean bl = isLastDayOfMonthBirth = dayOfMonthBirth == cal.getActualMaximum(5);
            if (!(isLastDayOfMonth && isLastDayOfMonthBirth || dayOfMonth >= dayOfMonthBirth)) {
                --age;
            }
        } else if (month < monthBirth) {
            --age;
        }
        return age;
    }

    public static int compareWithNow(Date date) {
        return date.compareTo(new Date());
    }

    public static int compareWithNow(long date) {
        long now = DateKit.timestamp();
        if (date > now) {
            return 1;
        }
        if (date < now) {
            return -1;
        }
        return 0;
    }

    public static boolean compareWithNow(String object) {
        long expired = DateKit.timestamp() - Long.parseLong(object) * 1000L;
        return expired <= 900000L && expired >= -900000L;
    }

    public static List<String> getYears(String StartDate, String endDate) {
        ArrayList<String> list = new ArrayList<String>();
        try {
            SimpleDateFormat df = new SimpleDateFormat("yyyy");
            Date date1 = df.parse(StartDate);
            Date date2 = df.parse(endDate);
            Calendar c1 = Calendar.getInstance();
            Calendar c2 = Calendar.getInstance();
            list.add(df.format(date1));
            c1.setTime(date1);
            c2.setTime(date2);
            while (c1.compareTo(c2) < 0) {
                c1.add(1, 1);
                Date ss = c1.getTime();
                String str = df.format(ss);
                list.add(str);
            }
        }
        catch (ParseException e) {
            throw new InstrumentException(e);
        }
        return list;
    }

    public static Map<String, String> getQuarters(int type, String beginkey, String endkey, String beginWkey, String endWkey, String begin, String end, String beginW, String endW) {
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy");
            Date date1 = sdf.parse(begin);
            Date dEnd = sdf.parse(end);
            Calendar calBegin = Calendar.getInstance();
            calBegin.setTime(date1);
            calBegin.set(2, DateKit.setMonthByQuarter(Integer.parseInt(beginW)));
            Calendar calEnd = Calendar.getInstance();
            calEnd.setTime(dEnd);
            calEnd.set(2, DateKit.setMonthByQuarter(Integer.parseInt(endW)));
            if (type == 1) {
                int quarter = ((Integer.parseInt(end) - Integer.parseInt(begin)) * 4 + (Integer.parseInt(endW) - Integer.parseInt(beginW)) + 1) * 3;
                calBegin.add(2, -quarter);
                calEnd.add(2, -quarter);
                map.put(beginWkey, String.valueOf(DateKit.getQuarterByMonth(calBegin.get(2))));
                map.put(endWkey, String.valueOf(DateKit.getQuarterByMonth(calEnd.get(2))));
            } else if (type == 2) {
                calBegin.add(1, -1);
                calEnd.add(1, -1);
                map.put(beginWkey, beginW);
                map.put(endWkey, endW);
            }
            map.put(beginkey, calBegin.get(1) + "-" + DateKit.setMonthByQuarterToString(0, Integer.parseInt((String)map.get(beginWkey))));
            map.put(endkey, calEnd.get(1) + "-" + DateKit.setMonthByQuarterToString(1, Integer.parseInt((String)map.get(endWkey))));
        }
        catch (ParseException e) {
            throw new InstrumentException(e);
        }
        return map;
    }

    public static List<String> getQuarters(String StartDate, String beginQ, String endDate, String endQ) {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");
            Date date1 = sdf.parse(StartDate);
            Date dEnd = sdf.parse(endDate);
            Calendar calBegin = Calendar.getInstance();
            calBegin.setTime(date1);
            Calendar calEnd = Calendar.getInstance();
            calEnd.setTime(dEnd);
            ArrayList<String> list = new ArrayList<String>();
            int beginY = calBegin.get(1);
            int beginYQ = Integer.parseInt(beginQ);
            int endY = calEnd.get(1);
            int endYQ = Integer.parseInt(endQ);
            while (true) {
                list.add(beginY + "\u5e74\u7b2c" + beginYQ + "\u5b63\u5ea6");
                if (beginY == endY && beginYQ == endYQ) {
                    return list;
                }
                if (++beginYQ <= 4) continue;
                beginYQ = 1;
                ++beginY;
            }
        }
        catch (ParseException e) {
            throw new InstrumentException(e);
        }
    }

    public static Map<String, String> getLast(int type, String beginkey, String endkey, String begin, String end) {
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            Date dBegin = Fields.PURE_DATETIME_FORMAT.parse(begin);
            Date dEnd = Fields.PURE_DATETIME_FORMAT.parse(end);
            Calendar calBegin = Calendar.getInstance();
            calBegin.setTime(dBegin);
            Calendar calEnd = Calendar.getInstance();
            calEnd.setTime(dEnd);
            if (type == 1) {
                long beginTime = dBegin.getTime();
                long endTime = dEnd.getTime();
                long inter = endTime - beginTime;
                if (inter < 0L) {
                    inter *= -1L;
                }
                long dateMillSec = 86400000L;
                long dateCnt = inter / dateMillSec;
                long remainder = inter % dateMillSec;
                if (remainder != 0L) {
                    ++dateCnt;
                }
                int day = Integer.parseInt(String.valueOf(dateCnt)) + 1;
                calBegin.add(5, -day);
                calEnd.add(5, -day);
            } else if (type == 2) {
                calBegin.add(1, -1);
                calEnd.add(1, -1);
            }
            map.put(beginkey, Fields.PURE_DATETIME_FORMAT.format(calBegin.getTime()));
            map.put(endkey, Fields.PURE_DATETIME_FORMAT.format(calEnd.getTime()));
        }
        catch (ParseException e) {
            throw new InstrumentException(e);
        }
        return map;
    }

    public static List<String> getLast(String begin, String end) {
        ArrayList<String> lDate = new ArrayList<String>();
        try {
            Date date1 = Fields.PURE_DATETIME_FORMAT.parse(begin);
            Date dEnd = Fields.PURE_DATETIME_FORMAT.parse(end);
            Calendar calBegin = Calendar.getInstance();
            calBegin.setTime(date1);
            Calendar calEnd = Calendar.getInstance();
            calEnd.setTime(dEnd);
            lDate.add(Fields.PURE_DATETIME_FORMAT.format(calBegin.getTime()));
            while (calBegin.compareTo(calEnd) < 0) {
                calBegin.add(5, 1);
                Date ss = calBegin.getTime();
                String str = Fields.PURE_DATETIME_FORMAT.format(ss);
                lDate.add(str);
            }
        }
        catch (ParseException e) {
            throw new InstrumentException(e);
        }
        return lDate;
    }

    public static Map<String, String> getLast(int type, String beginkey, String endkey, String beginWkey, String endWkey, String begin, String end, String beginW, String endW) {
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            Date date1 = Fields.PURE_DATETIME_FORMAT.parse(begin);
            Date dEnd = Fields.PURE_DATETIME_FORMAT.parse(end);
            Calendar calBegin = Calendar.getInstance();
            calBegin.setTime(date1);
            Calendar calEnd = Calendar.getInstance();
            calEnd.setTime(dEnd);
            calBegin.setFirstDayOfWeek(2);
            calEnd.setFirstDayOfWeek(2);
            if (type == 1) {
                int week = DateKit.getWeeksCount(date1, dEnd);
                calBegin.add(3, -week);
                calEnd.add(3, -week);
                map.put(beginWkey, String.valueOf(calBegin.get(3)));
                map.put(endWkey, String.valueOf(calEnd.get(3)));
                int day_of_week = calBegin.get(7) - 1;
                if (day_of_week == 0) {
                    day_of_week = 7;
                }
                calBegin.add(5, -day_of_week + 1);
                int day_of_week_end = calEnd.get(7) - 1;
                if (day_of_week_end == 0) {
                    day_of_week_end = 7;
                }
                calEnd.add(5, -day_of_week_end + 7);
            } else if (type == 2) {
                calBegin.add(1, -1);
                calEnd.add(1, -1);
                calBegin.set(3, Integer.parseInt(beginW));
                calEnd.set(3, Integer.parseInt(endW));
                map.put(beginWkey, beginW);
                map.put(endWkey, endW);
                int day_of_week = calBegin.get(7) - 1;
                if (day_of_week == 0) {
                    day_of_week = 7;
                }
                calBegin.add(5, -day_of_week + 1);
                int day_of_week_end = calEnd.get(7) - 1;
                if (day_of_week_end == 0) {
                    day_of_week_end = 7;
                }
                calEnd.add(5, -day_of_week_end + 7);
            }
            map.put(beginkey, Fields.PURE_DATETIME_FORMAT.format(calBegin.getTime()));
            map.put(endkey, Fields.PURE_DATETIME_FORMAT.format(calEnd.getTime()));
        }
        catch (ParseException e) {
            throw new InstrumentException(e);
        }
        return map;
    }

    public static Map<String, String> getLast(String beginkey, String endkey, String begin, String end) {
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy");
            Date date1 = sdf.parse(begin);
            Date dEnd = sdf.parse(end);
            Calendar calBegin = Calendar.getInstance();
            calBegin.setTime(date1);
            Calendar calEnd = Calendar.getInstance();
            calEnd.setTime(dEnd);
            int year = calBegin.get(1);
            int year1 = calEnd.get(1);
            int result = year1 - year + 1;
            calBegin.add(1, -result);
            calEnd.add(1, -result);
            map.put(beginkey, sdf.format(calBegin.getTime()));
            map.put(endkey, sdf.format(calEnd.getTime()));
        }
        catch (ParseException e) {
            throw new InstrumentException(e);
        }
        return map;
    }

    public static List<String> getMonths(String StartDate, String endDate) {
        ArrayList<String> list = new ArrayList<String>();
        try {
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM");
            Date date1 = df.parse(StartDate);
            Date date2 = df.parse(endDate);
            Calendar c1 = Calendar.getInstance();
            Calendar c2 = Calendar.getInstance();
            list.add(df.format(date1));
            c1.setTime(date1);
            c2.setTime(date2);
            while (c1.compareTo(c2) < 0) {
                c1.add(2, 1);
                Date ss = c1.getTime();
                String str = df.format(ss);
                list.add(str);
            }
        }
        catch (ParseException e) {
            throw new InstrumentException(e);
        }
        return list;
    }

    public static Map<String, String> getMonths(int type, String beginkey, String endkey, String begin, String end) {
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");
            Date date1 = sdf.parse(begin);
            Date dEnd = sdf.parse(end);
            Calendar calBegin = Calendar.getInstance();
            calBegin.setTime(date1);
            Calendar calEnd = Calendar.getInstance();
            calEnd.setTime(dEnd);
            if (type == 1) {
                int year = calBegin.get(1);
                int month = calBegin.get(2);
                int year1 = calEnd.get(1);
                int month1 = calEnd.get(2);
                int result = year == year1 ? month1 - month : 12 * (year1 - year) + month1 - month;
                calBegin.add(2, -(++result));
                calEnd.add(2, -result);
            } else if (type == 2) {
                calBegin.add(1, -1);
                calEnd.add(1, -1);
            }
            map.put(beginkey, sdf.format(calBegin.getTime()));
            map.put(endkey, sdf.format(calEnd.getTime()));
        }
        catch (ParseException e) {
            throw new InstrumentException(e);
        }
        return map;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static List<String> getWeeks(String begin, String end, String startw, String endW) {
        ArrayList<String> lDate = new ArrayList<String>();
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy");
            Date date1 = sdf.parse(begin);
            Date dEnd = sdf.parse(end);
            Calendar calBegin = Calendar.getInstance();
            calBegin.setTime(date1);
            Calendar calEnd = Calendar.getInstance();
            calEnd.setTime(dEnd);
            calBegin.setFirstDayOfWeek(2);
            int beginww = Integer.parseInt(startw);
            int endww = Integer.parseInt(endW);
            int beginY = calBegin.get(1);
            int endY = calEnd.get(1);
            int weekall = DateKit.getAllWeeks(beginY + "");
            do {
                lDate.add(beginY + "\u5e74\u7b2c" + beginww + "\u5468");
                if (beginww == weekall) {
                    beginww = 0;
                    weekall = DateKit.getAllWeeks(++beginY + "");
                }
                if (beginY == endY && beginww == endww) return lDate;
                ++beginww;
            } while (beginY <= endY);
            return lDate;
        }
        catch (ParseException e) {
            throw new InstrumentException(e);
        }
    }

    public static int getAllWeeks(String year) {
        Calendar calendar = Calendar.getInstance();
        try {
            calendar.setTime(Fields.PURE_DATETIME_FORMAT.parse(year + "-12-31"));
        }
        catch (ParseException e) {
            throw new InstrumentException(e);
        }
        calendar.setFirstDayOfWeek(2);
        int week = calendar.get(3);
        if (week != 53) {
            week = 52;
        }
        return week;
    }

    public static int getWeeksCount(Date start, Date end) {
        Calendar c_begin = Calendar.getInstance();
        c_begin.setTime(start);
        Calendar c_end = Calendar.getInstance();
        c_end.setTime(end);
        int count = 0;
        c_begin.setFirstDayOfWeek(2);
        c_end.setFirstDayOfWeek(2);
        while (c_begin.before(c_end)) {
            if (c_begin.get(7) == 1) {
                ++count;
            }
            c_begin.add(6, 1);
        }
        return count;
    }

    public static int setMonthByQuarter(int quarter) {
        if (quarter == 1) {
            return 1;
        }
        if (quarter == 2) {
            return 4;
        }
        if (quarter == 3) {
            return 7;
        }
        if (quarter == 4) {
            return 10;
        }
        return 1;
    }

    public static String setMonthByQuarterToString(int type, int quarter) {
        if (quarter == 1) {
            if (type == 1) {
                return "03";
            }
            return "01";
        }
        if (quarter == 2) {
            if (type == 1) {
                return "06";
            }
            return "04";
        }
        if (quarter == 3) {
            if (type == 1) {
                return "09";
            }
            return "07";
        }
        if (quarter == 4) {
            if (type == 1) {
                return "12";
            }
            return "10";
        }
        return "01";
    }

    public static int getQuarterByMonth(int month) {
        int quarter = 1;
        if (month >= 1 && month <= 3) {
            return 1;
        }
        if (month >= 4 && month <= 6) {
            return 2;
        }
        if (month >= 7 && month <= 9) {
            return 3;
        }
        if (month >= 10 && month <= 12) {
            return 4;
        }
        return quarter;
    }

    public static String getTimeFormatText(Date date) {
        if (date == null) {
            return null;
        }
        long diff = System.currentTimeMillis() - date.getTime();
        if (diff > Fields.Unit.DAY.getMillis()) {
            long r = diff / Fields.Unit.DAY.getMillis();
            return r + "\u5929\u524d";
        }
        if (diff > Fields.Unit.HOUR.getMillis()) {
            long r = diff / Fields.Unit.HOUR.getMillis();
            return r + "\u4e2a\u5c0f\u65f6\u524d";
        }
        if (diff > Fields.Unit.MINUTE.getMillis()) {
            long r = diff / Fields.Unit.MINUTE.getMillis();
            return r + "\u5206\u949f\u524d";
        }
        return "\u521a\u521a";
    }

    public static Date addYears(Date date, int amount) {
        return DateKit.add(date, 1, amount);
    }

    public static Date addMonths(Date date, int amount) {
        return DateKit.add(date, 2, amount);
    }

    public static Date addWeeks(Date date, int amount) {
        return DateKit.add(date, 3, amount);
    }

    public static Date addDays(Date date, int amount) {
        return DateKit.add(date, 5, amount);
    }

    public static Date addHours(Date date, int amount) {
        return DateKit.add(date, 11, amount);
    }

    public static Date addMinutes(Date date, int amount) {
        return DateKit.add(date, 12, amount);
    }

    public static Date addSeconds(Date date, int amount) {
        return DateKit.add(date, 13, amount);
    }

    public static Date addMilliseconds(Date date, int amount) {
        return DateKit.add(date, 14, amount);
    }

    private static Date add(Date date, int field, int amount) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(field, amount);
        return calendar.getTime();
    }

    public static Date setYears(Date date, int amount) {
        return DateKit.set(date, 1, amount);
    }

    public static Date setMonths(Date date, int amount) {
        return DateKit.set(date, 2, amount);
    }

    public static Date setDays(Date date, int amount) {
        return DateKit.set(date, 5, amount);
    }

    public static Date setHours(Date date, int amount) {
        return DateKit.set(date, 11, amount);
    }

    public static Date setMinutes(Date date, int amount) {
        return DateKit.set(date, 12, amount);
    }

    public static Date setSeconds(Date date, int amount) {
        return DateKit.set(date, 13, amount);
    }

    public static Date setMilliseconds(Date date, int amount) {
        return DateKit.set(date, 14, amount);
    }

    private static Date set(Date date, int field, int amount) {
        Calendar calendar = Calendar.getInstance();
        calendar.setLenient(false);
        calendar.setTime(date);
        calendar.set(field, amount);
        return calendar.getTime();
    }

    public static Calendar toCalendar(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar;
    }

    public static Calendar toCalendar(Date date, TimeZone timeZone) {
        Calendar calendar = Calendar.getInstance(timeZone);
        calendar.setTime(date);
        return calendar;
    }

    public static boolean isDate(String dptDate, String pattern) {
        if (dptDate == null || dptDate.isEmpty()) {
            return false;
        }
        String formatDate = DateKit.format(dptDate, pattern, pattern);
        return formatDate.equals(dptDate);
    }

    public static boolean isDate(String dptDate) {
        return DateKit.isDate(dptDate, "yyyy-MM-dd");
    }

    public static boolean isBefore(String go, String back, String pattern) {
        if (go == null || back == null || go.isEmpty() || back.isEmpty()) {
            return false;
        }
        Date goDate = DateKit.addDays(DateKit.parse(go, pattern), -1);
        DateTime backDate = DateKit.parse(back, pattern);
        if (goDate != null && backDate != null) {
            return goDate.before(backDate);
        }
        return false;
    }

    public static boolean isBefore(String go, String back) {
        return DateKit.isBefore(go, back, "yyyy-MM-dd");
    }

    public static boolean isDatetime(String datetime) {
        return DateKit.isDate(datetime, "yyyy-MM-dd HH:mm:ss");
    }

    public static boolean isShortDate(String date) {
        if (date == null || "".equals(date)) {
            return false;
        }
        String regex = "^([\\d]{4}(((0[13578]|1[02])((0[1-9])|([12][0-9])|(3[01])))|(((0[469])|11)((0[1-9])|([12][1-9])|30))|(02((0[1-9])|(1[0-9])|(2[1-8])))))|((((([02468][048])|([13579][26]))00)|([0-9]{2}(([02468][048])|([13579][26]))))(((0[13578]|1[02])((0[1-9])|([12][0-9])|(3[01])))|(((0[469])|11)((0[1-9])|([12][1-9])|30))|(02((0[1-9])|(1[0-9])|(2[1-9])))))$";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(date);
        return matcher.matches();
    }

    public static boolean isNotLessThanToday(String date) {
        return DateKit.isNotLessThanToday(date, "yyyy-MM-dd");
    }

    public static boolean isNotLessThanToday(String date, String format) {
        if (date == null || date.isEmpty()) {
            return false;
        }
        Date cmpDate = DateKit.addDays(new Date(), -1);
        DateTime srcDate = DateKit.parse(date, format);
        return srcDate.after(cmpDate);
    }

    public static String getZodiac(Date date) {
        return DateKit.getZodiac(DateKit.calendar(date));
    }

    public static String getZodiac(Calendar calendar) {
        if (null == calendar) {
            return null;
        }
        return DateKit.getZodiac(calendar.get(2), calendar.get(5));
    }

    public static String getZodiac(Fields.Month month, int day) {
        return DateKit.getZodiac(month.getValue(), day);
    }

    public static String getZodiac(int month, int day) {
        return day < Fields.ZODIAC_SLICED[month] ? Fields.ZODIAC[month] : Fields.ZODIAC[month + 1];
    }

    public static String getChineseZodiac(Date date) {
        return DateKit.getChineseZodiac(DateKit.calendar(date));
    }

    public static String getChineseZodiac(Calendar calendar) {
        if (null == calendar) {
            return null;
        }
        return DateKit.getChineseZodiac(calendar.get(1));
    }

    public static String getChineseZodiac(int year) {
        if (year < 1900) {
            return null;
        }
        return StringKit.toString(Fields.CN_ZODIAC[(year - 1900) % Fields.CN_ZODIAC.length]);
    }

    public static int getBeginValue(Calendar calendar, int dateField) {
        if (7 == dateField) {
            return calendar.getFirstDayOfWeek();
        }
        return calendar.getActualMinimum(dateField);
    }

    public static int getEndValue(Calendar calendar, int dateField) {
        if (7 == dateField) {
            return (calendar.getFirstDayOfWeek() + 6) % 7;
        }
        return calendar.getActualMaximum(dateField);
    }

    private static String normalize(CharSequence dateStr) {
        if (StringKit.isBlank(dateStr)) {
            return StringKit.toString(dateStr);
        }
        List<String> dateAndTime = StringKit.splitTrim(dateStr, ' ');
        int size = dateAndTime.size();
        if (size < 1 || size > 2) {
            return StringKit.toString(dateStr);
        }
        StringBuilder builder = StringKit.builder();
        String datePart = dateAndTime.get(0).replaceAll("[/.\u5e74\u6708]", "-");
        datePart = StringKit.removeSuffix(datePart, "\u65e5");
        builder.append(datePart);
        if (size == 2) {
            builder.append(' ');
            String timePart = dateAndTime.get(1).replaceAll("[\u65f6\u5206\u79d2]", ":");
            timePart = StringKit.removeSuffix(timePart, ":");
            timePart = timePart.replace(',', '.');
            builder.append(timePart);
        }
        return builder.toString();
    }

    public static Calendar modify(Calendar calendar, int dateField, Fields.ModifyType modifyType) {
        if (9 == dateField) {
            boolean isAM = DateKit.isAM(calendar);
            switch (modifyType) {
                case TRUNCATE: {
                    calendar.set(11, isAM ? 0 : 12);
                    break;
                }
                case CEILING: {
                    calendar.set(11, isAM ? 11 : 23);
                    break;
                }
                case ROUND: {
                    int min = isAM ? 0 : 12;
                    int max = isAM ? 11 : 23;
                    int href = (max - min) / 2 + 1;
                    int value = calendar.get(11);
                    calendar.set(11, value < href ? min : max);
                }
            }
            return DateKit.modify(calendar, dateField + 1, modifyType);
        }
        int[] ignoreFields = new int[]{11, 9, 8, 6, 4, 3};
        for (int i = dateField + 1; i <= 14; ++i) {
            if (ArrayKit.contains(ignoreFields, i) || (4 == dateField || 3 == dateField ? 5 == i : 7 == i)) continue;
            DateKit.modifyField(calendar, i, modifyType);
        }
        return calendar;
    }

    private static void modifyField(Calendar calendar, int field, Fields.ModifyType modifyType) {
        if (10 == field) {
            field = 11;
        }
        switch (modifyType) {
            case TRUNCATE: {
                calendar.set(field, DateKit.getBeginValue(calendar, field));
                break;
            }
            case CEILING: {
                calendar.set(field, DateKit.getEndValue(calendar, field));
                break;
            }
            case ROUND: {
                int min = DateKit.getBeginValue(calendar, field);
                int max = DateKit.getEndValue(calendar, field);
                int href = 7 == field ? (min + 3) % 7 : (max - min) / 2 + 1;
                int value = calendar.get(field);
                calendar.set(field, value < href ? min : max);
            }
        }
    }

    public static long nanosToMillis(long duration) {
        return TimeUnit.NANOSECONDS.toMillis(duration);
    }

    public static double nanosToSeconds(long duration) {
        return (double)duration / 1.0E9;
    }

    public static Instant toInstant(Date date) {
        return null == date ? null : date.toInstant();
    }

    public static Instant toInstant(Calendar calendar) {
        return null == calendar ? null : calendar.toInstant();
    }

    public static Instant toInstant(TemporalAccessor temporalAccessor) {
        if (null == temporalAccessor) {
            return null;
        }
        Instant result = temporalAccessor instanceof Instant ? (Instant)temporalAccessor : (temporalAccessor instanceof LocalDateTime ? ((LocalDateTime)temporalAccessor).atZone(ZoneId.systemDefault()).toInstant() : (temporalAccessor instanceof ZonedDateTime ? ((ZonedDateTime)temporalAccessor).toInstant() : (temporalAccessor instanceof OffsetDateTime ? ((OffsetDateTime)temporalAccessor).toInstant() : (temporalAccessor instanceof LocalDate ? ((LocalDate)temporalAccessor).atStartOfDay(ZoneId.systemDefault()).toInstant() : (temporalAccessor instanceof LocalTime ? ((LocalTime)temporalAccessor).atDate(LocalDate.now()).atZone(ZoneId.systemDefault()).toInstant() : (temporalAccessor instanceof OffsetTime ? ((OffsetTime)temporalAccessor).atDate(LocalDate.now()).toInstant() : Instant.from(temporalAccessor)))))));
        return result;
    }

    public static LocalDateTime toLocalDateTime(Instant instant) {
        return LocalDateTime.ofInstant(instant, ZoneId.systemDefault());
    }

    public static LocalDateTime toLocalDateTime(Calendar calendar) {
        return LocalDateTime.ofInstant(calendar.toInstant(), calendar.getTimeZone().toZoneId());
    }

    public static LocalDateTime toLocalDateTime(Date date) {
        DateTime dateTime = DateKit.date(date);
        return LocalDateTime.ofInstant(dateTime.toInstant(), dateTime.getZoneId());
    }

    public static int timeToSecond(String timeStr) {
        if (StringKit.isEmpty(timeStr)) {
            return 0;
        }
        List<String> hms = StringKit.splitTrim(timeStr, ":", 3, true);
        int lastIndex = hms.size() - 1;
        int result = 0;
        for (int i = lastIndex; i >= 0; --i) {
            result = (int)((double)result + (double)Integer.parseInt(hms.get(i)) * Math.pow(60.0, lastIndex - i));
        }
        return result;
    }

    public static String secondToTime(int seconds) {
        if (seconds < 0) {
            throw new IllegalArgumentException("Seconds must be a positive number!");
        }
        int hour = seconds / 3600;
        int other = seconds % 3600;
        int minute = other / 60;
        int second = other % 60;
        StringBuilder sb = new StringBuilder();
        if (hour < 10) {
            sb.append("0");
        }
        sb.append(hour);
        sb.append(":");
        if (minute < 10) {
            sb.append("0");
        }
        sb.append(minute);
        sb.append(":");
        if (second < 10) {
            sb.append("0");
        }
        sb.append(second);
        return sb.toString();
    }

    public static Boundary range(Date start, Date end, Fields.DateField unit) {
        return new Boundary(start, end, unit);
    }

    public static List<DateTime> rangeToList(Date start, Date end, Fields.DateField unit) {
        return CollKit.newArrayList(DateKit.range(start, end, unit));
    }

    public static String getDayName(int lunarDay) {
        return Fields.CN_DAY[lunarDay - 1];
    }

    public static String getMonthName(int lunarMonth) {
        return Fields.CN_MONTH[lunarMonth - 1];
    }

    public static String getYearName(int lunarYear) {
        StringBuilder sb = new StringBuilder();
        sb.append(Fields.CN_YEAR[lunarYear / 1000]);
        sb.append(Fields.CN_YEAR[lunarYear % 1000 / 100]);
        sb.append(Fields.CN_YEAR[lunarYear % 100 / 10]);
        sb.append(Fields.CN_YEAR[lunarYear % 10]);
        return sb.toString();
    }

    public static Calendar lunar2Solar(int lunarYear, int lunarMonth, int LunarDate, boolean isLeapMonth) {
        DateKit ret = new DateKit();
        ret.lunar(lunarYear, lunarMonth, LunarDate, isLeapMonth);
        return ret.solar;
    }

    public static long luanrDiff(DateKit lc1, DateKit lc2, int field) {
        return DateKit.solarDiff(lc1.solar, lc2.solar, field);
    }

    public static DateKit solar2Lunar(Calendar solar) {
        DateKit ret = new DateKit();
        ret.lunar(solar.get(1), solar.get(2), solar.get(5));
        return ret;
    }

    public static long solarDiff(int solarCode1, int solarCode2, int field) {
        GregorianCalendar c1 = new GregorianCalendar(solarCode1 / 10000, solarCode1 % 10000 / 100 - 1, solarCode1 % 10000 % 100);
        GregorianCalendar c2 = new GregorianCalendar(solarCode2 / 10000, solarCode2 % 10000 / 100 - 1, solarCode2 % 10000 % 100);
        return DateKit.solarDiff(c1, c2, field);
    }

    public static long solarDiff(Calendar solar1, Calendar solar2, int field) {
        long t1 = solar1.getTimeInMillis();
        long t2 = solar2.getTimeInMillis();
        switch (field) {
            case 13: {
                return (long)Math.rint(Double.valueOf(t1 - t2) / Double.valueOf(1000.0));
            }
            case 12: {
                return (long)Math.rint(Double.valueOf(t1 - t2) / Double.valueOf(60000.0));
            }
            case 10: {
                return (long)Math.rint(Double.valueOf(t1 - t2) / Double.valueOf(3600000.0));
            }
            case 5: {
                return (long)Math.rint(Double.valueOf(t1 - t2) / Double.valueOf(8.64E7));
            }
            case 2: {
                return (long)Math.rint(Double.valueOf(t1 - t2) / Double.valueOf(-1.702967296E9));
            }
            case 1: {
                return (long)Math.rint(Double.valueOf(t1 - t2) / Double.valueOf(1.471228928E9));
            }
        }
        return -1L;
    }

    public static String getTraditionalYearName(int y) {
        return "" + Fields.CN_GAN[(y -= 1804) % 10] + Fields.CN_ZHI[y % 12] + "\u5e74";
    }

    public static String getAnimalYearName(int y) {
        return Fields.CN_ZODIAC[(y - 4) % 12 - 1];
    }

    private static int binSearch(int[] array, int n) {
        if (null == array || array.length == 0) {
            return -1;
        }
        int min = 0;
        int max = array.length - 1;
        if (n <= array[min]) {
            return min;
        }
        if (n >= array[max]) {
            return max;
        }
        while (max - min > 1) {
            int newIndex = (max + min) / 2;
            if (array[newIndex] > n) {
                max = newIndex;
                continue;
            }
            if (array[newIndex] < n) {
                min = newIndex;
                continue;
            }
            return newIndex;
        }
        if (array[max] == n) {
            return max;
        }
        if (array[min] == n) {
            return min;
        }
        return min;
    }

    public String getFullLunarName() {
        return this.toString() + " " + DateKit.getTraditionalYearName(this.lyear) + " " + DateKit.getAnimalYearName(this.lyear);
    }

    public void add(int field, int amount) {
        this.solar.add(field, amount);
        this.lunar(this.solar.get(1), this.solar.get(2), this.solar.get(5));
    }

    public String getLunar(boolean showLeap) {
        if (this.lmonth < 1 || this.lmonth > 12 || this.ldate < 1 || this.ldate > 30) {
            throw new InstrumentException("Wrong lunar ldate: " + this.lmonth + " " + this.ldate);
        }
        if (showLeap) {
            return (this.isLeapMonth ? "\u95f0" : "") + DateKit.getMonthName(this.lmonth) + "\u6708" + DateKit.getDayName(this.ldate);
        }
        return DateKit.getMonthName(this.lmonth) + "\u6708" + DateKit.getDayName(this.ldate);
    }

    private int[] builder(int solarYear) {
        if (solarYear < 1850 && solarYear > 2150) {
            throw new InstrumentException("Illegal solar year: " + solarYear);
        }
        int lunarIndex = solarYear - 1850;
        int[] solarCodes = new int[Fields.CN_LUNAR[lunarIndex].length];
        for (int i = 0; i < solarCodes.length; ++i) {
            if (0 == i) {
                solarCodes[i] = Fields.CN_LUNAR[lunarIndex][i];
                continue;
            }
            if (1 == i) {
                if (Fields.CN_LUNAR[lunarIndex][1] > 999) {
                    solarCodes[i] = (solarYear - 1) * 10000 + Fields.CN_LUNAR[lunarIndex][i];
                    continue;
                }
                solarCodes[i] = solarYear * 10000 + Fields.CN_LUNAR[lunarIndex][i];
                continue;
            }
            solarCodes[i] = solarYear * 10000 + Fields.CN_LUNAR[lunarIndex][i];
        }
        return solarCodes;
    }

    private void lunar(int lunarYear, int lunarMonth, int lunarDate, boolean isleapMonth) {
        if (lunarYear < 1850 && lunarYear > 2150) {
            throw new InstrumentException("LunarYear must in (1850,2150)");
        }
        this.lyear = lunarYear;
        this.lmonth = lunarMonth;
        this.ldate = lunarDate;
        short solarMontDate = Fields.CN_LUNAR[lunarYear - 1850][lunarMonth];
        this.leapMonth = Fields.CN_LUNAR[lunarYear - 1850][0];
        if (this.leapMonth != 0 && (lunarMonth > this.leapMonth || lunarMonth == this.leapMonth && isleapMonth)) {
            solarMontDate = Fields.CN_LUNAR[lunarYear - 1850][lunarMonth + 1];
        }
        this.solar.set(1, lunarYear);
        this.solar.set(2, solarMontDate / 100 - 1);
        this.solar.set(5, solarMontDate % 100);
        this.add(5, lunarDate - 1);
    }

    private void lunar(int solarYear, int solarMonth, int solarDate) {
        if (solarYear < 1850 && solarYear > 2150) {
            throw new InstrumentException("Illegal solar year: " + solarYear);
        }
        int solarCode = solarYear * 10000 + 100 * (1 + solarMonth) + solarDate;
        this.leapMonth = Fields.CN_LUNAR[solarYear - 1850][0];
        int[] solarCodes = this.builder(solarYear);
        int newMonth = DateKit.binSearch(solarCodes, solarCode);
        if (-1 == newMonth) {
            throw new InstrumentException("No lunarInfo found by solarCode: " + solarCode);
        }
        int xdate = Long.valueOf(DateKit.solarDiff(solarCode, solarCodes[newMonth], 5)).intValue();
        if (0 == newMonth) {
            int preYear = solarYear - 1;
            short[] preSolarCodes = Fields.CN_LUNAR[preYear - 1850];
            int nearSolarCode = preSolarCodes[preSolarCodes.length - 1];
            nearSolarCode = (nearSolarCode / 100 == 13 ? preYear + 1 : preYear) * 10000 + (nearSolarCode / 100 == 13 ? nearSolarCode - 1200 : nearSolarCode);
            if (nearSolarCode > solarCode) {
                newMonth = 11;
                nearSolarCode = preYear * 10000 + preSolarCodes[preSolarCodes.length - 2];
            } else {
                newMonth = 12;
            }
            xdate = Long.valueOf(DateKit.solarDiff(solarCode, nearSolarCode, 5)).intValue();
            if (xdate < 0) {
                throw new InstrumentException("Wrong solarCode: " + solarCode);
            }
            this.ldate = 1 + xdate;
            this.lyear = preYear;
            this.lmonth = newMonth;
            this.isLeapMonth = false;
        } else if (solarCodes.length == newMonth + 1 && xdate >= 30) {
            newMonth = 1;
            short[] nextSolarCodes = Fields.CN_LUNAR[solarYear + 1 - 1850];
            int nearSolarCode = solarYear * 10000 + nextSolarCodes[1];
            xdate = Long.valueOf(DateKit.solarDiff(solarCode, nearSolarCode, 5)).intValue();
            if (xdate < 0) {
                throw new InstrumentException("Wrong solarCode: " + solarCode);
            }
            this.ldate = 1 + xdate;
            this.lyear = solarYear + 1;
            this.lmonth = newMonth;
            this.isLeapMonth = false;
        } else {
            if (xdate < 0) {
                throw new InstrumentException("Wrong solarCode: " + solarCode);
            }
            this.ldate = 1 + xdate;
            this.lyear = solarYear;
            this.isLeapMonth = 0 != this.leapMonth && this.leapMonth + 1 == newMonth;
            this.lmonth = 0 != this.leapMonth && this.leapMonth < newMonth ? newMonth - 1 : newMonth;
        }
        this.solar.set(1, solarYear);
        this.solar.set(2, solarMonth);
        this.solar.set(5, solarDate);
    }

    public String toString() {
        if (this.lyear < 1850 || this.lyear > 2150 || this.lmonth < 1 || this.lmonth > 12 || this.ldate < 1 || this.ldate > 30) {
            return "Wrong lunar date: " + this.lyear + " " + this.lmonth + " " + this.ldate;
        }
        return DateKit.getYearName(this.lyear) + "\u5e74" + (this.isLeapMonth ? "\u95f0" : "") + DateKit.getMonthName(this.lmonth) + "\u6708" + DateKit.getDayName(this.ldate);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DateKit that = (DateKit)o;
        if (this.lyear != that.lyear) {
            return false;
        }
        if (this.lmonth != that.lmonth) {
            return false;
        }
        if (this.ldate != that.ldate) {
            return false;
        }
        return this.isLeapMonth == that.isLeapMonth;
    }

    public int hashCode() {
        int result = this.lyear;
        result = 31 * result + this.lmonth;
        result = 31 * result + this.ldate;
        result = 31 * result + (this.isLeapMonth ? 1 : 0);
        return result;
    }
}

