/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.gitlab;

import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;

public class ISO8601 {
    public static final String PATTERN = "yyyy-MM-dd'T'HH:mm:ssZ";
    public static final String MSEC_PATTERN = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
    public static final String SPACEY_PATTERN = "yyyy-MM-dd HH:mm:ss Z";
    public static final String SPACEY_MSEC_PATTERN = "yyyy-MM-dd HH:mm:ss.SSS Z";
    public static final String PATTERN_MSEC = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
    public static final String OUTPUT_PATTERN = "yyyy-MM-dd'T'HH:mm:ss'Z'";
    public static final String OUTPUT_MSEC_PATTERN = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    public static final String UTC_PATTERN = "yyyy-MM-dd HH:mm:ss 'UTC'";
    public static final String DATE_ONLY_PATTERN = "yyyy-MM-dd";
    private static final DateTimeFormatter ODT_WITH_MSEC_PARSER = new DateTimeFormatterBuilder().appendPattern("yyyy-MM-dd[['T'][ ]HH:mm:ss.SSS[ ][XXXXX][XXXX]]").toFormatter();
    private static final DateTimeFormatter ODT_PARSER = new DateTimeFormatterBuilder().appendPattern("yyyy-MM-dd[['T'][ ]HH:mm:ss[.SSS][ ][XXX][X]]").parseDefaulting(ChronoField.HOUR_OF_DAY, 0L).parseDefaulting(ChronoField.MINUTE_OF_HOUR, 0L).parseDefaulting(ChronoField.SECOND_OF_MINUTE, 0L).parseDefaulting(ChronoField.MILLI_OF_SECOND, 0L).parseDefaulting(ChronoField.OFFSET_SECONDS, 0L).toFormatter();

    public static String getTimestamp() {
        return SafeDateFormatter.getDateFormat(PATTERN).format(new Date());
    }

    public static String getTimestamp(boolean withMsec) {
        return withMsec ? SafeDateFormatter.getDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ").format(new Date()) : SafeDateFormatter.getDateFormat(PATTERN).format(new Date());
    }

    public static String toString(Calendar cal) {
        if (cal == null) {
            return null;
        }
        return ISO8601.toString(cal.getTime());
    }

    public static String toString(Date date, boolean withMsec) {
        if (date == null) {
            return null;
        }
        long time = date.getTime();
        return withMsec && time % 1000L != 0L ? SafeDateFormatter.getDateFormat(OUTPUT_MSEC_PATTERN).format(date) : SafeDateFormatter.getDateFormat(OUTPUT_PATTERN).format(date);
    }

    public static String dateOnly(Date date) {
        if (date == null) {
            return null;
        }
        return SafeDateFormatter.getDateFormat(DATE_ONLY_PATTERN).format(date);
    }

    public static String toString(Date date) {
        return ISO8601.toString(date, true);
    }

    public static Instant toInstant(String dateTimeString) {
        if (dateTimeString == null) {
            return null;
        }
        if ((dateTimeString = dateTimeString.trim()).endsWith("Z")) {
            return Instant.parse(dateTimeString);
        }
        if (dateTimeString.endsWith("UTC")) {
            dateTimeString = dateTimeString.replace("UTC", "+0000");
        }
        OffsetDateTime odt = dateTimeString.length() > 25 ? OffsetDateTime.parse(dateTimeString, ODT_WITH_MSEC_PARSER) : OffsetDateTime.parse(dateTimeString, ODT_PARSER);
        return odt.toInstant();
    }

    public static Date toDate(String dateTimeString) {
        Instant instant = ISO8601.toInstant(dateTimeString);
        return instant != null ? Date.from(instant) : null;
    }

    public static Calendar toCalendar(String dateTimeString) {
        Date date = ISO8601.toDate(dateTimeString);
        if (date == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal;
    }

    private static final class SafeDateFormatter {
        private static final ThreadLocal<Map<String, SimpleDateFormat>> safeFormats = ThreadLocal.withInitial(() -> new ConcurrentHashMap());

        private SafeDateFormatter() {
        }

        private static SimpleDateFormat getDateFormat(String formatSpec) {
            Map<String, SimpleDateFormat> formatMap = safeFormats.get();
            SimpleDateFormat format = formatMap.get(formatSpec);
            if (format == null) {
                format = new SimpleDateFormat(formatSpec);
                format.setLenient(true);
                format.setTimeZone(TimeZone.getTimeZone("UTC"));
                formatMap.put(formatSpec, format);
            }
            return format;
        }
    }
}

