/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.gitlab.models;

import org.aoju.bus.gitlab.GitLabApiForm;

public class GroupParams {
    private String name;
    private String path;
    private String description;
    private String visibility;
    private Boolean shareWithGroupLock;
    private Boolean requireTwoFactorAuthentication;
    private Integer twoFactorGracePeriod;
    private ProjectCreationLevel projectCreationLevel;
    private Boolean autoDevopsEnabled;
    private SubgroupCreationLevel subgroupCreationLevel;
    private Boolean emailsDisabled;
    private Boolean lfsEnabled;
    private Boolean requestAccessEnabled;
    private Integer parentId;
    private Integer sharedRunnersMinutesLimit;
    private Integer extraSharedRunnersMinutesLimit;
    private Boolean membershipLock;
    private Integer fileTemplateProjectId;

    public GroupParams withParentId(Integer parentId) {
        this.parentId = parentId;
        return this;
    }

    public GroupParams withMembershipLock(Boolean membershipLock) {
        this.membershipLock = membershipLock;
        return this;
    }

    public GroupParams withFileTemplateProjectId(Integer fileTemplateProjectId) {
        this.fileTemplateProjectId = fileTemplateProjectId;
        return this;
    }

    public GroupParams withName(String name) {
        this.name = name;
        return this;
    }

    public GroupParams withPath(String path) {
        this.path = path;
        return this;
    }

    public GroupParams withDescription(String description) {
        this.description = description;
        return this;
    }

    public GroupParams withVisibility(String visibility) {
        this.visibility = visibility;
        return this;
    }

    public GroupParams withShareWithGroupLock(Boolean shareWithGroupLock) {
        this.shareWithGroupLock = shareWithGroupLock;
        return this;
    }

    public GroupParams withRequireTwoFactorAuthentication(Boolean requireTwoFactorAuthentication) {
        this.requireTwoFactorAuthentication = requireTwoFactorAuthentication;
        return this;
    }

    public GroupParams withTwoFactorGracePeriod(Integer twoFactorGracePeriod) {
        this.twoFactorGracePeriod = twoFactorGracePeriod;
        return this;
    }

    public GroupParams withProjectCreationLevel(ProjectCreationLevel projectCreationLevel) {
        this.projectCreationLevel = projectCreationLevel;
        return this;
    }

    public GroupParams withAutoDevopsEnabled(Boolean autoDevopsEnabled) {
        this.autoDevopsEnabled = autoDevopsEnabled;
        return this;
    }

    public GroupParams withSubgroupCreationLevel(SubgroupCreationLevel subgroupCreationLevel) {
        this.subgroupCreationLevel = subgroupCreationLevel;
        return this;
    }

    public GroupParams withEmailsDisabled(Boolean emailsDisabled) {
        this.emailsDisabled = emailsDisabled;
        return this;
    }

    public GroupParams withLfsEnabled(Boolean lfsEnabled) {
        this.lfsEnabled = lfsEnabled;
        return this;
    }

    public GroupParams withRequestAccessEnabled(Boolean requestAccessEnabled) {
        this.requestAccessEnabled = requestAccessEnabled;
        return this;
    }

    public GroupParams withSharedRunnersMinutesLimit(Integer sharedRunnersMinutesLimit) {
        this.sharedRunnersMinutesLimit = sharedRunnersMinutesLimit;
        return this;
    }

    public GroupParams withExtraSharedRunnersMinutesLimit(Integer extraSharedRunnersMinutesLimit) {
        this.extraSharedRunnersMinutesLimit = extraSharedRunnersMinutesLimit;
        return this;
    }

    public GitLabApiForm getForm(boolean isCreate) {
        GitLabApiForm form = new GitLabApiForm().withParam("name", this.name, isCreate).withParam("path", this.path, isCreate).withParam("description", this.description).withParam("visibility", this.visibility).withParam("share_with_group_lock", this.shareWithGroupLock).withParam("require_two_factor_authentication", this.requireTwoFactorAuthentication).withParam("two_factor_grace_period", this.twoFactorGracePeriod).withParam("project_creation_level", (Object)this.projectCreationLevel).withParam("auto_devops_enabled", this.autoDevopsEnabled).withParam("subgroup_creation_level", (Object)this.subgroupCreationLevel).withParam("emails_disabled", this.emailsDisabled).withParam("lfs_enabled", this.lfsEnabled).withParam("request_access_enabled", this.requestAccessEnabled).withParam("shared_runners_minutes_limit", this.sharedRunnersMinutesLimit).withParam("extra_shared_runners_minutes_limit", this.extraSharedRunnersMinutesLimit);
        if (isCreate) {
            form.withParam("parent_id", this.parentId);
        } else {
            form.withParam("membership_lock", this.membershipLock).withParam("file_template_project_id", this.fileTemplateProjectId);
        }
        return form;
    }

    public static enum SubgroupCreationLevel {
        OWNER,
        MAINTAINER;


        public String toString() {
            return this.name().toLowerCase();
        }
    }

    public static enum ProjectCreationLevel {
        NOONE,
        DEVELOPER,
        MAINTAINER;


        public String toString() {
            return this.name().toLowerCase();
        }
    }
}

