/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.health.mac.hardware;

import com.sun.jna.platform.mac.IOKit;
import com.sun.jna.platform.mac.IOKitUtil;
import java.nio.charset.StandardCharsets;
import java.util.function.Supplier;
import org.aoju.bus.core.annotation.Immutable;
import org.aoju.bus.core.lang.tuple.Triple;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.health.Memoize;
import org.aoju.bus.health.builtin.hardware.AbstractComputerSystem;
import org.aoju.bus.health.builtin.hardware.Baseboard;
import org.aoju.bus.health.builtin.hardware.Firmware;
import org.aoju.bus.health.mac.hardware.MacBaseboard;
import org.aoju.bus.health.mac.hardware.MacFirmware;

@Immutable
final class MacComputerSystem
extends AbstractComputerSystem {
    private final Supplier<Triple<String, String, String>> manufacturerModelSerial = Memoize.memoize(MacComputerSystem::platformExpert);

    MacComputerSystem() {
    }

    private static Triple<String, String, String> platformExpert() {
        String manufacturer = null;
        String model = null;
        String serialNumber = null;
        IOKit.IOService platformExpert = IOKitUtil.getMatchingService((String)"IOPlatformExpertDevice");
        if (platformExpert != null) {
            byte[] data = platformExpert.getByteArrayProperty("manufacturer");
            if (data != null) {
                manufacturer = new String(data, StandardCharsets.UTF_8).trim();
            }
            if ((data = platformExpert.getByteArrayProperty("model")) != null) {
                model = new String(data, StandardCharsets.UTF_8).trim();
            }
            serialNumber = platformExpert.getStringProperty("IOPlatformSerialNumber");
            platformExpert.release();
        }
        return Triple.of(StringKit.isBlank(manufacturer) ? "Apple Inc." : manufacturer, StringKit.isBlank(model) ? "unknown" : model, StringKit.isBlank(serialNumber) ? "unknown" : serialNumber);
    }

    @Override
    public String getManufacturer() {
        return this.manufacturerModelSerial.get().getLeft();
    }

    @Override
    public String getModel() {
        return this.manufacturerModelSerial.get().getMiddle();
    }

    @Override
    public String getSerialNumber() {
        return this.manufacturerModelSerial.get().getRight();
    }

    @Override
    public Firmware createFirmware() {
        return new MacFirmware();
    }

    @Override
    public Baseboard createBaseboard() {
        return new MacBaseboard();
    }
}

