/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.health.unix.solaris.drivers;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.aoju.bus.core.annotation.ThreadSafe;
import org.aoju.bus.health.Builder;
import org.aoju.bus.health.Executor;

@ThreadSafe
public final class Lshal {
    private static final String LSHAL_CMD = "lshal";

    private Lshal() {
    }

    public static Map<String, Integer> queryDiskToMajorMap() {
        HashMap<String, Integer> majorMap = new HashMap<String, Integer>();
        List<String> lshal = Executor.runNative(LSHAL_CMD);
        String diskName = null;
        for (String line : lshal) {
            if (line.startsWith("udi ")) {
                String udi = Builder.getSingleQuoteStringValue(line);
                diskName = udi.substring(udi.lastIndexOf(47) + 1);
                continue;
            }
            if (!(line = line.trim()).startsWith("block.major") || diskName == null) continue;
            majorMap.put(diskName, Builder.getFirstIntValue(line));
        }
        return majorMap;
    }
}

