/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.health.unix.solaris.software;

import java.util.List;
import org.aoju.bus.core.annotation.ThreadSafe;
import org.aoju.bus.health.Builder;
import org.aoju.bus.health.Executor;
import org.aoju.bus.health.builtin.software.InternetProtocolStats;

@ThreadSafe
public class SolarisInternetProtocolStats
implements InternetProtocolStats {
    private static InternetProtocolStats.TcpStats getTcpStats() {
        long connectionsEstablished = 0L;
        long connectionsActive = 0L;
        long connectionsPassive = 0L;
        long connectionFailures = 0L;
        long connectionsReset = 0L;
        long segmentsSent = 0L;
        long segmentsReceived = 0L;
        long segmentsRetransmitted = 0L;
        long inErrors = 0L;
        long outResets = 0L;
        List<String> netstat = Executor.runNative("netstat -s -P tcp");
        netstat.addAll(Executor.runNative("netstat -s -P ip"));
        for (String s : netstat) {
            String[] stats;
            block25: for (String stat : stats = SolarisInternetProtocolStats.splitOnPrefix(s, "tcp")) {
                String[] split;
                if (stat == null || (split = stat.split("=")).length != 2) continue;
                switch (split[0].trim()) {
                    case "tcpCurrEstab": {
                        connectionsEstablished = Builder.parseLongOrDefault(split[1].trim(), 0L);
                        continue block25;
                    }
                    case "tcpActiveOpens": {
                        connectionsActive = Builder.parseLongOrDefault(split[1].trim(), 0L);
                        continue block25;
                    }
                    case "tcpPassiveOpens": {
                        connectionsPassive = Builder.parseLongOrDefault(split[1].trim(), 0L);
                        continue block25;
                    }
                    case "tcpAttemptFails": {
                        connectionFailures = Builder.parseLongOrDefault(split[1].trim(), 0L);
                        continue block25;
                    }
                    case "tcpEstabResets": {
                        connectionsReset = Builder.parseLongOrDefault(split[1].trim(), 0L);
                        continue block25;
                    }
                    case "tcpOutSegs": {
                        segmentsSent = Builder.parseLongOrDefault(split[1].trim(), 0L);
                        continue block25;
                    }
                    case "tcpInSegs": {
                        segmentsReceived = Builder.parseLongOrDefault(split[1].trim(), 0L);
                        continue block25;
                    }
                    case "tcpRetransSegs": {
                        segmentsRetransmitted = Builder.parseLongOrDefault(split[1].trim(), 0L);
                        continue block25;
                    }
                    case "tcpInErr": {
                        inErrors = Builder.getFirstIntValue(split[1].trim());
                        continue block25;
                    }
                    case "tcpOutRsts": {
                        outResets = Builder.parseLongOrDefault(split[1].trim(), 0L);
                        continue block25;
                    }
                }
            }
        }
        return new InternetProtocolStats.TcpStats(connectionsEstablished, connectionsActive, connectionsPassive, connectionFailures, connectionsReset, segmentsSent, segmentsReceived, segmentsRetransmitted, inErrors, outResets);
    }

    private static InternetProtocolStats.UdpStats getUdpStats() {
        long datagramsSent = 0L;
        long datagramsReceived = 0L;
        long datagramsNoPort = 0L;
        long datagramsReceivedErrors = 0L;
        List<String> netstat = Executor.runNative("netstat -s -P udp");
        netstat.addAll(Executor.runNative("netstat -s -P ip"));
        for (String s : netstat) {
            String[] stats;
            block13: for (String stat : stats = SolarisInternetProtocolStats.splitOnPrefix(s, "udp")) {
                String[] split;
                if (stat == null || (split = stat.split("=")).length != 2) continue;
                switch (split[0].trim()) {
                    case "udpOutDatagrams": {
                        datagramsSent = Builder.parseLongOrDefault(split[1].trim(), 0L);
                        continue block13;
                    }
                    case "udpInDatagrams": {
                        datagramsReceived = Builder.parseLongOrDefault(split[1].trim(), 0L);
                        continue block13;
                    }
                    case "udpNoPorts": {
                        datagramsNoPort = Builder.parseLongOrDefault(split[1].trim(), 0L);
                        continue block13;
                    }
                    case "udpInErrors": {
                        datagramsReceivedErrors = Builder.parseLongOrDefault(split[1].trim(), 0L);
                        continue block13;
                    }
                }
            }
        }
        return new InternetProtocolStats.UdpStats(datagramsSent, datagramsReceived, datagramsNoPort, datagramsReceivedErrors);
    }

    private static String[] splitOnPrefix(String s, String prefix) {
        String[] stats = new String[2];
        int first = s.indexOf(prefix);
        if (first >= 0) {
            int second = s.indexOf(prefix, first + 1);
            if (second >= 0) {
                stats[0] = s.substring(first, second).trim();
                stats[1] = s.substring(second).trim();
            } else {
                stats[0] = s.substring(first).trim();
            }
        }
        return stats;
    }

    @Override
    public InternetProtocolStats.TcpStats getTCPv4Stats() {
        return SolarisInternetProtocolStats.getTcpStats();
    }

    @Override
    public InternetProtocolStats.TcpStats getTCPv6Stats() {
        return new InternetProtocolStats.TcpStats(0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L);
    }

    @Override
    public InternetProtocolStats.UdpStats getUDPv4Stats() {
        return SolarisInternetProtocolStats.getUdpStats();
    }

    @Override
    public InternetProtocolStats.UdpStats getUDPv6Stats() {
        return new InternetProtocolStats.UdpStats(0L, 0L, 0L, 0L);
    }
}

