/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.http.metric.http;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.Proxy;
import java.net.SocketPermission;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.Permission;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import org.aoju.bus.core.Version;
import org.aoju.bus.core.io.Buffer;
import org.aoju.bus.core.toolkit.DateKit;
import org.aoju.bus.http.Builder;
import org.aoju.bus.http.Callback;
import org.aoju.bus.http.Headers;
import org.aoju.bus.http.Httpd;
import org.aoju.bus.http.NewCall;
import org.aoju.bus.http.Request;
import org.aoju.bus.http.Response;
import org.aoju.bus.http.UnoUrl;
import org.aoju.bus.http.accord.platform.Platform;
import org.aoju.bus.http.bodys.BufferedBody;
import org.aoju.bus.http.bodys.OutputStreamBody;
import org.aoju.bus.http.bodys.StreamedBody;
import org.aoju.bus.http.metric.Dispatcher;
import org.aoju.bus.http.metric.Handshake;
import org.aoju.bus.http.metric.Interceptor;
import org.aoju.bus.http.metric.http.HttpHeaders;
import org.aoju.bus.http.metric.http.HttpMethod;
import org.aoju.bus.http.metric.http.StatusLine;
import org.aoju.bus.logger.Logger;

public final class HttpURLConnection
extends java.net.HttpURLConnection
implements Callback {
    public static final String SELECTED_PROTOCOL = Platform.get().getPrefix() + "-Selected-Protocol";
    public static final String RESPONSE_SOURCE = Platform.get().getPrefix() + "-Response-Source";
    private static final Set<String> METHODS = new LinkedHashSet<String>(Arrays.asList("OPTIONS", "GET", "HEAD", "POST", "PUT", "DELETE", "TRACE", "PATCH"));
    private static final Comparator<String> FIELD_NAME_COMPARATOR = (a, b) -> {
        if (a == b) {
            return 0;
        }
        if (a == null) {
            return -1;
        }
        if (b == null) {
            return 1;
        }
        return String.CASE_INSENSITIVE_ORDER.compare(a, b);
    };
    private final NetworkInterceptor networkInterceptor = new NetworkInterceptor();
    private final Object lock = new Object();
    Httpd client;
    NewCall call;
    Interceptor urlFilter;
    Response networkResponse;
    boolean connectPending = true;
    Proxy proxy;
    Handshake handshake;
    private Headers.Builder requestHeaders = new Headers.Builder();
    private boolean executed;
    private Headers responseHeaders;
    private long fixedContentLength = -1L;
    private Response response;
    private Throwable callFailure;

    public HttpURLConnection(URL url, Httpd client) {
        super(url);
        this.client = client;
    }

    public HttpURLConnection(URL url, Httpd client, Interceptor urlFilter) {
        this(url, client);
        this.urlFilter = urlFilter;
    }

    private static String responseSourceHeader(Response response) {
        if (response.networkResponse() == null) {
            if (response.cacheResponse() == null) {
                return "NONE";
            }
            return "CACHE " + response.code();
        }
        if (response.cacheResponse() == null) {
            return "NETWORK " + response.code();
        }
        return "CONDITIONAL_CACHE " + response.networkResponse().code();
    }

    private static String toHumanReadableAscii(String s) {
        int c;
        int length = s.length();
        for (int i = 0; i < length; i += Character.charCount(c)) {
            c = s.codePointAt(i);
            if (c > 31 && c < 127) continue;
            Buffer buffer = new Buffer();
            buffer.writeUtf8(s, 0, i);
            buffer.writeUtf8CodePoint(63);
            for (int j = i + Character.charCount(c); j < length; j += Character.charCount(c)) {
                c = s.codePointAt(j);
                buffer.writeUtf8CodePoint(c > 31 && c < 127 ? c : 63);
            }
            return buffer.readUtf8();
        }
        return s;
    }

    private static IOException propagate(Throwable throwable) throws IOException {
        if (throwable instanceof IOException) {
            throw (IOException)throwable;
        }
        if (throwable instanceof Error) {
            throw (Error)throwable;
        }
        if (throwable instanceof RuntimeException) {
            throw (RuntimeException)throwable;
        }
        throw new AssertionError();
    }

    public static Map<String, List<String>> toMultimap(Headers headers, String valueForNullKey) {
        TreeMap result = new TreeMap(FIELD_NAME_COMPARATOR);
        int size = headers.size();
        for (int i = 0; i < size; ++i) {
            String fieldName = headers.name(i);
            String value = headers.value(i);
            ArrayList<String> allValues = new ArrayList<String>();
            List otherValues = (List)result.get(fieldName);
            if (otherValues != null) {
                allValues.addAll(otherValues);
            }
            allValues.add(value);
            result.put(fieldName, Collections.unmodifiableList(allValues));
        }
        if (valueForNullKey != null) {
            result.put(null, Collections.unmodifiableList(Collections.singletonList(valueForNullKey)));
        }
        return Collections.unmodifiableMap(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connect() throws IOException {
        if (this.executed) {
            return;
        }
        NewCall call = this.buildCall();
        this.executed = true;
        call.enqueue(this);
        Object object = this.lock;
        synchronized (object) {
            try {
                while (this.connectPending && this.response == null && this.callFailure == null) {
                    this.lock.wait();
                }
                if (this.callFailure != null) {
                    throw HttpURLConnection.propagate(this.callFailure);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new InterruptedIOException();
            }
        }
    }

    @Override
    public void disconnect() {
        if (this.call == null) {
            return;
        }
        this.networkInterceptor.proceed();
        this.call.cancel();
    }

    @Override
    public InputStream getErrorStream() {
        try {
            Response response = this.getResponse(true);
            if (HttpHeaders.hasBody(response) && response.code() >= 400) {
                return response.body().byteStream();
            }
            return null;
        }
        catch (IOException e) {
            return null;
        }
    }

    private Headers getHeaders() throws IOException {
        if (this.responseHeaders == null) {
            Response response = this.getResponse(true);
            Headers headers = response.headers();
            this.responseHeaders = headers.newBuilder().add(SELECTED_PROTOCOL, response.protocol().toString()).add(RESPONSE_SOURCE, HttpURLConnection.responseSourceHeader(response)).build();
        }
        return this.responseHeaders;
    }

    @Override
    public String getHeaderField(int position) {
        try {
            Headers headers = this.getHeaders();
            if (position < 0 || position >= headers.size()) {
                return null;
            }
            return headers.value(position);
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public String getHeaderField(String fieldName) {
        try {
            return fieldName == null ? StatusLine.get(this.getResponse(true)).toString() : this.getHeaders().get(fieldName);
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public String getHeaderFieldKey(int position) {
        try {
            Headers headers = this.getHeaders();
            if (position < 0 || position >= headers.size()) {
                return null;
            }
            return headers.name(position);
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public Map<String, List<String>> getHeaderFields() {
        try {
            return HttpURLConnection.toMultimap(this.getHeaders(), StatusLine.get(this.getResponse(true)).toString());
        }
        catch (IOException e) {
            return Collections.emptyMap();
        }
    }

    @Override
    public Map<String, List<String>> getRequestProperties() {
        if (this.connected) {
            throw new IllegalStateException("Cannot access request header fields after connection is set");
        }
        return HttpURLConnection.toMultimap(this.requestHeaders.build(), null);
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (!this.doInput) {
            throw new ProtocolException("This protocol does not support input");
        }
        Response response = this.getResponse(false);
        if (response.code() >= 400) {
            throw new FileNotFoundException(this.url.toString());
        }
        return response.body().byteStream();
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        OutputStreamBody requestBody = (OutputStreamBody)this.buildCall().request().body();
        if (requestBody == null) {
            throw new ProtocolException("method does not support a request body: " + this.method);
        }
        if (requestBody instanceof StreamedBody) {
            this.connect();
            this.networkInterceptor.proceed();
        }
        if (requestBody.isClosed()) {
            throw new ProtocolException("cannot write request body after response has been read");
        }
        return requestBody.outputStream();
    }

    @Override
    public Permission getPermission() {
        int hostPort;
        URL url = this.getURL();
        String hostname = url.getHost();
        int n = hostPort = url.getPort() != -1 ? url.getPort() : UnoUrl.defaultPort(url.getProtocol());
        if (this.usingProxy()) {
            InetSocketAddress proxyAddress = (InetSocketAddress)this.client.proxy().address();
            hostname = proxyAddress.getHostName();
            hostPort = proxyAddress.getPort();
        }
        return new SocketPermission(hostname + ":" + hostPort, "connect, resolve");
    }

    @Override
    public String getRequestProperty(String field) {
        if (field == null) {
            return null;
        }
        return this.requestHeaders.get(field);
    }

    @Override
    public boolean getInstanceFollowRedirects() {
        return this.client.followRedirects();
    }

    @Override
    public void setInstanceFollowRedirects(boolean followRedirects) {
        this.client = this.client.newBuilder().followRedirects(followRedirects).build();
    }

    @Override
    public int getConnectTimeout() {
        return this.client.connectTimeoutMillis();
    }

    @Override
    public void setConnectTimeout(int timeoutMillis) {
        this.client = this.client.newBuilder().connectTimeout(timeoutMillis, TimeUnit.MILLISECONDS).build();
    }

    @Override
    public int getReadTimeout() {
        return this.client.readTimeoutMillis();
    }

    @Override
    public void setReadTimeout(int timeoutMillis) {
        this.client = this.client.newBuilder().readTimeout(timeoutMillis, TimeUnit.MILLISECONDS).build();
    }

    private NewCall buildCall() throws IOException {
        UnoUrl url;
        if (this.call != null) {
            return this.call;
        }
        this.connected = true;
        if (this.doOutput) {
            if (this.method.equals("GET")) {
                this.method = "POST";
            } else if (!HttpMethod.permitsRequestBody(this.method)) {
                throw new ProtocolException(this.method + " does not support writing");
            }
        }
        if (this.requestHeaders.get("User-Agent") == null) {
            this.requestHeaders.add("User-Agent", this.defaultUserAgent());
        }
        OutputStreamBody requestBody = null;
        if (HttpMethod.permitsRequestBody(this.method)) {
            String contentType = this.requestHeaders.get("Content-Type");
            if (contentType == null) {
                contentType = "application/x-www-form-urlencoded";
                this.requestHeaders.add("Content-Type", contentType);
            }
            boolean stream = this.fixedContentLength != -1L || this.chunkLength > 0;
            long contentLength = -1L;
            String contentLengthString = this.requestHeaders.get("Content-Length");
            if (this.fixedContentLength != -1L) {
                contentLength = this.fixedContentLength;
            } else if (contentLengthString != null) {
                contentLength = Long.parseLong(contentLengthString);
            }
            requestBody = stream ? new StreamedBody(contentLength) : new BufferedBody(contentLength);
            requestBody.timeout().timeout(this.client.writeTimeoutMillis(), TimeUnit.MILLISECONDS);
        }
        try {
            url = UnoUrl.get(this.getURL().toString());
        }
        catch (IllegalArgumentException e) {
            if (Builder.instance.isInvalidHttpUrlHost(e)) {
                UnknownHostException unknownHost = new UnknownHostException();
                unknownHost.initCause(e);
                throw unknownHost;
            }
            MalformedURLException malformedUrl = new MalformedURLException();
            malformedUrl.initCause(e);
            throw malformedUrl;
        }
        Request request = new Request.Builder().url(url).headers(this.requestHeaders.build()).method(this.method, requestBody).build();
        Httpd.Builder clientBuilder = this.client.newBuilder();
        clientBuilder.interceptors().clear();
        clientBuilder.interceptors().add(UnexpectedException.INTERCEPTOR);
        clientBuilder.networkInterceptors().clear();
        clientBuilder.networkInterceptors().add(this.networkInterceptor);
        clientBuilder.dispatcher(new Dispatcher(this.client.dispatcher().executorService()));
        if (!this.getUseCaches()) {
            clientBuilder.cache(null);
        }
        this.call = clientBuilder.build().newCall(request);
        return this.call;
    }

    private String defaultUserAgent() {
        String agent = System.getProperty("http.agent");
        return agent != null ? HttpURLConnection.toHumanReadableAscii(agent) : Version.all();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Response getResponse(boolean networkResponseOnError) throws IOException {
        Object object;
        Object object2 = this.lock;
        synchronized (object2) {
            if (this.response != null) {
                return this.response;
            }
            if (this.callFailure != null) {
                if (networkResponseOnError && this.networkResponse != null) {
                    return this.networkResponse;
                }
                throw HttpURLConnection.propagate(this.callFailure);
            }
        }
        NewCall call = this.buildCall();
        this.networkInterceptor.proceed();
        OutputStreamBody requestBody = (OutputStreamBody)call.request().body();
        if (requestBody != null) {
            requestBody.outputStream().close();
        }
        if (this.executed) {
            object = this.lock;
            synchronized (object) {
                try {
                    while (this.response == null && this.callFailure == null) {
                        this.lock.wait();
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new InterruptedIOException();
                }
            }
        }
        this.executed = true;
        try {
            this.onResponse(call, call.execute());
        }
        catch (IOException e) {
            this.onFailure(call, e);
        }
        object = this.lock;
        synchronized (object) {
            if (this.callFailure != null) {
                throw HttpURLConnection.propagate(this.callFailure);
            }
            if (this.response != null) {
                return this.response;
            }
        }
        throw new AssertionError();
    }

    @Override
    public boolean usingProxy() {
        if (this.proxy != null) {
            return true;
        }
        Proxy clientProxy = this.client.proxy();
        return clientProxy != null && clientProxy.type() != Proxy.Type.DIRECT;
    }

    @Override
    public String getResponseMessage() throws IOException {
        return this.getResponse(true).message();
    }

    @Override
    public int getResponseCode() throws IOException {
        return this.getResponse(true).code();
    }

    @Override
    public void setRequestProperty(String field, String newValue) {
        if (this.connected) {
            throw new IllegalStateException("Cannot set request property after connection is made");
        }
        if (field == null) {
            throw new NullPointerException("field == null");
        }
        if (newValue == null) {
            Logger.warn("Ignoring header " + field + " because its value was null.", null);
            return;
        }
        this.requestHeaders.set(field, newValue);
    }

    @Override
    public void setIfModifiedSince(long newValue) {
        super.setIfModifiedSince(newValue);
        if (this.ifModifiedSince != 0L) {
            this.requestHeaders.set("If-Modified-Since", DateKit.format(new Date(this.ifModifiedSince)));
        } else {
            this.requestHeaders.removeAll("If-Modified-Since");
        }
    }

    @Override
    public void addRequestProperty(String field, String value) {
        if (this.connected) {
            throw new IllegalStateException("Cannot add request property after connection is made");
        }
        if (field == null) {
            throw new NullPointerException("field == null");
        }
        if (value == null) {
            Logger.warn("Ignoring header " + field + " because its value was null.", null);
            return;
        }
        this.requestHeaders.add(field, value);
    }

    @Override
    public void setRequestMethod(String method) throws ProtocolException {
        if (!METHODS.contains(method)) {
            throw new ProtocolException("Expected one of " + METHODS + " but was " + method);
        }
        this.method = method;
    }

    @Override
    public void setFixedLengthStreamingMode(int contentLength) {
        this.setFixedLengthStreamingMode((long)contentLength);
    }

    @Override
    public void setFixedLengthStreamingMode(long contentLength) {
        if (this.connected) {
            throw new IllegalStateException("Already connected");
        }
        if (this.chunkLength > 0) {
            throw new IllegalStateException("Already in chunked mode");
        }
        if (contentLength < 0L) {
            throw new IllegalArgumentException("contentLength < 0");
        }
        this.fixedContentLength = contentLength;
        ((java.net.HttpURLConnection)this).fixedContentLength = (int)Math.min(contentLength, Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onFailure(NewCall call, IOException e) {
        Object object = this.lock;
        synchronized (object) {
            this.callFailure = e instanceof UnexpectedException ? e.getCause() : e;
            this.lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onResponse(NewCall call, Response response) {
        Object object = this.lock;
        synchronized (object) {
            this.response = response;
            this.handshake = response.handshake();
            this.url = response.request().url().url();
            this.lock.notifyAll();
        }
    }

    final class NetworkInterceptor
    implements Interceptor {
        private boolean proceed;

        NetworkInterceptor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void proceed() {
            Object object = HttpURLConnection.this.lock;
            synchronized (object) {
                this.proceed = true;
                HttpURLConnection.this.lock.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Response intercept(Interceptor.Chain chain) throws IOException {
            Request request = chain.request();
            Object object = HttpURLConnection.this.lock;
            synchronized (object) {
                HttpURLConnection.this.connectPending = false;
                HttpURLConnection.this.proxy = chain.connection().route().proxy();
                HttpURLConnection.this.handshake = chain.connection().handshake();
                HttpURLConnection.this.lock.notifyAll();
                try {
                    while (!this.proceed) {
                        HttpURLConnection.this.lock.wait();
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new InterruptedIOException();
                }
            }
            if (request.body() instanceof OutputStreamBody) {
                OutputStreamBody requestBody = (OutputStreamBody)request.body();
                request = requestBody.prepareToSendRequest(request);
            }
            Response response = chain.proceed(request);
            Object object2 = HttpURLConnection.this.lock;
            synchronized (object2) {
                HttpURLConnection.this.networkResponse = response;
                HttpURLConnection.this.url = response.request().url().url();
            }
            return response;
        }
    }

    static final class UnexpectedException
    extends IOException {
        static final Interceptor INTERCEPTOR = chain -> {
            try {
                return chain.proceed(chain.request());
            }
            catch (Error | RuntimeException e) {
                throw new UnexpectedException(e);
            }
        };

        UnexpectedException(Throwable cause) {
            super(cause);
        }
    }
}

