/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.image.metric.internal.hl7;

public abstract class HL7Charset {
    public static String toCharsetName(String code) {
        if (code != null && !code.isEmpty()) {
            switch (code.charAt(code.length() - 1)) {
                case '0': {
                    if (!code.equals("GB 18030-2000")) break;
                    return "GB18030";
                }
                case '1': {
                    if (code.equals("8859/1")) {
                        return "ISO-8859-1";
                    }
                    if (!code.equals("KS X 1001")) break;
                    return "EUC-KR";
                }
                case '2': {
                    if (code.equals("8859/2")) {
                        return "ISO-8859-2";
                    }
                    if (!code.equals("CNS 11643-1992")) break;
                    return "TIS-620";
                }
                case '3': {
                    if (!code.equals("8859/3")) break;
                    return "ISO-8859-3";
                }
                case '4': {
                    if (code.equals("8859/4")) {
                        return "ISO-8859-4";
                    }
                    if (!code.equals("ISO IR14")) break;
                    return "JIS_X0201";
                }
                case '5': {
                    if (!code.equals("8859/5")) break;
                    return "ISO-8859-5";
                }
                case '6': {
                    if (!code.equals("8859/6")) break;
                    return "ISO-8859-6";
                }
                case '7': {
                    if (code.equals("8859/7")) {
                        return "ISO-8859-7";
                    }
                    if (!code.equals("ISO IR87")) break;
                    return "x-JIS0208";
                }
                case '8': {
                    if (code.equals("8859/8")) {
                        return "ISO-8859-8";
                    }
                    if (!code.equals("UNICODE UTF-8")) break;
                    return "UTF-8";
                }
                case '9': {
                    if (code.equals("8859/9")) {
                        return "ISO-8859-9";
                    }
                    if (!code.equals("ISO IR159")) break;
                    return "JIS_X0212-1990";
                }
                case 'E': {
                    if (!code.equals("UNICODE")) break;
                    return "UTF-8";
                }
            }
        }
        return "US-ASCII";
    }

    public static String toCharacterSetCode(String code) {
        if (code != null && !code.isEmpty()) {
            switch (code.charAt(code.length() - 1)) {
                case '0': {
                    if (!code.equals("GB 18030-2000")) break;
                    return "GB18030";
                }
                case '1': {
                    if (code.equals("8859/1")) {
                        return "ISO_IR 100";
                    }
                    if (!code.equals("KS X 1001")) break;
                    return "ISO 2022 IR 149";
                }
                case '2': {
                    if (code.equals("8859/2")) {
                        return "ISO_IR 101";
                    }
                    if (!code.equals("CNS 11643-1992")) break;
                    return "ISO_IR 166";
                }
                case '3': {
                    if (!code.equals("8859/3")) break;
                    return "ISO_IR 109";
                }
                case '4': {
                    if (code.equals("8859/4")) {
                        return "ISO_IR 110";
                    }
                    if (!code.equals("ISO IR14")) break;
                    return "ISO_IR 13";
                }
                case '5': {
                    if (!code.equals("8859/5")) break;
                    return "ISO_IR 144";
                }
                case '6': {
                    if (!code.equals("8859/6")) break;
                    return "ISO_IR 127";
                }
                case '7': {
                    if (code.equals("8859/7")) {
                        return "ISO_IR 126";
                    }
                    if (!code.equals("ISO IR87")) break;
                    return "ISO 2022 IR 87";
                }
                case '8': {
                    if (code.equals("8859/8")) {
                        return "ISO_IR 138";
                    }
                    if (!code.equals("UNICODE UTF-8")) break;
                    return "ISO_IR 192";
                }
                case '9': {
                    if (code.equals("8859/9")) {
                        return "ISO_IR 148";
                    }
                    if (!code.equals("ISO IR159")) break;
                    return "ISO 2022 IR 159";
                }
                case 'E': {
                    if (!code.equals("UNICODE")) break;
                    return "ISO_IR 192";
                }
            }
        }
        return null;
    }
}

