/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.image.nimble.codec;

import java.io.Serializable;
import java.util.EnumSet;
import org.aoju.bus.image.galaxy.Property;
import org.aoju.bus.image.nimble.Photometric;
import org.aoju.bus.image.nimble.codec.ImageDescriptor;

public class CompressionRule
implements Comparable<CompressionRule>,
Serializable {
    private final String commonName;
    private final Condition condition;
    private final String tsuid;
    private final Property[] imageWriteParams;

    public CompressionRule(String commonName, String[] pmis, int[] bitsStored, int pixelRepresentation, String[] aeTitles, String[] sopClasses, String[] bodyPartExamined, String tsuid, String ... params) {
        this.commonName = commonName;
        this.condition = new Condition(pmis, bitsStored, pixelRepresentation, Property.maskNull(aeTitles), Property.maskNull(sopClasses), Property.maskNull(bodyPartExamined));
        this.tsuid = tsuid;
        this.imageWriteParams = Property.valueOf(params);
    }

    public final String getCommonName() {
        return this.commonName;
    }

    public Photometric[] getPhotometricInterpretations() {
        return this.condition.getPhotometricInterpretations();
    }

    public int[] getBitsStored() {
        return this.condition.getBitsStored();
    }

    public final int getPixelRepresentation() {
        return this.condition.pixelRepresentation;
    }

    public final String[] getAETitles() {
        return this.condition.aeTitles;
    }

    public final String[] getSOPClasses() {
        return this.condition.sopClasses;
    }

    public final String[] getBodyPartExamined() {
        return this.condition.bodyPartExamined;
    }

    public final String getTransferSyntax() {
        return this.tsuid;
    }

    public Property[] getImageWriteParams() {
        return this.imageWriteParams;
    }

    public boolean matchesCondition(String aeTitle, ImageDescriptor imageDescriptor) {
        return this.condition.matches(aeTitle, imageDescriptor);
    }

    @Override
    public int compareTo(CompressionRule o) {
        return this.condition.compareTo(o.condition);
    }

    private static class Condition
    implements Comparable<Condition>,
    Serializable {
        final EnumSet<Photometric> pmis = EnumSet.noneOf(Photometric.class);
        final int bitsStoredMask;
        final int pixelRepresentation = -1;
        final String[] aeTitles;
        final String[] sopClasses;
        final String[] bodyPartExamined;
        final int weight;

        Condition(String[] pmis, int[] bitsStored, int pixelRepresentation, String[] aeTitles, String[] sopClasses, String[] bodyPartExamined) {
            for (String pmi : pmis) {
                this.pmis.add(Photometric.fromString(pmi));
            }
            this.bitsStoredMask = this.toBitsStoredMask(bitsStored);
            this.aeTitles = aeTitles;
            this.sopClasses = sopClasses;
            this.bodyPartExamined = bodyPartExamined;
            this.weight = (aeTitles.length != 0 ? 4 : 0) + (sopClasses.length != 0 ? 2 : 0) + (bodyPartExamined.length != 0 ? 1 : 0);
        }

        private static boolean isEmptyOrContains(Object[] a, Object o) {
            if (o == null || a.length == 0) {
                return true;
            }
            for (int i = 0; i < a.length; ++i) {
                if (!o.equals(a[i])) continue;
                return true;
            }
            return false;
        }

        private int toBitsStoredMask(int[] bitsStored) {
            int mask = 0;
            for (int i : bitsStored) {
                mask |= 1 << i;
            }
            return mask;
        }

        Photometric[] getPhotometricInterpretations() {
            return this.pmis.toArray(new Photometric[this.pmis.size()]);
        }

        int[] getBitsStored() {
            int n = 0;
            for (int i = 8; i <= 16; ++i) {
                if (!this.matchBitStored(i)) continue;
                ++n;
            }
            int[] bitsStored = new int[n];
            int j = 0;
            for (int i = 8; i <= 16; ++i) {
                if (!this.matchBitStored(i)) continue;
                bitsStored[j++] = i;
            }
            return bitsStored;
        }

        @Override
        public int compareTo(Condition o) {
            return o.weight - this.weight;
        }

        public boolean matches(String aeTitle, ImageDescriptor imageDescriptor) {
            return this.pmis.contains((Object)imageDescriptor.getPhotometric()) && this.matchBitStored(imageDescriptor.getBitsStored()) && this.matchPixelRepresentation(imageDescriptor.getPixelRepresentation()) && Condition.isEmptyOrContains(this.aeTitles, aeTitle) && Condition.isEmptyOrContains(this.sopClasses, imageDescriptor.getSopClassUID()) && Condition.isEmptyOrContains(this.bodyPartExamined, imageDescriptor.getBodyPartExamined());
        }

        private boolean matchPixelRepresentation(int pixelRepresentation) {
            return this.pixelRepresentation == -1 || this.pixelRepresentation == pixelRepresentation;
        }

        private boolean matchBitStored(int bitsStored) {
            return (1 << bitsStored & this.bitsStoredMask) != 0;
        }
    }
}

