/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.image.nimble.opencv;

import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.util.Objects;
import org.aoju.bus.image.nimble.opencv.ImageCV;
import org.aoju.bus.image.nimble.opencv.ImageConversion;
import org.opencv.core.CvType;
import org.opencv.core.Mat;

public class LookupTableCV {
    private final int[] offsets;
    private final DataBuffer data;

    public LookupTableCV(byte[] data) {
        this.offsets = new int[1];
        this.initOffsets(0);
        this.data = new DataBufferByte(Objects.requireNonNull(data), data.length);
    }

    public LookupTableCV(byte[] data, int offset) {
        this.offsets = new int[1];
        this.initOffsets(offset);
        this.data = new DataBufferByte(Objects.requireNonNull(data), data.length);
    }

    public LookupTableCV(byte[][] data) {
        this.offsets = new int[data.length];
        this.initOffsets(0);
        this.data = new DataBufferByte(Objects.requireNonNull(data), data[0].length);
    }

    public LookupTableCV(byte[][] data, int offset) {
        this.offsets = new int[data.length];
        this.initOffsets(offset);
        this.data = new DataBufferByte(Objects.requireNonNull(data), data[0].length);
    }

    public LookupTableCV(byte[][] data, int[] offsets) {
        this.offsets = new int[data.length];
        this.initOffsets(offsets);
        this.data = new DataBufferByte(Objects.requireNonNull(data), data[0].length);
    }

    public LookupTableCV(short[] data, int offset, boolean isUShort) {
        this.offsets = new int[1];
        this.initOffsets(offset);
        this.data = isUShort ? new DataBufferUShort(Objects.requireNonNull(data), data.length) : new DataBufferShort(Objects.requireNonNull(data), data.length);
    }

    private void initOffsets(int offset) {
        for (int i = 0; i < this.offsets.length; ++i) {
            this.offsets[i] = offset;
        }
    }

    private void initOffsets(int[] offset) {
        for (int i = 0; i < this.offsets.length; ++i) {
            this.offsets[i] = offset[i];
        }
    }

    public DataBuffer getData() {
        return this.data;
    }

    public byte[][] getByteData() {
        return this.data instanceof DataBufferByte ? ((DataBufferByte)this.data).getBankData() : (byte[][])null;
    }

    public byte[] getByteData(int band) {
        return this.data instanceof DataBufferByte ? ((DataBufferByte)this.data).getData(band) : null;
    }

    public short[][] getShortData() {
        if (this.data instanceof DataBufferUShort) {
            return ((DataBufferUShort)this.data).getBankData();
        }
        if (this.data instanceof DataBufferShort) {
            return ((DataBufferShort)this.data).getBankData();
        }
        return null;
    }

    public short[] getShortData(int band) {
        if (this.data instanceof DataBufferUShort) {
            return ((DataBufferUShort)this.data).getData(band);
        }
        if (this.data instanceof DataBufferShort) {
            return ((DataBufferShort)this.data).getData(band);
        }
        return null;
    }

    public int[] getOffsets() {
        return this.offsets;
    }

    public int getOffset() {
        return this.offsets[0];
    }

    public int getOffset(int band) {
        return this.offsets[band];
    }

    public int getNumBands() {
        return this.data.getNumBanks();
    }

    public int getNumEntries() {
        return this.data.getSize();
    }

    public int getDataType() {
        return this.data.getDataType();
    }

    public int lookup(int band, int value) {
        return this.data.getElem(band, value - this.offsets[band]);
    }

    public ImageCV lookup(Mat src) {
        Objects.requireNonNull(src);
        int width = src.width();
        int height = src.height();
        int cvType = src.type();
        int channels = CvType.channels((int)cvType);
        int srcDataType = ImageConversion.convertToDataType(cvType);
        byte[] bSrcData = null;
        short[] sSrcData = null;
        if (CvType.depth((int)cvType) == 0 || CvType.depth((int)cvType) == 1) {
            bSrcData = new byte[width * height * channels];
            src.get(0, 0, bSrcData);
        } else if (CvType.depth((int)cvType) == 2 || CvType.depth((int)cvType) == 3) {
            sSrcData = new short[width * height * channels];
            src.get(0, 0, sSrcData);
        } else {
            throw new IllegalArgumentException("Not suported dataType for LUT transformation:" + src.toString());
        }
        int lkbBands = this.getNumBands();
        int lkpDataType = this.getDataType();
        int[] tblOffsets = this.getOffsets();
        Object bTblData = this.getByteData();
        short[][] sTblData = this.getShortData();
        if (lkbBands < channels) {
            byte[] b = bTblData[0];
            bTblData = new byte[channels][];
            for (int i = 0; i < ((byte[][])bTblData).length; ++i) {
                bTblData[i] = b;
            }
            int t = tblOffsets[0];
            tblOffsets = new int[channels];
            for (int i = 0; i < tblOffsets.length; ++i) {
                tblOffsets[i] = t;
            }
            lkbBands = channels;
        }
        if (lkpDataType == 0) {
            byte[] bDstData;
            boolean scrByte = srcDataType == 0;
            byte[] byArray = bDstData = scrByte && channels >= lkbBands ? bSrcData : new byte[width * height * lkbBands];
            if (scrByte && bSrcData != null) {
                this.lookup(bSrcData, bDstData, tblOffsets, (byte[][])bTblData);
            } else if (srcDataType == 1 && sSrcData != null && bDstData != null) {
                this.lookupU(sSrcData, bDstData, tblOffsets, (byte[][])bTblData);
            } else if (srcDataType == 2 && sSrcData != null && bDstData != null) {
                this.lookup(sSrcData, bDstData, tblOffsets, (byte[][])bTblData);
            } else {
                throw new IllegalArgumentException("Not supported LUT conversion from source dataType " + srcDataType);
            }
            ImageCV dst = new ImageCV(height, width, CvType.CV_8UC((int)lkbBands));
            dst.put(0, 0, bDstData);
            return dst;
        }
        if (lkpDataType == 1 || lkpDataType == 2) {
            short[] sDstData;
            boolean scrByte = srcDataType == 0;
            short[] sArray = sDstData = !scrByte && channels >= lkbBands ? sSrcData : new short[width * height * lkbBands];
            if (scrByte) {
                this.lookup(bSrcData, sDstData, tblOffsets, sTblData);
            } else if (srcDataType == 1) {
                this.lookupU(sSrcData, sDstData, tblOffsets, sTblData);
            } else if (srcDataType == 2) {
                this.lookup(sSrcData, sDstData, tblOffsets, sTblData);
            } else {
                throw new IllegalArgumentException("Not supported LUT conversion from source dataType " + srcDataType);
            }
            ImageCV dst = new ImageCV(height, width, lkpDataType == 1 ? CvType.CV_16UC((int)channels) : CvType.CV_16SC((int)channels));
            dst.put(0, 0, sDstData);
            return dst;
        }
        return null;
    }

    private void lookup(byte[] srcData, byte[] dstData, int[] tblOffsets, byte[][] tblData) {
        int bOffset = tblData.length;
        if (srcData.length < dstData.length) {
            for (int i = 0; i < srcData.length; ++i) {
                int val = srcData[i] & 0xFF;
                for (int b = 0; b < bOffset; ++b) {
                    dstData[i * bOffset + b] = tblData[b][val - tblOffsets[b]];
                }
            }
        } else {
            for (int b = 0; b < bOffset; ++b) {
                byte[] t = tblData[b];
                int tblOffset = tblOffsets[b];
                for (int i = b; i < srcData.length; i += bOffset) {
                    dstData[i] = t[(srcData[i] & 0xFF) - tblOffset];
                }
            }
        }
    }

    private void lookupU(short[] srcData, byte[] dstData, int[] tblOffsets, byte[][] tblData) {
        int bOffset = tblData.length;
        if (srcData.length < dstData.length) {
            for (int i = 0; i < srcData.length; ++i) {
                int val = srcData[i] & 0xFFFF;
                for (int b = 0; b < bOffset; ++b) {
                    dstData[i * bOffset + b] = tblData[b][val - tblOffsets[b]];
                }
            }
        } else {
            for (int b = 0; b < bOffset; ++b) {
                byte[] t = tblData[b];
                int tblOffset = tblOffsets[b];
                for (int i = b; i < srcData.length; i += bOffset) {
                    dstData[i] = t[(srcData[i] & 0xFFFF) - tblOffset];
                }
            }
        }
    }

    private void lookup(short[] srcData, byte[] dstData, int[] tblOffsets, byte[][] tblData) {
        int bOffset = tblData.length;
        if (srcData.length < dstData.length) {
            for (int i = 0; i < srcData.length; ++i) {
                short val = srcData[i];
                for (int b = 0; b < bOffset; ++b) {
                    dstData[i * bOffset + b] = tblData[b][val - tblOffsets[b]];
                }
            }
        } else {
            for (int b = 0; b < bOffset; ++b) {
                byte[] t = tblData[b];
                int tblOffset = tblOffsets[b];
                for (int i = b; i < srcData.length; i += bOffset) {
                    dstData[i] = t[srcData[i] - tblOffset];
                }
            }
        }
    }

    private void lookup(byte[] srcData, short[] dstData, int[] tblOffsets, short[][] tblData) {
        int bOffset = tblData.length;
        if (srcData.length < dstData.length) {
            for (int i = 0; i < srcData.length; ++i) {
                int val = srcData[i] & 0xFF;
                for (int b = 0; b < bOffset; ++b) {
                    dstData[i * bOffset + b] = tblData[b][val - tblOffsets[b]];
                }
            }
        } else {
            for (int b = 0; b < bOffset; ++b) {
                short[] t = tblData[b];
                int tblOffset = tblOffsets[b];
                for (int i = b; i < srcData.length; i += bOffset) {
                    dstData[i] = t[(srcData[i] & 0xFF) - tblOffset];
                }
            }
        }
    }

    private void lookupU(short[] srcData, short[] dstData, int[] tblOffsets, short[][] tblData) {
        int bOffset = tblData.length;
        if (srcData.length < dstData.length) {
            for (int i = 0; i < srcData.length; ++i) {
                int val = srcData[i] & 0xFFFF;
                for (int b = 0; b < bOffset; ++b) {
                    dstData[i * bOffset + b] = tblData[b][val - tblOffsets[b]];
                }
            }
        } else {
            for (int b = 0; b < bOffset; ++b) {
                short[] t = tblData[b];
                int tblOffset = tblOffsets[b];
                for (int i = b; i < srcData.length; i += bOffset) {
                    srcData[i] = t[(srcData[i] & 0xFFFF) - tblOffset];
                }
            }
        }
    }

    private void lookup(short[] srcData, short[] dstData, int[] tblOffsets, short[][] tblData) {
        int bOffset = tblData.length;
        if (srcData.length < dstData.length) {
            for (int i = 0; i < srcData.length; ++i) {
                short val = srcData[i];
                for (int b = 0; b < bOffset; ++b) {
                    dstData[i * bOffset + b] = tblData[b][val - tblOffsets[b]];
                }
            }
        } else {
            for (int b = 0; b < bOffset; ++b) {
                short[] t = tblData[b];
                int tblOffset = tblOffsets[b];
                for (int i = b; i < srcData.length; i += bOffset) {
                    srcData[i] = t[srcData[i] - tblOffset];
                }
            }
        }
    }
}

