/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.oauth.provider;

import com.alibaba.fastjson.JSONObject;
import org.aoju.bus.cache.metric.ExtendCache;
import org.aoju.bus.core.lang.Normal;
import org.aoju.bus.core.lang.exception.AuthorizedException;
import org.aoju.bus.http.Httpx;
import org.aoju.bus.oauth.Builder;
import org.aoju.bus.oauth.Context;
import org.aoju.bus.oauth.Registry;
import org.aoju.bus.oauth.magic.AccToken;
import org.aoju.bus.oauth.magic.Callback;
import org.aoju.bus.oauth.magic.Property;
import org.aoju.bus.oauth.provider.DefaultProvider;

public class StackOverflowProvider
extends DefaultProvider {
    public StackOverflowProvider(Context context) {
        super(context, Registry.STACKOVERFLOW);
    }

    public StackOverflowProvider(Context context, ExtendCache extendCache) {
        super(context, Registry.STACKOVERFLOW, extendCache);
    }

    @Override
    protected AccToken getAccessToken(Callback Callback2) {
        String accessTokenUrl = this.accessTokenUrl(Callback2.getCode());
        String response = Httpx.post(this.source.accessToken(), StackOverflowProvider.parseQueryToMap(accessTokenUrl));
        JSONObject object = JSONObject.parseObject((String)response);
        this.checkResponse(object);
        return AccToken.builder().accessToken(object.getString("access_token")).expireIn(object.getIntValue("expires")).build();
    }

    @Override
    protected Property getUserInfo(AccToken token) {
        String userInfoUrl = Builder.fromUrl(this.source.userInfo()).queryParam("access_token", token.getAccessToken()).queryParam("site", "stackoverflow").queryParam("key", this.context.getOverflowKey()).build();
        JSONObject object = JSONObject.parseObject((String)Httpx.get(userInfoUrl));
        this.checkResponse(object);
        JSONObject userObj = object.getJSONArray("items").getJSONObject(0);
        return Property.builder().uuid(userObj.getString("user_id")).avatar(userObj.getString("profile_image")).location(userObj.getString("location")).nickname(userObj.getString("display_name")).blog(userObj.getString("website_url")).gender(Normal.Gender.UNKNOWN).token(token).source(this.source.toString()).build();
    }

    @Override
    public String authorize(String state) {
        return Builder.fromUrl(this.source.authorize()).queryParam("response_type", "code").queryParam("client_id", this.context.getAppKey()).queryParam("redirect_uri", this.context.getRedirectUri()).queryParam("scope", "read_inbox").queryParam("state", this.getRealState(state)).build();
    }

    private void checkResponse(JSONObject object) {
        if (object.containsKey((Object)"error")) {
            throw new AuthorizedException(object.getString("error_description"));
        }
    }
}

