/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.office.bridge;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.aoju.bus.core.lang.Assert;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.toolkit.ClassKit;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.office.bridge.OnlineOfficeBridgeFactory;
import org.aoju.bus.office.bridge.OnlineOfficeEntryBuilder;
import org.aoju.bus.office.builtin.MadeInOffice;
import org.aoju.bus.office.metric.AbstractOfficeEntryManager;
import org.aoju.bus.office.metric.RequestBuilder;

public class OnlineOfficeEntryManager
extends AbstractOfficeEntryManager {
    private final String connectionUrl;

    public OnlineOfficeEntryManager(String connectionUrl, OnlineOfficeEntryBuilder config) {
        super(config);
        this.connectionUrl = connectionUrl;
    }

    private static File getFile(URL url) {
        try {
            return new File(new URI(StringKit.replace(url.toString(), " ", "%20")).getSchemeSpecificPart());
        }
        catch (URISyntaxException ex) {
            return new File(url.getFile());
        }
    }

    private static File getFile(String resourceLocation) throws FileNotFoundException {
        Assert.notNull(resourceLocation, "Resource location must not be null", new Object[0]);
        if (resourceLocation.startsWith("classpath:")) {
            URL url;
            String path = resourceLocation.substring("classpath:".length());
            String description = "class path resource [" + path + "]";
            ClassLoader cl = ClassKit.getDefaultClassLoader();
            URL uRL = url = cl != null ? cl.getResource(path) : ClassLoader.getSystemResource(path);
            if (url == null) {
                throw new FileNotFoundException(description + " cannot be resolved to absolute file path because it does not exist");
            }
            return OnlineOfficeEntryManager.getFile(url.toString());
        }
        try {
            return OnlineOfficeEntryManager.getFile(new URL(resourceLocation));
        }
        catch (MalformedURLException ex) {
            return new File(resourceLocation);
        }
    }

    private String buildUrl(String connectionUrl) throws MalformedURLException {
        URL url = new URL(connectionUrl);
        String path = url.toExternalForm().toLowerCase();
        if (StringKit.endsWithAny(path, "lool/convert-to", "lool/convert-to/")) {
            return StringKit.appendIfMissing(connectionUrl, (CharSequence)"/", new CharSequence[0]);
        }
        if (StringKit.endsWithAny(path, "lool", "lool/")) {
            return StringKit.appendIfMissing(connectionUrl, (CharSequence)"/", new CharSequence[0]) + "convert-to/";
        }
        return StringKit.appendIfMissing(connectionUrl, (CharSequence)"/", new CharSequence[0]) + "lool/convert-to/";
    }

    @Override
    protected void doExecute(MadeInOffice task) throws InstrumentException {
        try {
            RequestBuilder requestBuilder = new RequestBuilder(this.buildUrl(this.connectionUrl), Math.toIntExact(this.config.getTaskExecutionTimeout()), Math.toIntExact(this.config.getTaskExecutionTimeout()));
            task.execute(new OnlineOfficeBridgeFactory(requestBuilder));
        }
        catch (IOException ex) {
            throw new InstrumentException("Unable to create the HTTP client", ex);
        }
    }

    @Override
    protected void doStart() throws InstrumentException {
        this.taskExecutor.setAvailable(true);
    }

    @Override
    protected void doStop() throws InstrumentException {
    }
}

