/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.office.support.word;

import java.util.LinkedHashMap;
import java.util.Map;
import org.aoju.bus.core.convert.Convert;
import org.aoju.bus.core.lang.Assert;
import org.aoju.bus.core.toolkit.BeanKit;
import org.aoju.bus.core.toolkit.CollKit;
import org.aoju.bus.core.toolkit.IterKit;
import org.aoju.bus.core.toolkit.MapKit;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;
import org.apache.poi.xwpf.usermodel.XWPFTableRow;

public class TableKit {
    public static XWPFTable createTable(XWPFDocument doc) {
        return TableKit.createTable(doc, null);
    }

    public static XWPFTable createTable(XWPFDocument doc, Iterable<?> data) {
        Assert.notNull(doc, "XWPFDocument must be not null !", new Object[0]);
        XWPFTable table = doc.createTable();
        if (IterKit.isEmpty(data)) {
            return table;
        }
        int index = 0;
        for (Object rowData : data) {
            TableKit.writeRow(TableKit.getOrCreateRow(table, index), rowData, true);
            ++index;
        }
        return table;
    }

    public static void writeRow(XWPFTableRow row, Object rowBean, boolean isWriteKeyAsHead) {
        if (rowBean instanceof Iterable) {
            TableKit.writeRow(row, (Iterable)rowBean);
        }
        Map<String, Object> rowMap = null;
        if (rowBean instanceof Map) {
            rowMap = (Map<String, Object>)rowBean;
        } else if (BeanKit.isBean(rowBean.getClass())) {
            rowMap = BeanKit.beanToMap(rowBean, new LinkedHashMap<String, Object>(), false, false);
        } else {
            TableKit.writeRow(row, CollKit.newArrayList(rowBean), isWriteKeyAsHead);
        }
        TableKit.writeRow(row, rowMap, isWriteKeyAsHead);
    }

    public static void writeRow(XWPFTableRow row, Map<?, ?> rowMap, boolean isWriteKeyAsHead) {
        if (MapKit.isEmpty(rowMap)) {
            return;
        }
        if (isWriteKeyAsHead) {
            TableKit.writeRow(row, rowMap.keySet());
        }
        TableKit.writeRow(row, rowMap.values());
    }

    public static void writeRow(XWPFTableRow row, Iterable<?> rowData) {
        int index = 0;
        for (Object cellData : rowData) {
            XWPFTableCell cell = TableKit.getOrCreateCell(row, index);
            cell.setText(Convert.toString(cellData));
            ++index;
        }
    }

    public static XWPFTableRow getOrCreateRow(XWPFTable table, int index) {
        XWPFTableRow row = table.getRow(index);
        if (null == row) {
            row = table.createRow();
        }
        return row;
    }

    public static XWPFTableCell getOrCreateCell(XWPFTableRow row, int index) {
        XWPFTableCell cell = row.getCell(index);
        if (null == cell) {
            cell = row.createCell();
        }
        return cell;
    }
}

