/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.socket.origin.plugins;

import java.nio.channels.AsynchronousSocketChannel;
import java.util.ArrayList;
import java.util.List;
import org.aoju.bus.socket.origin.AioSession;
import org.aoju.bus.socket.origin.Message;
import org.aoju.bus.socket.origin.NetMonitor;
import org.aoju.bus.socket.origin.StateMachine;
import org.aoju.bus.socket.origin.plugins.Plugin;

public abstract class AbstractMessage<T>
implements Message<T>,
NetMonitor<T> {
    private List<Plugin<T>> plugins = new ArrayList<Plugin<T>>();

    @Override
    public final void readMonitor(AioSession<T> session, int readSize) {
        for (Plugin<T> plugin : this.plugins) {
            plugin.readMonitor(session, readSize);
        }
    }

    @Override
    public final void writeMonitor(AioSession<T> session, int writeSize) {
        for (Plugin<T> plugin : this.plugins) {
            plugin.writeMonitor(session, writeSize);
        }
    }

    @Override
    public final boolean acceptMonitor(AsynchronousSocketChannel channel) {
        for (Plugin<T> plugin : this.plugins) {
            boolean accept = plugin.acceptMonitor(channel);
            if (accept) continue;
            return accept;
        }
        return true;
    }

    @Override
    public final void process(AioSession<T> session, T msg) {
        boolean flag = true;
        for (Plugin<T> plugin : this.plugins) {
            if (plugin.preProcess(session, msg)) continue;
            flag = false;
        }
        if (flag) {
            this.process0(session, msg);
        }
    }

    public abstract void process0(AioSession<T> var1, T var2);

    @Override
    public final void stateEvent(AioSession<T> session, StateMachine stateMachineEnum, Throwable throwable) {
        for (Plugin<T> plugin : this.plugins) {
            plugin.stateEvent(stateMachineEnum, session, throwable);
        }
        this.stateEvent0(session, stateMachineEnum, throwable);
    }

    public abstract void stateEvent0(AioSession<T> var1, StateMachine var2, Throwable var3);

    public final void addPlugin(Plugin plugin) {
        this.plugins.add(plugin);
    }
}

