/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.socket.spring.intercept;

import java.util.List;
import org.aoju.bus.core.toolkit.ObjectKit;
import org.aoju.bus.socket.spring.intercept.ToClientInterceptor;
import org.springframework.messaging.simp.stomp.StompHeaderAccessor;
import org.springframework.util.Assert;
import org.springframework.web.socket.WebSocketSession;
import org.springframework.web.socket.messaging.StompSubProtocolHandler;

public class ToClientExecutionChain {
    private List<ToClientInterceptor> interceptors;
    private int interceptorIndex = -1;

    public ToClientExecutionChain(List<ToClientInterceptor> interceptors) {
        Assert.notNull(interceptors, (String)"interceptors\u4e0d\u80fd\u4e3anull");
        this.interceptors = interceptors;
    }

    public boolean applyPreHandle(WebSocketSession session, StompHeaderAccessor accessor, Object payload, StompSubProtocolHandler handler) {
        if (!ObjectKit.isEmpty(this.interceptors)) {
            int i = 0;
            while (i < this.interceptors.size()) {
                ToClientInterceptor interceptor = this.interceptors.get(i);
                if (!interceptor.preHandle(session, accessor, payload, handler)) {
                    this.applyPostHandle(session, accessor, payload, handler);
                    return false;
                }
                this.interceptorIndex = i++;
            }
        }
        return true;
    }

    public void applyPostHandle(WebSocketSession session, StompHeaderAccessor accessor, Object payload, StompSubProtocolHandler handler) {
        if (!ObjectKit.isEmpty(this.interceptors)) {
            for (int i = this.interceptorIndex; i >= 0; --i) {
                ToClientInterceptor interceptor = this.interceptors.get(i);
                interceptor.postHandle(session, accessor, payload, handler);
            }
        }
    }
}

