/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.starter.goalie;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.starter.goalie.RequestConditions;
import org.aoju.bus.starter.goalie.annotation.ApiVersion;
import org.aoju.bus.starter.goalie.annotation.ClientVersion;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.web.servlet.mvc.condition.RequestCondition;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

public class RequestHandlerMapping
extends RequestMappingHandlerMapping {
    protected RequestMappingInfo getMappingForMethod(Method method, Class<?> handlerType) {
        RequestMappingInfo mappinginfo = super.getMappingForMethod(method, handlerType);
        if (mappinginfo != null) {
            RequestMappingInfo apiVersionMappingInfo = this.getApiVersionMappingInfo(method, handlerType);
            return apiVersionMappingInfo == null ? mappinginfo : apiVersionMappingInfo.combine(mappinginfo);
        }
        return mappinginfo;
    }

    protected RequestCondition getCustomTypeCondition(Class<?> handlerType) {
        ClientVersion clientVersion = (ClientVersion)AnnotatedElementUtils.findMergedAnnotation(handlerType, ClientVersion.class);
        return this.createRequestCondtion(clientVersion);
    }

    protected RequestCondition getCustomMethodCondition(Method method) {
        ClientVersion clientVersion = (ClientVersion)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, ClientVersion.class);
        return this.createRequestCondtion(clientVersion);
    }

    private RequestCondition createRequestCondtion(ClientVersion clientVersion) {
        if (clientVersion == null) {
            return null;
        }
        if (clientVersion.value() != null && clientVersion.value().length > 0) {
            return new RequestConditions(clientVersion.value());
        }
        if (clientVersion.expression() != null && clientVersion.expression().length > 0) {
            return new RequestConditions(clientVersion.expression());
        }
        return null;
    }

    private RequestMappingInfo getApiVersionMappingInfo(Method method, Class<?> handlerType) {
        ApiVersion apiVersion = (ApiVersion)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, ApiVersion.class);
        if (apiVersion == null || StringKit.isBlank(apiVersion.value())) {
            apiVersion = (ApiVersion)AnnotatedElementUtils.findMergedAnnotation(handlerType, ApiVersion.class);
        }
        return apiVersion == null || StringKit.isBlank(apiVersion.value()) ? null : RequestMappingInfo.paths((String[])new String[]{apiVersion.value()}).build();
    }
}

