/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.text.csv;

import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.Flushable;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import org.aoju.bus.core.lang.Charset;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.text.csv.CsvWriteConfig;
import org.aoju.bus.core.toolkit.ArrayKit;
import org.aoju.bus.core.toolkit.CollKit;
import org.aoju.bus.core.toolkit.FileKit;
import org.aoju.bus.core.toolkit.IoKit;
import org.aoju.bus.core.toolkit.ObjectKit;

public final class CsvWriter
implements Closeable,
Flushable {
    private final Writer writer;
    private final CsvWriteConfig config;
    private boolean newline = true;

    public CsvWriter(String filePath) {
        this(FileKit.file(filePath));
    }

    public CsvWriter(File file) {
        this(file, Charset.UTF_8);
    }

    public CsvWriter(String filePath, java.nio.charset.Charset charset) {
        this(FileKit.file(filePath), charset);
    }

    public CsvWriter(File file, java.nio.charset.Charset charset) {
        this(file, charset, false);
    }

    public CsvWriter(String filePath, java.nio.charset.Charset charset, boolean isAppend) {
        this(FileKit.file(filePath), charset, isAppend);
    }

    public CsvWriter(File file, java.nio.charset.Charset charset, boolean isAppend) {
        this(file, charset, isAppend, null);
    }

    public CsvWriter(String filePath, java.nio.charset.Charset charset, boolean isAppend, CsvWriteConfig config) {
        this(FileKit.file(filePath), charset, isAppend, config);
    }

    public CsvWriter(File file, java.nio.charset.Charset charset, boolean isAppend, CsvWriteConfig config) {
        this(FileKit.getWriter(file, charset, isAppend), config);
    }

    public CsvWriter(Writer writer) {
        this(writer, null);
    }

    public CsvWriter(Writer writer, CsvWriteConfig config) {
        this.writer = writer instanceof BufferedWriter ? writer : new BufferedWriter(writer);
        this.config = ObjectKit.defaultIfNull(config, CsvWriteConfig.defaultConfig());
    }

    public void setAlwaysDelimitText(boolean alwaysDelimitText) {
        this.setAlwaysDelimitText(alwaysDelimitText);
    }

    public void setLineDelimiter(char[] lineDelimiter) {
        this.setLineDelimiter(lineDelimiter);
    }

    public CsvWriter write(String[] ... lines) throws InstrumentException {
        if (ArrayKit.isNotEmpty(lines)) {
            for (String[] values : lines) {
                this.appendLine(values);
            }
            this.flush();
        }
        return this;
    }

    public CsvWriter write(Collection<String[]> lines) throws InstrumentException {
        if (CollKit.isNotEmpty(lines)) {
            for (String[] values : lines) {
                this.appendLine(values);
            }
            this.flush();
        }
        return this;
    }

    public void writeLine() throws InstrumentException {
        try {
            this.writer.write(this.config.lineDelimiter);
        }
        catch (IOException e) {
            throw new InstrumentException(e);
        }
        this.newline = true;
    }

    @Override
    public void close() {
        IoKit.close(this.writer);
    }

    @Override
    public void flush() throws InstrumentException {
        try {
            this.writer.flush();
        }
        catch (IOException e) {
            throw new InstrumentException(e);
        }
    }

    private void appendLine(String ... fields) throws InstrumentException {
        try {
            this.doAppendLine(fields);
        }
        catch (IOException e) {
            throw new InstrumentException(e);
        }
    }

    private void doAppendLine(String ... fields) throws IOException {
        if (null != fields) {
            for (int i = 0; i < fields.length; ++i) {
                this.appendField(fields[i]);
            }
            this.writer.write(this.config.lineDelimiter);
            this.newline = true;
        }
    }

    private void appendField(String value) throws IOException {
        boolean alwaysDelimitText = this.config.alwaysDelimitText;
        char textDelimiter = this.config.textDelimiter;
        char fieldSeparator = this.config.fieldSeparator;
        if (!this.newline) {
            this.writer.write(fieldSeparator);
        } else {
            this.newline = false;
        }
        if (null == value) {
            if (alwaysDelimitText) {
                this.writer.write(new char[]{textDelimiter, textDelimiter});
            }
            return;
        }
        char[] valueChars = value.toCharArray();
        boolean needsTextDelimiter = alwaysDelimitText;
        boolean containsTextDelimiter = false;
        for (char c : valueChars) {
            if (c == textDelimiter) {
                needsTextDelimiter = true;
                containsTextDelimiter = true;
                break;
            }
            if (c != fieldSeparator && c != '\n' && c != '\r') continue;
            needsTextDelimiter = true;
        }
        if (needsTextDelimiter) {
            this.writer.write(textDelimiter);
        }
        if (containsTextDelimiter) {
            for (char c : valueChars) {
                if (c == textDelimiter) {
                    this.writer.write(textDelimiter);
                }
                this.writer.write(c);
            }
        } else {
            this.writer.write(valueChars);
        }
        if (needsTextDelimiter) {
            this.writer.write(textDelimiter);
        }
    }
}

