/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.forest.boot;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.Set;
import org.aoju.bus.forest.algorithm.Key;
import org.aoju.bus.forest.boot.BootURLConnection;
import org.aoju.bus.forest.provider.DecryptorProvider;
import org.aoju.bus.forest.provider.EncryptorProvider;
import org.springframework.boot.loader.jar.Handler;

public class BootURLHandler
extends Handler {
    private final DecryptorProvider decryptorProvider;
    private final EncryptorProvider encryptorProvider;
    private final Key key;
    private final Set<String> indexes;

    public BootURLHandler(DecryptorProvider decryptorProvider, EncryptorProvider encryptorProvider, Key key, ClassLoader classLoader) throws Exception {
        this.decryptorProvider = decryptorProvider;
        this.encryptorProvider = encryptorProvider;
        this.key = key;
        this.indexes = new LinkedHashSet<String>();
        Enumeration<URL> resources = classLoader.getResources("META-INF/FOREST.MF");
        while (resources.hasMoreElements()) {
            String name;
            URL resource = resources.nextElement();
            String url = resource.toString();
            String classpath = url.substring(0, url.lastIndexOf("!/") + 2);
            InputStream in = resource.openStream();
            InputStreamReader isr = new InputStreamReader(in);
            LineNumberReader lnr = new LineNumberReader(isr);
            while ((name = lnr.readLine()) != null) {
                this.indexes.add(classpath + name);
            }
        }
    }

    protected URLConnection openConnection(URL url) throws IOException {
        URLConnection urlConnection = super.openConnection(url);
        return this.indexes.contains(url.toString()) && urlConnection instanceof JarURLConnection ? new BootURLConnection((JarURLConnection)urlConnection, this.decryptorProvider, this.encryptorProvider, this.key) : urlConnection;
    }
}

