/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.health.linux.hardware;

import java.util.List;
import java.util.function.Supplier;
import org.aoju.bus.core.annotation.Immutable;
import org.aoju.bus.core.lang.RegEx;
import org.aoju.bus.core.toolkit.FileKit;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.health.Builder;
import org.aoju.bus.health.Memoize;
import org.aoju.bus.health.builtin.hardware.AbstractBaseboard;
import org.aoju.bus.health.linux.ProcPath;

@Immutable
final class LinuxBaseboard
extends AbstractBaseboard {
    private final Supplier<String> manufacturer = Memoize.memoize(LinuxBaseboard::queryManufacturer);
    private final Supplier<String> model = Memoize.memoize(LinuxBaseboard::queryModel);
    private final Supplier<String> version = Memoize.memoize(LinuxBaseboard::queryVersion);
    private final Supplier<String> serialNumber = Memoize.memoize(LinuxBaseboard::querySerialNumber);

    LinuxBaseboard() {
    }

    private static String queryManufacturer() {
        String result = LinuxBaseboard.queryManufacturerFromSysfs();
        if (result == null && (result = LinuxBaseboard.queryProcCpu().manufacturer) == null) {
            return "unknown";
        }
        return result;
    }

    private static String queryModel() {
        String result = LinuxBaseboard.queryModelFromSysfs();
        if (result == null && (result = LinuxBaseboard.queryProcCpu().model) == null) {
            return "unknown";
        }
        return result;
    }

    private static String queryVersion() {
        String result = LinuxBaseboard.queryVersionFromSysfs();
        if (result == null && (result = LinuxBaseboard.queryProcCpu().version) == null) {
            return "unknown";
        }
        return result;
    }

    private static String querySerialNumber() {
        String result = LinuxBaseboard.querySerialFromSysfs();
        if (result == null && (result = LinuxBaseboard.queryProcCpu().serialNumber) == null) {
            return "unknown";
        }
        return result;
    }

    private static String queryManufacturerFromSysfs() {
        String boardVendor = Builder.getStringFromFile("/sys/devices/virtual/dmi/id/board_vendor").trim();
        if (!boardVendor.isEmpty()) {
            return boardVendor;
        }
        return null;
    }

    private static String queryModelFromSysfs() {
        String boardName = Builder.getStringFromFile("/sys/devices/virtual/dmi/id/board_name").trim();
        if (!boardName.isEmpty()) {
            return boardName;
        }
        return null;
    }

    private static String queryVersionFromSysfs() {
        String boardVersion = Builder.getStringFromFile("/sys/devices/virtual/dmi/id/board_version").trim();
        if (!boardVersion.isEmpty()) {
            return boardVersion;
        }
        return null;
    }

    private static String querySerialFromSysfs() {
        String boardSerial = Builder.getStringFromFile("/sys/devices/virtual/dmi/id/board_serial").trim();
        if (!boardSerial.isEmpty()) {
            return boardSerial;
        }
        return null;
    }

    private static ProcCpuStrings queryProcCpu() {
        String pcManufacturer = null;
        String pcModel = null;
        String pcVersion = null;
        String pcSerialNumber = null;
        List<String> cpuInfo = FileKit.readLines(ProcPath.CPUINFO);
        for (String line : cpuInfo) {
            String[] splitLine = RegEx.SPACES_COLON_SPACE.split(line);
            if (splitLine.length < 2) continue;
            switch (splitLine[0]) {
                case "Hardware": {
                    pcModel = splitLine[1];
                    break;
                }
                case "Revision": {
                    pcVersion = splitLine[1];
                    if (pcVersion.length() <= 1) break;
                    pcManufacturer = LinuxBaseboard.queryBoardManufacturer(pcVersion.charAt(1));
                    break;
                }
                case "Serial": {
                    pcSerialNumber = splitLine[1];
                    break;
                }
            }
        }
        return new ProcCpuStrings(pcManufacturer, pcModel, pcVersion, pcSerialNumber);
    }

    private static String queryBoardManufacturer(char digit) {
        switch (digit) {
            case '0': {
                return "Sony UK";
            }
            case '1': {
                return "Egoman";
            }
            case '2': {
                return "Embest";
            }
            case '3': {
                return "Sony Japan";
            }
            case '4': {
                return "Embest";
            }
            case '5': {
                return "Stadium";
            }
        }
        return "unknown";
    }

    @Override
    public String getManufacturer() {
        return this.manufacturer.get();
    }

    @Override
    public String getModel() {
        return this.model.get();
    }

    @Override
    public String getVersion() {
        return this.version.get();
    }

    @Override
    public String getSerialNumber() {
        return this.serialNumber.get();
    }

    private static final class ProcCpuStrings {
        private final String manufacturer;
        private final String model;
        private final String version;
        private final String serialNumber;

        private ProcCpuStrings(String manufacturer, String model, String version, String serialNumber) {
            this.manufacturer = StringKit.isBlank(manufacturer) ? "unknown" : manufacturer;
            this.model = StringKit.isBlank(model) ? "unknown" : model;
            this.version = StringKit.isBlank(version) ? "unknown" : version;
            this.serialNumber = StringKit.isBlank(serialNumber) ? "unknown" : serialNumber;
        }
    }
}

