/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.health.linux.hardware;

import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.List;
import java.util.Locale;
import java.util.function.Supplier;
import org.aoju.bus.core.annotation.Immutable;
import org.aoju.bus.core.lang.RegEx;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.health.Builder;
import org.aoju.bus.health.Executor;
import org.aoju.bus.health.Memoize;
import org.aoju.bus.health.builtin.hardware.AbstractFirmware;

@Immutable
final class LinuxFirmware
extends AbstractFirmware {
    private static final DateTimeFormatter VCGEN_FORMATTER = DateTimeFormatter.ofPattern("MMM d uuuu HH:mm:ss", Locale.ENGLISH);
    private final Supplier<VcGenCmdStrings> vcGenCmd = Memoize.memoize(this::queryVcGenCmd);
    private final Supplier<String> manufacturer = Memoize.memoize(this::queryManufacturer);
    private final Supplier<String> description = Memoize.memoize(this::queryDescription);
    private final Supplier<String> releaseDate = Memoize.memoize(this::queryReleaseDate);
    private final Supplier<BiosStrings> bios = Memoize.memoize(this::queryBios);
    private final Supplier<String> version = Memoize.memoize(this::queryVersion);
    private final Supplier<String> name = Memoize.memoize(this::queryName);

    LinuxFirmware() {
    }

    private static String queryManufacturerFromSysfs() {
        String biosVendor = Builder.getStringFromFile("/sys/devices/virtual/dmi/id/bios_vendor").trim();
        if (biosVendor.isEmpty()) {
            return biosVendor;
        }
        return null;
    }

    private static String queryDescriptionFromSysfs() {
        String modalias = Builder.getStringFromFile("/sys/devices/virtual/dmi/id/modalias").trim();
        if (!modalias.isEmpty()) {
            return modalias;
        }
        return null;
    }

    private static String queryReleaseDateFromSysfs() {
        String biosDate = Builder.getStringFromFile("/sys/devices/virtual/dmi/id/bios_date").trim();
        if (!biosDate.isEmpty()) {
            return Builder.parseMmDdYyyyToYyyyMmDD(biosDate);
        }
        return null;
    }

    @Override
    public String getManufacturer() {
        return this.manufacturer.get();
    }

    @Override
    public String getDescription() {
        return this.description.get();
    }

    @Override
    public String getVersion() {
        return this.version.get();
    }

    @Override
    public String getReleaseDate() {
        return this.releaseDate.get();
    }

    @Override
    public String getName() {
        return this.name.get();
    }

    private String queryManufacturer() {
        String result = null;
        result = LinuxFirmware.queryManufacturerFromSysfs();
        if (result == null && (result = this.vcGenCmd.get().manufacturer) == null) {
            return "unknown";
        }
        return result;
    }

    private String queryDescription() {
        String result = null;
        result = LinuxFirmware.queryDescriptionFromSysfs();
        if (result == null && (result = this.vcGenCmd.get().description) == null) {
            return "unknown";
        }
        return result;
    }

    private String queryVersion() {
        String result = null;
        result = this.queryVersionFromSysfs();
        if (result == null && (result = this.vcGenCmd.get().version) == null) {
            return "unknown";
        }
        return result;
    }

    private String queryReleaseDate() {
        String result = null;
        result = LinuxFirmware.queryReleaseDateFromSysfs();
        if (result == null && (result = this.vcGenCmd.get().releaseDate) == null) {
            return "unknown";
        }
        return result;
    }

    private String queryName() {
        String result = null;
        result = this.bios.get().biosName;
        if (result == null && (result = this.vcGenCmd.get().name) == null) {
            return "unknown";
        }
        return result;
    }

    private String queryVersionFromSysfs() {
        String biosVersion = Builder.getStringFromFile("/sys/devices/virtual/dmi/id/bios_version").trim();
        if (!biosVersion.isEmpty()) {
            String biosRevision = this.bios.get().biosRevision;
            return biosVersion + (StringKit.isBlank(biosRevision) ? "" : " (revision " + biosRevision + ")");
        }
        return null;
    }

    private BiosStrings queryBios() {
        String biosName = null;
        String revision = null;
        String biosMarker = "SMBIOS";
        String revMarker = "Bios Revision:";
        for (String checkLine : Executor.runNative("dmidecode -t bios")) {
            String[] biosArr;
            if (checkLine.contains("SMBIOS") && (biosArr = RegEx.SPACES.split(checkLine)).length >= 2) {
                biosName = biosArr[0] + " " + biosArr[1];
            }
            if (!checkLine.contains("Bios Revision:")) continue;
            revision = checkLine.split("Bios Revision:")[1].trim();
            break;
        }
        return new BiosStrings(biosName, revision);
    }

    private VcGenCmdStrings queryVcGenCmd() {
        String vcReleaseDate = null;
        String vcManufacturer = null;
        String vcVersion = null;
        List<String> vcgencmd = Executor.runNative("vcgencmd version");
        if (vcgencmd.size() >= 3) {
            try {
                vcReleaseDate = DateTimeFormatter.ISO_LOCAL_DATE.format(VCGEN_FORMATTER.parse(vcgencmd.get(0)));
            }
            catch (DateTimeParseException e) {
                vcReleaseDate = "unknown";
            }
            String[] copyright = RegEx.SPACES.split(vcgencmd.get(1));
            vcManufacturer = copyright[copyright.length - 1];
            vcVersion = vcgencmd.get(2).replace("version ", "");
            return new VcGenCmdStrings(vcReleaseDate, vcManufacturer, vcVersion, "RPi", "Bootloader");
        }
        return new VcGenCmdStrings(null, null, null, null, null);
    }

    private static final class VcGenCmdStrings {
        private final String releaseDate;
        private final String manufacturer;
        private final String version;
        private final String name;
        private final String description;

        private VcGenCmdStrings(String releaseDate, String manufacturer, String version, String name, String description) {
            this.releaseDate = releaseDate;
            this.manufacturer = manufacturer;
            this.version = version;
            this.name = name;
            this.description = description;
        }
    }

    private static final class BiosStrings {
        private final String biosName;
        private final String biosRevision;

        private BiosStrings(String biosName, String biosRevision) {
            this.biosName = biosName;
            this.biosRevision = biosRevision;
        }
    }
}

