/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.health.linux.hardware;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.aoju.bus.core.annotation.Immutable;
import org.aoju.bus.health.Builder;
import org.aoju.bus.health.builtin.hardware.AbstractSoundCard;
import org.aoju.bus.health.linux.ProcPath;
import org.aoju.bus.logger.Logger;

@Immutable
final class LinuxSoundCard
extends AbstractSoundCard {
    private static final String CARD_FOLDER = "card";
    private static final String CARDS_FILE = "cards";
    private static final String ID_FILE = "id";

    LinuxSoundCard(String kernelVersion, String name, String codec) {
        super(kernelVersion, name, codec);
    }

    private static List<File> getCardFolders() {
        File cardsDirectory = new File(ProcPath.ASOUND);
        ArrayList<File> cardFolders = new ArrayList<File>();
        File[] allContents = cardsDirectory.listFiles();
        if (allContents != null) {
            for (File card : allContents) {
                if (!card.getName().startsWith(CARD_FOLDER) || !card.isDirectory()) continue;
                cardFolders.add(card);
            }
        } else {
            Logger.warn("No Audio Cards Found", new Object[0]);
        }
        return cardFolders;
    }

    private static String getSoundCardVersion() {
        String driverVersion = Builder.getStringFromFile(ProcPath.ASOUND + "version");
        return driverVersion.isEmpty() ? "not available" : driverVersion;
    }

    private static String getCardCodec(File cardDir) {
        String cardCodec = "";
        File[] cardFiles = cardDir.listFiles();
        if (cardFiles != null) {
            block0: for (File file : cardFiles) {
                if (!file.getName().startsWith("codec")) continue;
                if (!file.isDirectory()) {
                    cardCodec = Builder.getKeyValueMapFromFile(file.getPath(), ":").get("Codec");
                    continue;
                }
                File[] codecs = file.listFiles();
                if (codecs == null) continue;
                for (File codec : codecs) {
                    if (codec.isDirectory() || !codec.getName().contains("#")) continue;
                    cardCodec = codec.getName().substring(0, codec.getName().indexOf(35));
                    continue block0;
                }
            }
        }
        return cardCodec;
    }

    private static String getCardName(File file) {
        String cardName = "Not Found..";
        Map<String, String> cardNamePairs = Builder.getKeyValueMapFromFile(ProcPath.ASOUND + "/" + CARDS_FILE, ":");
        String cardId = Builder.getStringFromFile(file.getPath() + "/" + ID_FILE);
        for (Map.Entry<String, String> entry : cardNamePairs.entrySet()) {
            if (!entry.getKey().contains(cardId)) continue;
            cardName = entry.getValue();
            return cardName;
        }
        return cardName;
    }

    public static List<LinuxSoundCard> getSoundCards() {
        ArrayList<LinuxSoundCard> soundCards = new ArrayList<LinuxSoundCard>();
        for (File cardFile : LinuxSoundCard.getCardFolders()) {
            soundCards.add(new LinuxSoundCard(LinuxSoundCard.getSoundCardVersion(), LinuxSoundCard.getCardName(cardFile), LinuxSoundCard.getCardCodec(cardFile)));
        }
        return soundCards;
    }
}

