/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.health.linux.hardware;

import java.util.List;
import java.util.function.Supplier;
import org.aoju.bus.core.annotation.ThreadSafe;
import org.aoju.bus.core.lang.RegEx;
import org.aoju.bus.core.lang.tuple.Pair;
import org.aoju.bus.core.lang.tuple.Triple;
import org.aoju.bus.core.toolkit.FileKit;
import org.aoju.bus.health.Builder;
import org.aoju.bus.health.Memoize;
import org.aoju.bus.health.builtin.hardware.AbstractVirtualMemory;
import org.aoju.bus.health.linux.ProcPath;
import org.aoju.bus.health.linux.hardware.LinuxGlobalMemory;

@ThreadSafe
final class LinuxVirtualMemory
extends AbstractVirtualMemory {
    private final LinuxGlobalMemory global;
    private final Supplier<Triple<Long, Long, Long>> usedTotalCommitLim = Memoize.memoize(LinuxVirtualMemory::queryMemInfo, Memoize.defaultExpiration());
    private final Supplier<Pair<Long, Long>> inOut = Memoize.memoize(LinuxVirtualMemory::queryVmStat, Memoize.defaultExpiration());

    LinuxVirtualMemory(LinuxGlobalMemory linuxGlobalMemory) {
        this.global = linuxGlobalMemory;
    }

    private static Triple<Long, Long, Long> queryMemInfo() {
        long swapFree = 0L;
        long swapTotal = 0L;
        long commitLimit = 0L;
        List<String> procMemInfo = FileKit.readLines(ProcPath.MEMINFO);
        for (String checkLine : procMemInfo) {
            String[] memorySplit = RegEx.SPACES.split(checkLine);
            if (memorySplit.length <= 1) continue;
            switch (memorySplit[0]) {
                case "SwapTotal:": {
                    swapTotal = LinuxVirtualMemory.parseMeminfo(memorySplit);
                    break;
                }
                case "SwapFree:": {
                    swapFree = LinuxVirtualMemory.parseMeminfo(memorySplit);
                    break;
                }
                case "CommitLimit:": {
                    commitLimit = LinuxVirtualMemory.parseMeminfo(memorySplit);
                    break;
                }
            }
        }
        return Triple.of(swapTotal - swapFree, swapTotal, commitLimit);
    }

    private static Pair<Long, Long> queryVmStat() {
        long swapPagesIn = 0L;
        long swapPagesOut = 0L;
        List<String> procVmStat = FileKit.readLines(ProcPath.VMSTAT);
        for (String checkLine : procVmStat) {
            String[] memorySplit = RegEx.SPACES.split(checkLine);
            if (memorySplit.length <= 1) continue;
            switch (memorySplit[0]) {
                case "pgpgin": {
                    swapPagesIn = Builder.parseLongOrDefault(memorySplit[1], 0L);
                    break;
                }
                case "pgpgout": {
                    swapPagesOut = Builder.parseLongOrDefault(memorySplit[1], 0L);
                    break;
                }
            }
        }
        return Pair.of(swapPagesIn, swapPagesOut);
    }

    private static long parseMeminfo(String[] memorySplit) {
        if (memorySplit.length < 2) {
            return 0L;
        }
        long memory = Builder.parseLongOrDefault(memorySplit[1], 0L);
        if (memorySplit.length > 2 && "kB".equals(memorySplit[2])) {
            memory *= 1024L;
        }
        return memory;
    }

    @Override
    public long getSwapUsed() {
        return this.usedTotalCommitLim.get().getLeft();
    }

    @Override
    public long getSwapTotal() {
        return this.usedTotalCommitLim.get().getMiddle();
    }

    @Override
    public long getVirtualMax() {
        return this.usedTotalCommitLim.get().getRight();
    }

    @Override
    public long getVirtualInUse() {
        return this.global.getTotal() - this.global.getAvailable() + this.getSwapUsed();
    }

    @Override
    public long getSwapPagesIn() {
        return this.inOut.get().getLeft();
    }

    @Override
    public long getSwapPagesOut() {
        return this.inOut.get().getRight();
    }
}

