/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.health.linux.software;

import com.sun.jna.Native;
import com.sun.jna.platform.linux.LibC;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.aoju.bus.core.annotation.ThreadSafe;
import org.aoju.bus.core.toolkit.FileKit;
import org.aoju.bus.health.Builder;
import org.aoju.bus.health.builtin.software.AbstractFileSystem;
import org.aoju.bus.health.builtin.software.OSFileStore;
import org.aoju.bus.health.linux.ProcPath;
import org.aoju.bus.logger.Logger;

@ThreadSafe
public class LinuxFileSystem
extends AbstractFileSystem {
    private static final String UNICODE_SPACE = "\\\\040";
    private static final List<String> TMP_FS_PATHS = Arrays.asList("/run", "/sys", "/proc", ProcPath.PROC);

    private static List<OSFileStore> getFileStoreMatching(String nameToMatch, Map<String, String> uuidMap) {
        return LinuxFileSystem.getFileStoreMatching(nameToMatch, uuidMap, false);
    }

    private static List<OSFileStore> getFileStoreMatching(String nameToMatch, Map<String, String> uuidMap, boolean localOnly) {
        ArrayList<OSFileStore> fsList = new ArrayList<OSFileStore>();
        List<String> mounts = FileKit.readLines(ProcPath.MOUNTS);
        for (String mount : mounts) {
            String uuid;
            String[] split = mount.split(" ");
            if (split.length < 6) continue;
            String path = split[1].replaceAll(UNICODE_SPACE, " ");
            String type = split[2];
            if (localOnly && NETWORK_FS_TYPES.contains(type) || PSEUDO_FS_TYPES.contains(type) || path.equals("/dev") || Builder.filePathStartsWith(TMP_FS_PATHS, path) || path.endsWith("/shm")) continue;
            String options = split[3];
            String name = split[0].replaceAll(UNICODE_SPACE, " ");
            if (path.equals("/")) {
                name = "/";
            }
            if (nameToMatch != null && !nameToMatch.equals(name)) continue;
            String volume = split[0].replaceAll(UNICODE_SPACE, " ");
            String string = uuid = uuidMap != null ? uuidMap.getOrDefault(split[0], "") : "";
            String description = volume.startsWith("/dev") ? "Local Disk" : (volume.equals("tmpfs") ? "Ram Disk" : (NETWORK_FS_TYPES.contains(type) ? "Network Disk" : "Mount Point"));
            String logicalVolume = "";
            String volumeMapperDirectory = "/dev/mapper/";
            Path link = Paths.get(volume, new String[0]);
            if (link.toFile().exists() && Files.isSymbolicLink(link)) {
                try {
                    Path slink = Files.readSymbolicLink(link);
                    Path full = Paths.get(volumeMapperDirectory + slink.toString(), new String[0]);
                    if (full.toFile().exists()) {
                        logicalVolume = full.normalize().toString();
                    }
                }
                catch (IOException e) {
                    Logger.warn("Couldn't access symbolic path  {}. {}", link, e.getMessage());
                }
            }
            long totalInodes = 0L;
            long freeInodes = 0L;
            long totalSpace = 0L;
            long usableSpace = 0L;
            long freeSpace = 0L;
            try {
                LibC.Statvfs vfsStat = new LibC.Statvfs();
                if (0 == LibC.INSTANCE.statvfs(path, vfsStat)) {
                    totalInodes = vfsStat.f_files.longValue();
                    freeInodes = vfsStat.f_ffree.longValue();
                    totalSpace = vfsStat.f_blocks.longValue() * vfsStat.f_bsize.longValue();
                    usableSpace = vfsStat.f_bavail.longValue() * vfsStat.f_bsize.longValue();
                    freeSpace = vfsStat.f_bfree.longValue() * vfsStat.f_bsize.longValue();
                } else {
                    File tmpFile = new File(path);
                    totalSpace = tmpFile.getTotalSpace();
                    usableSpace = tmpFile.getUsableSpace();
                    freeSpace = tmpFile.getFreeSpace();
                    Logger.warn("Failed to get information to use statvfs. path: {}, Error code: {}", path, Native.getLastError());
                }
            }
            catch (NoClassDefFoundError | UnsatisfiedLinkError e) {
                Logger.error("Failed to get file counts from statvfs. {}", e.getMessage());
            }
            OSFileStore osStore = new OSFileStore();
            osStore.setName(name);
            osStore.setVolume(volume);
            osStore.setLabel(name);
            osStore.setMount(path);
            osStore.setDescription(description);
            osStore.setType(type);
            osStore.setOptions(options);
            osStore.setUUID(uuid);
            osStore.setFreeSpace(freeSpace);
            osStore.setUsableSpace(usableSpace);
            osStore.setTotalSpace(totalSpace);
            osStore.setFreeInodes(freeInodes);
            osStore.setTotalInodes(totalInodes);
            osStore.setLogicalVolume(logicalVolume);
            fsList.add(osStore);
        }
        return fsList;
    }

    public static boolean updateFileStoreStats(OSFileStore osFileStore) {
        for (OSFileStore fileStore : LinuxFileSystem.getFileStoreMatching(osFileStore.getName(), null)) {
            if (!osFileStore.getVolume().equals(fileStore.getVolume()) || !osFileStore.getMount().equals(fileStore.getMount())) continue;
            osFileStore.setLogicalVolume(fileStore.getLogicalVolume());
            osFileStore.setDescription(fileStore.getDescription());
            osFileStore.setType(fileStore.getType());
            osFileStore.setFreeSpace(fileStore.getFreeSpace());
            osFileStore.setUsableSpace(fileStore.getUsableSpace());
            osFileStore.setTotalSpace(fileStore.getTotalSpace());
            osFileStore.setFreeInodes(fileStore.getFreeInodes());
            osFileStore.setTotalInodes(fileStore.getTotalInodes());
            return true;
        }
        return false;
    }

    @Override
    public OSFileStore[] getFileStores(boolean localOnly) {
        HashMap<String, String> uuidMap = new HashMap<String, String>();
        File uuidDir = new File("/dev/disk/by-uuid");
        if (uuidDir.listFiles() != null) {
            for (File uuid : uuidDir.listFiles()) {
                try {
                    uuidMap.put(uuid.getCanonicalPath(), uuid.getName().toLowerCase());
                }
                catch (IOException e) {
                    Logger.error("Couldn't get canonical path for {}. {}", uuid.getName(), e.getMessage());
                }
            }
        }
        List<OSFileStore> fsList = LinuxFileSystem.getFileStoreMatching(null, uuidMap, localOnly);
        return fsList.toArray(new OSFileStore[0]);
    }

    @Override
    public long getOpenFileDescriptors() {
        return this.getFileDescriptors(0);
    }

    @Override
    public long getMaxFileDescriptors() {
        return this.getFileDescriptors(2);
    }

    private long getFileDescriptors(int index) {
        String filename = ProcPath.SYS_FS_FILE_NR;
        if (index < 0 || index > 2) {
            throw new IllegalArgumentException("Index must be between 0 and 2.");
        }
        List<String> osDescriptors = FileKit.readLines(filename);
        if (!osDescriptors.isEmpty()) {
            String[] splittedLine = osDescriptors.get(0).split("\\D+");
            return Builder.parseLongOrDefault(splittedLine[index], 0L);
        }
        return 0L;
    }
}

