/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.health.unix.freebsd.hardware;

import java.util.function.Supplier;
import org.aoju.bus.core.annotation.ThreadSafe;
import org.aoju.bus.health.Memoize;
import org.aoju.bus.health.builtin.hardware.AbstractGlobalMemory;
import org.aoju.bus.health.builtin.hardware.VirtualMemory;
import org.aoju.bus.health.unix.freebsd.BsdSysctl;
import org.aoju.bus.health.unix.freebsd.hardware.FreeBsdVirtualMemory;

@ThreadSafe
final class FreeBsdGlobalMemory
extends AbstractGlobalMemory {
    private final Supplier<Long> total = Memoize.memoize(FreeBsdGlobalMemory::queryPhysMem);
    private final Supplier<Long> pageSize = Memoize.memoize(FreeBsdGlobalMemory::queryPageSize);
    private final Supplier<Long> available = Memoize.memoize(this::queryVmStats, Memoize.defaultExpiration());
    private final Supplier<VirtualMemory> vm = Memoize.memoize(this::createVirtualMemory);

    FreeBsdGlobalMemory() {
    }

    private static long queryPhysMem() {
        return BsdSysctl.sysctl("hw.physmem", 0L);
    }

    private static long queryPageSize() {
        return BsdSysctl.sysctl("hw.pagesize", 4096L);
    }

    @Override
    public long getAvailable() {
        return this.available.get();
    }

    @Override
    public long getTotal() {
        return this.total.get();
    }

    @Override
    public long getPageSize() {
        return this.pageSize.get();
    }

    @Override
    public VirtualMemory getVirtualMemory() {
        return this.vm.get();
    }

    private long queryVmStats() {
        long inactive = BsdSysctl.sysctl("vm.stats.vm.v_inactive_count", 0L);
        long cache = BsdSysctl.sysctl("vm.stats.vm.v_cache_count", 0L);
        long free = BsdSysctl.sysctl("vm.stats.vm.v_free_count", 0L);
        return (inactive + cache + free) * this.getPageSize();
    }

    private VirtualMemory createVirtualMemory() {
        return new FreeBsdVirtualMemory(this);
    }
}

