/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.health.unix.freebsd.hardware;

import java.util.ArrayList;
import java.util.List;
import org.aoju.bus.core.annotation.Immutable;
import org.aoju.bus.core.lang.RegEx;
import org.aoju.bus.health.Builder;
import org.aoju.bus.health.Executor;
import org.aoju.bus.health.builtin.hardware.AbstractGraphicsCard;

@Immutable
final class FreeBsdGraphicsCard
extends AbstractGraphicsCard {
    private static final String PCI_CLASS_DISPLAY = "0x03";

    FreeBsdGraphicsCard(String name, String deviceId, String vendor, String versionInfo, long vram) {
        super(name, deviceId, vendor, versionInfo, vram);
    }

    public static List<FreeBsdGraphicsCard> getGraphicsCards() {
        ArrayList<FreeBsdGraphicsCard> cardList = new ArrayList<FreeBsdGraphicsCard>();
        List<String> devices = Executor.runNative("pciconf -lv");
        if (devices.isEmpty()) {
            return cardList;
        }
        String name = "unknown";
        String vendorId = "unknown";
        String productId = "unknown";
        String classCode = "";
        String versionInfo = "unknown";
        for (String line : devices) {
            String[] split;
            if (line.contains("class=0x")) {
                if (PCI_CLASS_DISPLAY.equals(classCode)) {
                    cardList.add(new FreeBsdGraphicsCard(name.isEmpty() ? "unknown" : name, productId.isEmpty() ? "unknown" : productId, vendorId.isEmpty() ? "unknown" : vendorId, versionInfo.isEmpty() ? "unknown" : versionInfo, 0L));
                }
                for (String s : split = RegEx.SPACES.split(line)) {
                    String[] keyVal = s.split("=");
                    if (keyVal.length <= 1) continue;
                    if (keyVal[0].equals("class") && keyVal[1].length() >= 4) {
                        classCode = keyVal[1].substring(0, 4);
                        continue;
                    }
                    if (keyVal[0].equals("chip") && keyVal[1].length() >= 10) {
                        productId = keyVal[1].substring(0, 6);
                        vendorId = "0x" + keyVal[1].substring(6, 10);
                        continue;
                    }
                    if (!keyVal[0].contains("rev")) continue;
                    versionInfo = s;
                }
                name = "unknown";
                continue;
            }
            split = line.trim().split("=", 2);
            if (split.length != 2) continue;
            String key = split[0].trim();
            if (key.equals("vendor")) {
                vendorId = Builder.getSingleQuoteStringValue(line) + (vendorId.equals("unknown") ? "" : " (" + vendorId + ")");
                continue;
            }
            if (!key.equals("device")) continue;
            name = Builder.getSingleQuoteStringValue(line);
        }
        if (PCI_CLASS_DISPLAY.equals(classCode)) {
            cardList.add(new FreeBsdGraphicsCard(name.isEmpty() ? "unknown" : name, productId.isEmpty() ? "unknown" : productId, vendorId.isEmpty() ? "unknown" : vendorId, versionInfo.isEmpty() ? "unknown" : versionInfo, 0L));
        }
        return cardList;
    }
}

