/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.health.unix.solaris;

import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.platform.unix.solaris.LibKstat;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import org.aoju.bus.core.annotation.ThreadSafe;
import org.aoju.bus.health.Builder;
import org.aoju.bus.logger.Logger;

@ThreadSafe
public final class KstatCtl {
    private static final LibKstat KS = LibKstat.INSTANCE;
    private static final LibKstat.KstatCtl KC = KS.kstat_open();
    private static final ReentrantLock CHAIN = new ReentrantLock();

    private KstatCtl() {
    }

    public static KstatChain openChain() {
        return new KstatChain();
    }

    public static String dataLookupString(LibKstat.Kstat ksp, String name) {
        if (ksp.ks_type != 1 && ksp.ks_type != 4) {
            throw new IllegalArgumentException("Not a kstat_named or kstat_timer kstat.");
        }
        Pointer p = KS.kstat_data_lookup(ksp, name);
        if (p == null) {
            Logger.error("Failed lo lookup kstat value for key {}", name);
            return "";
        }
        LibKstat.KstatNamed data = new LibKstat.KstatNamed(p);
        switch (data.data_type) {
            case 0: {
                return new String(data.value.charc, StandardCharsets.UTF_8).trim();
            }
            case 1: {
                return Integer.toString(data.value.i32);
            }
            case 2: {
                return KstatCtl.toUnsignedString(data.value.ui32);
            }
            case 3: {
                return Long.toString(data.value.i64);
            }
            case 4: {
                return KstatCtl.toUnsignedString(data.value.ui64);
            }
            case 9: {
                return data.value.str.addr.getString(0L);
            }
        }
        Logger.error("Unimplemented kstat data type {}", data.data_type);
        return "";
    }

    public static long dataLookupLong(LibKstat.Kstat ksp, String name) {
        if (ksp.ks_type != 1 && ksp.ks_type != 4) {
            throw new IllegalArgumentException("Not a kstat_named or kstat_timer kstat.");
        }
        Pointer p = KS.kstat_data_lookup(ksp, name);
        if (p == null) {
            if (Logger.get().isError()) {
                Logger.error("Failed lo lookup kstat value on {}:{}:{} for key {}", new String(ksp.ks_module, StandardCharsets.US_ASCII).trim(), ksp.ks_instance, new String(ksp.ks_name, StandardCharsets.US_ASCII).trim(), name);
            }
            return 0L;
        }
        LibKstat.KstatNamed data = new LibKstat.KstatNamed(p);
        switch (data.data_type) {
            case 1: {
                return data.value.i32;
            }
            case 2: {
                return Builder.getUnsignedInt(data.value.ui32);
            }
            case 3: {
                return data.value.i64;
            }
            case 4: {
                return data.value.ui64;
            }
        }
        Logger.error("Unimplemented or non-numeric kstat data type {}", data.data_type);
        return 0L;
    }

    public static String toUnsignedString(int i) {
        if (i >= 0) {
            return Integer.toString(i);
        }
        return Long.toString(Builder.getUnsignedInt(i));
    }

    public static String toUnsignedString(long l) {
        if (l >= 0L) {
            return Long.toString(l);
        }
        return BigInteger.valueOf(l).add(BigInteger.ONE.shiftLeft(64)).toString();
    }

    public static final class KstatChain
    implements AutoCloseable {
        private KstatChain() {
            CHAIN.lock();
            this.update();
        }

        public boolean read(LibKstat.Kstat ksp) {
            int retry = 0;
            while (0 > KS.kstat_read(KC, ksp, null)) {
                if (11 != Native.getLastError() || 5 <= ++retry) {
                    if (Logger.get().isError()) {
                        Logger.error("Failed to read kstat {}:{}:{}", new String(ksp.ks_module, StandardCharsets.US_ASCII).trim(), ksp.ks_instance, new String(ksp.ks_name, StandardCharsets.US_ASCII).trim());
                    }
                    return false;
                }
                Builder.sleep(8 << retry);
            }
            return true;
        }

        public LibKstat.Kstat lookup(String module, int instance, String name) {
            return KS.kstat_lookup(KC, module, instance, name);
        }

        public List<LibKstat.Kstat> lookupAll(String module, int instance, String name) {
            ArrayList<LibKstat.Kstat> kstats = new ArrayList<LibKstat.Kstat>();
            for (LibKstat.Kstat ksp = KS.kstat_lookup(KC, module, instance, name); ksp != null; ksp = ksp.next()) {
                if (module != null && !module.equals(new String(ksp.ks_module, StandardCharsets.US_ASCII).trim()) || instance >= 0 && instance != ksp.ks_instance || name != null && !name.equals(new String(ksp.ks_name, StandardCharsets.US_ASCII).trim())) continue;
                kstats.add(ksp);
            }
            return kstats;
        }

        public int update() {
            return KS.kstat_chain_update(KC);
        }

        @Override
        public void close() {
            CHAIN.unlock();
        }
    }
}

