/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.health.unix.solaris.hardware;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.aoju.bus.core.annotation.Immutable;
import org.aoju.bus.health.Builder;
import org.aoju.bus.health.Executor;
import org.aoju.bus.health.builtin.hardware.AbstractSoundCard;

@Immutable
final class SolarisSoundCard
extends AbstractSoundCard {
    private static final String LSHAL = "lshal";
    private static final String DEFAULT_AUDIO_DRIVER = "audio810";

    SolarisSoundCard(String kernelVersion, String name, String codec) {
        super(kernelVersion, name, codec);
    }

    public static List<SolarisSoundCard> getSoundCards() {
        HashMap<String, String> vendorMap = new HashMap<String, String>();
        HashMap<String, String> productMap = new HashMap<String, String>();
        ArrayList<String> sounds = new ArrayList<String>();
        String key = "";
        for (String line : Executor.runNative(LSHAL)) {
            if ((line = line.trim()).startsWith("udi =")) {
                key = Builder.getSingleQuoteStringValue(line);
                continue;
            }
            if (key.isEmpty() || line.isEmpty()) continue;
            if (line.contains("info.solaris.driver =") && DEFAULT_AUDIO_DRIVER.equals(Builder.getSingleQuoteStringValue(line))) {
                sounds.add(key);
                continue;
            }
            if (line.contains("info.product")) {
                productMap.put(key, Builder.getStringBetween(line, '\''));
                continue;
            }
            if (!line.contains("info.vendor")) continue;
            vendorMap.put(key, Builder.getStringBetween(line, '\''));
        }
        ArrayList<SolarisSoundCard> soundCards = new ArrayList<SolarisSoundCard>();
        for (String _key : sounds) {
            soundCards.add(new SolarisSoundCard((String)productMap.get(_key) + " " + DEFAULT_AUDIO_DRIVER, (String)vendorMap.get(_key) + " " + (String)productMap.get(_key), (String)productMap.get(_key)));
        }
        return soundCards;
    }
}

