/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.health.unix.solaris.software;

import com.sun.jna.platform.unix.solaris.LibKstat;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.aoju.bus.core.annotation.ThreadSafe;
import org.aoju.bus.core.lang.RegEx;
import org.aoju.bus.health.Builder;
import org.aoju.bus.health.Executor;
import org.aoju.bus.health.builtin.software.AbstractFileSystem;
import org.aoju.bus.health.builtin.software.OSFileStore;
import org.aoju.bus.health.unix.solaris.KstatCtl;

@ThreadSafe
public class SolarisFileSystem
extends AbstractFileSystem {
    private static final List<String> TMP_FS_PATHS = Arrays.asList("/system", "/tmp", "/dev/fd");

    private static List<OSFileStore> getFileStoreMatching(String nameToMatch) {
        return SolarisFileSystem.getFileStoreMatching(nameToMatch, false);
    }

    private static List<OSFileStore> getFileStoreMatching(String nameToMatch, boolean localOnly) {
        ArrayList<OSFileStore> fsList = new ArrayList<OSFileStore>();
        HashMap<String, Long> inodeFreeMap = new HashMap<String, Long>();
        HashMap<String, Long> inodeTotalMap = new HashMap<String, Long>();
        String key = null;
        String total = null;
        String free = null;
        String command = "df -g" + (localOnly ? " -l" : "");
        for (String line : Executor.runNative(command)) {
            if (line.startsWith("/")) {
                key = RegEx.SPACES.split(line)[0];
                total = null;
                continue;
            }
            if (line.contains("available") && line.contains("total files")) {
                total = Builder.getTextBetweenStrings(line, "available", "total files").trim();
                continue;
            }
            if (!line.contains("free files")) continue;
            free = Builder.getTextBetweenStrings(line, "", "free files").trim();
            if (key == null || total == null) continue;
            inodeFreeMap.put(key, Builder.parseLongOrDefault(free, 0L));
            inodeTotalMap.put(key, Builder.parseLongOrDefault(total, 0L));
            key = null;
        }
        for (String fs : Executor.runNative("cat /etc/mnttab")) {
            String[] split = RegEx.SPACES.split(fs);
            if (split.length < 5) continue;
            String volume = split[0];
            String path = split[1];
            String type = split[2];
            String options = split[3];
            if (localOnly && NETWORK_FS_TYPES.contains(type) || PSEUDO_FS_TYPES.contains(type) || path.equals("/dev") || Builder.filePathStartsWith(TMP_FS_PATHS, path) || volume.startsWith("rpool") && !path.equals("/")) continue;
            String name = path.substring(path.lastIndexOf(47) + 1);
            if (name.isEmpty()) {
                name = volume.substring(volume.lastIndexOf(47) + 1);
            }
            if (nameToMatch != null && !nameToMatch.equals(name)) continue;
            File f = new File(path);
            long totalSpace = f.getTotalSpace();
            long usableSpace = f.getUsableSpace();
            long freeSpace = f.getFreeSpace();
            String description = volume.startsWith("/dev") || path.equals("/") ? "Local Disk" : (volume.equals("tmpfs") ? "Ram Disk" : (NETWORK_FS_TYPES.contains(type) ? "Network Disk" : "Mount Point"));
            OSFileStore osStore = new OSFileStore();
            osStore.setName(name);
            osStore.setVolume(volume);
            osStore.setLabel(name);
            osStore.setMount(path);
            osStore.setDescription(description);
            osStore.setType(type);
            osStore.setOptions(options);
            osStore.setUUID("");
            osStore.setFreeSpace(freeSpace);
            osStore.setUsableSpace(usableSpace);
            osStore.setTotalSpace(totalSpace);
            osStore.setFreeInodes(inodeFreeMap.containsKey(path) ? (Long)inodeFreeMap.get(path) : 0L);
            osStore.setTotalInodes(inodeTotalMap.containsKey(path) ? (Long)inodeTotalMap.get(path) : 0L);
            fsList.add(osStore);
        }
        return fsList;
    }

    public static boolean updateFileStoreStats(OSFileStore osFileStore) {
        for (OSFileStore fileStore : SolarisFileSystem.getFileStoreMatching(osFileStore.getName())) {
            if (!osFileStore.getVolume().equals(fileStore.getVolume()) || !osFileStore.getMount().equals(fileStore.getMount())) continue;
            osFileStore.setLogicalVolume(fileStore.getLogicalVolume());
            osFileStore.setDescription(fileStore.getDescription());
            osFileStore.setType(fileStore.getType());
            osFileStore.setFreeSpace(fileStore.getFreeSpace());
            osFileStore.setUsableSpace(fileStore.getUsableSpace());
            osFileStore.setTotalSpace(fileStore.getTotalSpace());
            osFileStore.setFreeInodes(fileStore.getFreeInodes());
            osFileStore.setTotalInodes(fileStore.getTotalInodes());
            return true;
        }
        return false;
    }

    @Override
    public OSFileStore[] getFileStores(boolean localOnly) {
        List<OSFileStore> fsList = SolarisFileSystem.getFileStoreMatching(null, localOnly);
        return fsList.toArray(new OSFileStore[0]);
    }

    @Override
    public long getOpenFileDescriptors() {
        try (KstatCtl.KstatChain kc = KstatCtl.openChain();){
            LibKstat.Kstat ksp = kc.lookup(null, -1, "file_cache");
            if (ksp != null && kc.read(ksp)) {
                long l = KstatCtl.dataLookupLong(ksp, "buf_inuse");
                return l;
            }
        }
        return 0L;
    }

    @Override
    public long getMaxFileDescriptors() {
        try (KstatCtl.KstatChain kc = KstatCtl.openChain();){
            LibKstat.Kstat ksp = kc.lookup(null, -1, "file_cache");
            if (ksp != null && kc.read(ksp)) {
                long l = KstatCtl.dataLookupLong(ksp, "buf_max");
                return l;
            }
        }
        return 0L;
    }
}

