/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.health.windows;

import com.sun.jna.platform.win32.WinNT;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.aoju.bus.core.annotation.ThreadSafe;
import org.aoju.bus.health.Builder;
import org.aoju.bus.health.windows.PerfDataCounter;
import org.aoju.bus.logger.Logger;

@ThreadSafe
public final class PerfCounterQueryHandler {
    private Map<PerfDataCounter.PerfCounter, WinNT.HANDLEByReference> counterHandleMap = new ConcurrentHashMap<PerfDataCounter.PerfCounter, WinNT.HANDLEByReference>();
    private Map<String, WinNT.HANDLEByReference> queryHandleMap = new ConcurrentHashMap<String, WinNT.HANDLEByReference>();
    private Map<String, List<PerfDataCounter.PerfCounter>> queryCounterMap = new ConcurrentHashMap<String, List<PerfDataCounter.PerfCounter>>();

    public PerfCounterQueryHandler() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                PerfCounterQueryHandler.this.removeAllCounters();
            }
        });
    }

    public boolean addCounterToQuery(PerfDataCounter.PerfCounter counter) {
        return this.addCounterToQuery(counter, counter.getObject());
    }

    public boolean addCounterToQuery(PerfDataCounter.PerfCounter counter, String key) {
        WinNT.HANDLEByReference q = this.getOrOpenQuery(key);
        if (q == null) {
            Logger.error("Failed to open a query for PDH object: {}", counter.getObject());
            return false;
        }
        WinNT.HANDLEByReference p = new WinNT.HANDLEByReference();
        if (PerfDataCounter.addCounter(q, counter.getCounterPath(), p)) {
            this.counterHandleMap.put(counter, p);
            List<PerfDataCounter.PerfCounter> counterList = this.queryCounterMap.get(key);
            if (counterList != null) {
                counterList.add(counter);
            }
            return true;
        }
        return false;
    }

    public boolean removeCounterFromQuery(PerfDataCounter.PerfCounter counter) {
        return this.removeCounterFromQuery(counter, counter.getObject());
    }

    public boolean removeCounterFromQuery(PerfDataCounter.PerfCounter counter, String key) {
        List<PerfDataCounter.PerfCounter> counterList;
        WinNT.HANDLEByReference href = this.counterHandleMap.remove(counter);
        boolean success = false;
        if (href != null) {
            success = PerfDataCounter.removeCounter(href);
        }
        if ((counterList = this.queryCounterMap.get(key)) != null && counterList.remove(counter) && counterList.isEmpty()) {
            this.queryCounterMap.remove(key);
            PerfDataCounter.closeQuery(this.queryHandleMap.remove(key));
        }
        return success;
    }

    public void removeAllCountersFromQuery(String queryKey) {
        List<PerfDataCounter.PerfCounter> counterList = this.queryCounterMap.remove(queryKey);
        if (counterList == null) {
            return;
        }
        for (PerfDataCounter.PerfCounter counter : counterList) {
            WinNT.HANDLEByReference href = this.counterHandleMap.remove(counter);
            if (href == null) continue;
            PerfDataCounter.removeCounter(href);
        }
        WinNT.HANDLEByReference href = this.queryHandleMap.remove(queryKey);
        if (href != null) {
            PerfDataCounter.closeQuery(href);
        }
    }

    public void removeAllCounters() {
        for (WinNT.HANDLEByReference href : this.counterHandleMap.values()) {
            PerfDataCounter.removeCounter(href);
        }
        this.counterHandleMap.clear();
        for (WinNT.HANDLEByReference query : this.queryHandleMap.values()) {
            PerfDataCounter.closeQuery(query);
        }
        this.queryHandleMap.clear();
        this.queryCounterMap.clear();
    }

    public long updateQuery(String key) {
        if (!this.queryHandleMap.containsKey(key)) {
            Logger.error("Query key {} does not exist to update.", key);
            return 0L;
        }
        return PerfDataCounter.updateQueryTimestamp(this.queryHandleMap.get(key));
    }

    public long queryCounter(PerfDataCounter.PerfCounter counter) {
        if (!this.counterHandleMap.containsKey(counter)) {
            if (Logger.get().isError()) {
                Logger.error("Counter {} does not exist to query.", counter.getCounterPath());
            }
            return 0L;
        }
        long value = PerfDataCounter.queryCounter(this.counterHandleMap.get(counter));
        if (value < 0L) {
            if (Logger.get().isTrace()) {
                Logger.warn("Error querying counter {}: {}", counter.getCounterPath(), String.format(Builder.formatError((int)value), new Object[0]));
            }
            return 0L;
        }
        return value;
    }

    private WinNT.HANDLEByReference getOrOpenQuery(String key) {
        if (this.queryHandleMap.containsKey(key)) {
            return this.queryHandleMap.get(key);
        }
        WinNT.HANDLEByReference q = new WinNT.HANDLEByReference();
        if (PerfDataCounter.openQuery(q)) {
            this.queryHandleMap.put(key, q);
            List counterList = Collections.synchronizedList(new ArrayList());
            this.queryCounterMap.put(key, counterList);
            return q;
        }
        return null;
    }
}

