/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.health.windows;

import com.sun.jna.platform.win32.COM.COMException;
import com.sun.jna.platform.win32.COM.COMUtils;
import com.sun.jna.platform.win32.COM.WbemcliUtil;
import com.sun.jna.platform.win32.Ole32;
import com.sun.jna.platform.win32.WinNT;
import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeoutException;
import org.aoju.bus.core.annotation.ThreadSafe;
import org.aoju.bus.health.Config;
import org.aoju.bus.health.windows.WmiQuery;
import org.aoju.bus.logger.Logger;

@ThreadSafe
public class WmiQueryHandler {
    private static final Class<?>[] EMPTY_CLASS_ARRAY = new Class[0];
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    private static int globalTimeout = Config.get("health.wmi.timeout", -1);
    private static Class<? extends WmiQueryHandler> customClass = null;
    private final Set<String> failedWmiClassNames = new HashSet<String>();
    private int wmiTimeout = globalTimeout;
    private int comThreading = 0;
    private boolean securityInitialized = false;

    public static synchronized WmiQueryHandler createInstance() {
        if (customClass == null) {
            return new WmiQueryHandler();
        }
        try {
            return customClass.getConstructor(EMPTY_CLASS_ARRAY).newInstance(EMPTY_OBJECT_ARRAY);
        }
        catch (NoSuchMethodException | SecurityException e) {
            Logger.error("Failed to find or access a no-arg constructor for {}", customClass);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
            Logger.error("Failed to create a new instance of {}", customClass);
        }
        return null;
    }

    public static synchronized void setInstanceClass(Class<? extends WmiQueryHandler> instanceClass) {
        customClass = instanceClass;
    }

    public <T extends Enum<T>> WbemcliUtil.WmiResult<T> queryWMI(WbemcliUtil.WmiQuery<T> query) {
        WbemcliUtil wbemcliUtil = WbemcliUtil.INSTANCE;
        wbemcliUtil.getClass();
        WbemcliUtil.WmiResult result = new WbemcliUtil.WmiResult(wbemcliUtil, query.getPropertyEnum());
        if (this.failedWmiClassNames.contains(query.getWmiClassName())) {
            return result;
        }
        boolean comInit = false;
        try {
            comInit = this.initCOM();
            result = query.execute(this.wmiTimeout);
        }
        catch (COMException e) {
            if (!"ROOT\\OpenHardwareMonitor".equals(query.getNameSpace())) {
                int hresult = e.getHresult() == null ? -1 : e.getHresult().intValue();
                switch (hresult) {
                    case -2147217394: {
                        Logger.warn("COM exception: Invalid Namespace {}", query.getNameSpace());
                        break;
                    }
                    case -2147217392: {
                        Logger.warn("COM exception: Invalid Class {}", query.getWmiClassName());
                        break;
                    }
                    case -2147217385: {
                        Logger.warn("COM exception: Invalid Query: {}", WmiQuery.queryToString(query));
                        break;
                    }
                    default: {
                        this.handleComException(query, e);
                    }
                }
                this.failedWmiClassNames.add(query.getWmiClassName());
            }
        }
        catch (TimeoutException e) {
            Logger.error("WMI query timed out after {} ms: {}", this.wmiTimeout, WmiQuery.queryToString(query));
        }
        if (comInit) {
            this.unInitCOM();
        }
        return result;
    }

    protected void handleComException(WbemcliUtil.WmiQuery<?> query, COMException ex) {
        Logger.warn("COM exception querying {}, which might not be on your system. Will not attempt to query it again. Error was {}: {}", query.getWmiClassName(), ex.getHresult().intValue(), ex.getMessage());
    }

    public boolean initCOM() {
        boolean comInit = false;
        comInit = this.initCOM(this.getComThreading());
        if (!comInit) {
            comInit = this.initCOM(this.switchComThreading());
        }
        if (comInit && !this.isSecurityInitialized()) {
            WinNT.HRESULT hres = Ole32.INSTANCE.CoInitializeSecurity(null, -1, null, null, 0, 3, null, 0, null);
            if (COMUtils.FAILED((WinNT.HRESULT)hres) && hres.intValue() != -2147417831) {
                Ole32.INSTANCE.CoUninitialize();
                throw new COMException("Failed to initialize security.", hres);
            }
            this.securityInitialized = true;
        }
        return comInit;
    }

    protected boolean initCOM(int coInitThreading) {
        WinNT.HRESULT hres = Ole32.INSTANCE.CoInitializeEx(null, coInitThreading);
        switch (hres.intValue()) {
            case 0: 
            case 1: {
                return true;
            }
            case -2147417850: {
                return false;
            }
        }
        throw new COMException("Failed to initialize COM library.", hres);
    }

    public void unInitCOM() {
        Ole32.INSTANCE.CoUninitialize();
    }

    public int getComThreading() {
        return this.comThreading;
    }

    public int switchComThreading() {
        this.comThreading = this.comThreading == 2 ? 0 : 2;
        return this.comThreading;
    }

    public boolean isSecurityInitialized() {
        return this.securityInitialized;
    }

    public int getWmiTimeout() {
        return this.wmiTimeout;
    }

    public void setWmiTimeout(int wmiTimeout) {
        this.wmiTimeout = wmiTimeout;
    }

    static {
        if (globalTimeout == 0 || globalTimeout < -1) {
            throw new Config.PropertyException("health.wmi.timeout");
        }
    }
}

