/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.http.accord;

import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.Executor;
import org.aoju.bus.http.OnBack;
import org.aoju.bus.http.Process;

public class ProcessStream
extends InputStream {
    private InputStream input;
    private OnBack<Process> onProcess;
    private Executor callbackExecutor;
    private long stepBytes;
    private long step = 0L;
    private Process process;
    private boolean doneCalled = false;

    public ProcessStream(InputStream input, OnBack<Process> onProcess, long totalBytes, long stepBytes, long doneBytes, Executor callbackExecutor) {
        this.input = input;
        this.onProcess = onProcess;
        this.stepBytes = stepBytes;
        this.callbackExecutor = callbackExecutor;
        this.process = new Process(totalBytes, doneBytes);
        this.step = doneBytes / stepBytes;
    }

    @Override
    public int read() throws IOException {
        int data = this.input.read();
        if (data > -1) {
            this.process.increaseDoneBytes();
        }
        if (this.process.notDoneOrReached(this.step * this.stepBytes)) {
            return data;
        }
        if (this.process.isDone()) {
            if (this.doneCalled) {
                return data;
            }
            this.doneCalled = true;
        }
        ++this.step;
        this.callbackExecutor.execute(() -> this.onProcess.on(this.process));
        return data;
    }
}

