/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.image.galaxy.data;

import java.util.Map;
import org.aoju.bus.image.UID;
import org.aoju.bus.image.galaxy.Property;
import org.aoju.bus.image.galaxy.data.Attributes;
import org.aoju.bus.image.galaxy.data.AttributesCoercion;

public class RemapUIDAttributesCoercion
implements AttributesCoercion {
    private final Map<String, String> uidMap;
    private final AttributesCoercion next;

    public RemapUIDAttributesCoercion(Map<String, String> uidMap, AttributesCoercion next) {
        this.uidMap = uidMap;
        this.next = next;
    }

    @Override
    public String remapUID(String uid) {
        String remappedUID = this.uidMap != null ? Property.maskNull(this.uidMap.get(uid), uid) : uid;
        return this.next != null ? this.next.remapUID(remappedUID) : remappedUID;
    }

    @Override
    public void coerce(Attributes attrs, Attributes modified) {
        if (this.uidMap != null && !this.uidMap.isEmpty()) {
            UID.remapUIDs(attrs, this.uidMap);
        }
        if (this.next != null) {
            this.next.coerce(attrs, modified);
        }
    }
}

