/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.oauth.provider;

import com.alibaba.fastjson.JSONObject;
import org.aoju.bus.cache.metric.ExtendCache;
import org.aoju.bus.core.lang.Normal;
import org.aoju.bus.core.lang.exception.AuthorizedException;
import org.aoju.bus.oauth.Context;
import org.aoju.bus.oauth.Registry;
import org.aoju.bus.oauth.magic.AccToken;
import org.aoju.bus.oauth.magic.Callback;
import org.aoju.bus.oauth.magic.Property;
import org.aoju.bus.oauth.provider.DefaultProvider;

public class CsdnProvider
extends DefaultProvider {
    public CsdnProvider(Context context) {
        super(context, Registry.CSDN);
    }

    public CsdnProvider(Context context, ExtendCache extendCache) {
        super(context, Registry.CSDN, extendCache);
    }

    @Override
    protected AccToken getAccessToken(Callback Callback2) {
        JSONObject object = JSONObject.parseObject((String)this.doPostAuthorizationCode(Callback2.getCode()));
        this.checkResponse(object);
        return AccToken.builder().accessToken(object.getString("access_token")).build();
    }

    @Override
    protected Property getUserInfo(AccToken token) {
        JSONObject object = JSONObject.parseObject((String)this.doGetUserInfo(token));
        this.checkResponse(object);
        return Property.builder().uuid(object.getString("username")).username(object.getString("username")).remark(object.getString("description")).blog(object.getString("website")).gender(Normal.Gender.UNKNOWN).token(token).source(this.source.toString()).build();
    }

    private void checkResponse(JSONObject object) {
        if (object.containsKey((Object)"error_code")) {
            throw new AuthorizedException(object.getString("error"));
        }
    }
}

