/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.office.magic.filter;

import com.sun.star.drawing.XDrawPages;
import com.sun.star.drawing.XDrawPagesSupplier;
import com.sun.star.frame.XModel;
import com.sun.star.lang.XComponent;
import org.aoju.bus.office.Context;
import org.aoju.bus.office.magic.Calc;
import org.aoju.bus.office.magic.Draw;
import org.aoju.bus.office.magic.Lo;
import org.aoju.bus.office.magic.Props;
import org.aoju.bus.office.magic.Write;
import org.aoju.bus.office.magic.filter.Filter;
import org.aoju.bus.office.magic.filter.FilterChain;

public class PageCounterFilter
implements Filter {
    private int pageCount;

    @Override
    public void doFilter(Context context, XComponent document, FilterChain chain) {
        if (Write.isText(document)) {
            this.pageCount = (Integer)Props.getProperty(Lo.qi(XModel.class, document).getCurrentController(), "PageCount").orElse(0);
        } else {
            if (Calc.isCalc(document)) {
                throw new UnsupportedOperationException("SpreadsheetDocument not supported yet");
            }
            if (Draw.isImpress(document)) {
                throw new UnsupportedOperationException("PresentationDocument not supported yet");
            }
            if (Draw.isDraw(document)) {
                XDrawPages xDrawPages = Lo.qi(XDrawPagesSupplier.class, document).getDrawPages();
                this.pageCount = xDrawPages.getCount();
            }
        }
        chain.doFilter(context, document);
    }

    public int getPageCount() {
        return this.pageCount;
    }
}

