/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.office.magic.filter.text;

import com.sun.star.beans.XPropertySet;
import com.sun.star.container.XIndexAccess;
import com.sun.star.lang.XComponent;
import com.sun.star.text.XDocumentIndex;
import com.sun.star.text.XDocumentIndexesSupplier;
import org.aoju.bus.logger.Logger;
import org.aoju.bus.office.Context;
import org.aoju.bus.office.magic.Lo;
import org.aoju.bus.office.magic.Write;
import org.aoju.bus.office.magic.filter.Filter;
import org.aoju.bus.office.magic.filter.FilterChain;

public class TableOfContentUpdaterFilter
implements Filter {
    private final int level;

    public TableOfContentUpdaterFilter() {
        this(0);
    }

    public TableOfContentUpdaterFilter(int level) {
        this.level = level;
    }

    @Override
    public void doFilter(Context context, XComponent document, FilterChain chain) throws Exception {
        Logger.debug("Applying the TableOfContentUpdaterFilter", new Object[0]);
        if (Write.isText(document)) {
            this.updateToc(document);
        }
        chain.doFilter(context, document);
    }

    private void updateToc(XComponent document) throws Exception {
        XDocumentIndexesSupplier documentIndexesSupplier = Lo.qi(XDocumentIndexesSupplier.class, document);
        XIndexAccess documentIndexes = Lo.qi(XIndexAccess.class, documentIndexesSupplier.getDocumentIndexes());
        for (int i = 0; i < documentIndexes.getCount(); ++i) {
            String indexType;
            XDocumentIndex docIndex = Lo.qi(XDocumentIndex.class, documentIndexes.getByIndex(i));
            if (this.level > 0 && (indexType = docIndex.getServiceName()).contains("com.sun.star.text.ContentIndex")) {
                XPropertySet index = Lo.qi(XPropertySet.class, docIndex);
                index.setPropertyValue("Level", (Object)((short)this.level));
            }
            docIndex.update();
        }
    }
}

