/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.office.magic.filter.text;

import com.sun.star.beans.XPropertySet;
import com.sun.star.drawing.XShape;
import com.sun.star.lang.XComponent;
import com.sun.star.text.XText;
import com.sun.star.text.XTextContent;
import com.sun.star.text.XTextCursor;
import com.sun.star.text.XTextDocument;
import com.sun.star.text.XTextFrame;
import com.sun.star.text.XTextRange;
import java.awt.Dimension;
import java.util.Map;
import org.aoju.bus.core.lang.Assert;
import org.aoju.bus.logger.Logger;
import org.aoju.bus.office.Context;
import org.aoju.bus.office.magic.Lo;
import org.aoju.bus.office.magic.Write;
import org.aoju.bus.office.magic.filter.FilterChain;
import org.aoju.bus.office.magic.filter.text.AbstractTextContentInserterFilter;

public class TextInserterFilter
extends AbstractTextContentInserterFilter {
    private final String insertedText;

    public TextInserterFilter(String text, int width, int height, int horizontalPosition, int verticalPosition) {
        super(new Dimension(width, height), horizontalPosition, verticalPosition);
        Assert.notBlank(text);
        this.insertedText = text;
    }

    public TextInserterFilter(String text, int width, int height, Map<String, Object> shapeProperties) {
        super(new Dimension(width, height), shapeProperties);
        Assert.notBlank(text);
        this.insertedText = text;
    }

    @Override
    public void doFilter(Context context, XComponent document, FilterChain chain) throws Exception {
        Logger.debug("Applying the TextInserterFilter", new Object[0]);
        if (Write.isText(document)) {
            this.insertText(document);
        }
        chain.doFilter(context, document);
    }

    private void insertText(XComponent document) throws Exception {
        XTextFrame textFrame = Lo.createInstanceMSF(document, XTextFrame.class, "com.sun.star.text.TextFrame");
        XShape shape = Lo.qi(XShape.class, textFrame);
        shape.setSize(TextInserterFilter.toOfficeSize(this.getRectSize()));
        XPropertySet propSet = Lo.qi(XPropertySet.class, textFrame);
        for (Map.Entry<String, Object> entry : this.getShapeProperties().entrySet()) {
            propSet.setPropertyValue(entry.getKey(), entry.getValue());
        }
        XTextDocument docText = Write.getTextDoc(document);
        XText text = docText.getText();
        XTextCursor textCursor = text.createTextCursor();
        this.applyAnchorPageNoFix(docText, textCursor);
        Logger.debug("Inserting frame into the document", new Object[0]);
        text.insertTextContent((XTextRange)textCursor, (XTextContent)textFrame, false);
        text = textFrame.getText();
        textCursor = text.createTextCursor();
        Logger.debug("Writing text to the inserted frame", new Object[0]);
        text.insertString((XTextRange)textCursor, this.insertedText, false);
    }
}

