/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.pager.cache;

import java.lang.reflect.Constructor;
import java.util.Properties;
import org.aoju.bus.pager.PageException;
import org.aoju.bus.pager.cache.Cache;
import org.aoju.bus.pager.cache.GuavaCache;
import org.aoju.bus.pager.cache.SimpleCache;
import org.aoju.bus.pager.plugin.PageFromObject;

public abstract class CacheFactory {
    public static <K, V> Cache<K, V> createCache(String sqlCacheClass, String prefix, Properties properties) {
        if (PageFromObject.isEmpty(sqlCacheClass)) {
            try {
                Class.forName("com.google.common.cache.Cache");
                return new GuavaCache(properties, prefix);
            }
            catch (Throwable t) {
                return new SimpleCache(properties, prefix);
            }
        }
        try {
            Class<?> clazz = Class.forName(sqlCacheClass);
            try {
                Constructor<?> constructor = clazz.getConstructor(Properties.class, String.class);
                return (Cache)constructor.newInstance(properties, prefix);
            }
            catch (Exception e) {
                return (Cache)clazz.newInstance();
            }
        }
        catch (Throwable t) {
            throw new PageException("Created Sql Cache [" + sqlCacheClass + "] Error", t);
        }
    }
}

