/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.socket.origin;

import java.net.SocketOption;
import java.util.HashMap;
import java.util.Map;
import org.aoju.bus.socket.origin.Message;
import org.aoju.bus.socket.origin.NetMonitor;
import org.aoju.bus.socket.origin.Protocol;

final class ServerConfig<T> {
    private int readBufferSize = 512;
    private int writeQueueCapacity = 512;
    private String host;
    private NetMonitor<T> monitor;
    private int port = 8888;
    private Message<T> processor;
    private Protocol<T> protocol;
    private boolean bannerEnabled = true;
    private Map<SocketOption<Object>, Object> socketOptions;
    private int writeBufferSize = 512;
    private int threadNum = 1;
    private int readBacklog = ServerConfig.getIntProperty("bus-socket.read.backlog", 4096);

    ServerConfig() {
    }

    static int getIntProperty(String property, int defaultVal) {
        String valString = System.getProperty(property);
        if (valString != null) {
            try {
                return Integer.parseInt(valString);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultVal;
    }

    static boolean getBoolProperty(String property, boolean defaultVal) {
        String valString = System.getProperty(property);
        if (valString != null) {
            return Boolean.parseBoolean(valString);
        }
        return defaultVal;
    }

    public final String getHost() {
        return this.host;
    }

    public final void setHost(String host) {
        this.host = host;
    }

    public final int getPort() {
        return this.port;
    }

    public final void setPort(int port) {
        this.port = port;
    }

    public NetMonitor<T> getMonitor() {
        return this.monitor;
    }

    public Protocol<T> getProtocol() {
        return this.protocol;
    }

    public void setProtocol(Protocol<T> protocol) {
        this.protocol = protocol;
    }

    public final Message<T> getProcessor() {
        return this.processor;
    }

    public final void setProcessor(Message<T> processor) {
        this.processor = processor;
        this.monitor = processor instanceof NetMonitor ? (NetMonitor)((Object)processor) : null;
    }

    public int getReadBufferSize() {
        return this.readBufferSize;
    }

    public void setReadBufferSize(int readBufferSize) {
        this.readBufferSize = readBufferSize;
    }

    public boolean isBannerEnabled() {
        return this.bannerEnabled;
    }

    public void setBannerEnabled(boolean bannerEnabled) {
        this.bannerEnabled = bannerEnabled;
    }

    public Map<SocketOption<Object>, Object> getSocketOptions() {
        return this.socketOptions;
    }

    public void setOption(SocketOption socketOption, Object f) {
        if (this.socketOptions == null) {
            this.socketOptions = new HashMap<SocketOption<Object>, Object>();
        }
        this.socketOptions.put(socketOption, f);
    }

    public int getWriteQueueCapacity() {
        return this.writeQueueCapacity;
    }

    public void setWriteQueueCapacity(int writeQueueCapacity) {
        this.writeQueueCapacity = writeQueueCapacity;
    }

    public int getThreadNum() {
        return this.threadNum;
    }

    public void setThreadNum(int threadNum) {
        this.threadNum = threadNum;
    }

    public int getWriteBufferSize() {
        return this.writeBufferSize;
    }

    public void setWriteBufferSize(int writeBufferSize) {
        this.writeBufferSize = writeBufferSize;
    }

    public int getReadBacklog() {
        return this.readBacklog;
    }

    static interface Property {
        public static final String PROJECT_NAME = "bus-socket";
        public static final String SESSION_WRITE_CHUNK_SIZE = "bus-socket.session.writeChunkSize";
        public static final String BUFFER_PAGE_NUM = "bus-socket.bufferPool.pageNum";
        public static final String SERVER_PAGE_SIZE = "bus-socket.server.pageSize";
        public static final String CLIENT_PAGE_SIZE = "bus-socket.client.pageSize";
        public static final String SERVER_PAGE_IS_DIRECT = "bus-socket.server.page.isDirect";
        public static final String CLIENT_PAGE_IS_DIRECT = "bus-socket.client.page.isDirect";
        public static final String READ_BACKLOG = "bus-socket.read.backlog";
    }
}

