/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.tracer;

import java.nio.charset.UnsupportedCharsetException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import org.aoju.bus.core.lang.Charset;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.tracer.Backend;
import org.aoju.bus.tracer.Resolver;
import org.aoju.bus.tracer.backend.TraceBackendProvider;
import org.aoju.bus.tracer.consts.TraceConsts;

public final class Builder {
    public static Backend getBackend() {
        return Builder.getBackend(new Resolver());
    }

    protected static Backend getBackend(Resolver resolver) {
        Set<TraceBackendProvider> backendProviders;
        try {
            backendProviders = resolver.getBackendProviders();
        }
        catch (RuntimeException e) {
            throw new InstrumentException("Unable to load available backend providers", e);
        }
        if (backendProviders.isEmpty()) {
            Set<TraceBackendProvider> defaultProvider = resolver.getDefaultTraceBackendProvider();
            if (defaultProvider.isEmpty()) {
                throw new InstrumentException("Unable to find a Builder backend provider. Make sure that you have Builder-core (for slf4j) or any other backend implementation on the classpath.");
            }
            return defaultProvider.iterator().next().provideBackend();
        }
        if (backendProviders.size() > 1) {
            ArrayList providerClasses = new ArrayList(backendProviders.size());
            for (TraceBackendProvider backendProvider : backendProviders) {
                providerClasses.add(backendProvider.getClass());
            }
            String providerClassNames = Arrays.toString(providerClasses.toArray());
            throw new InstrumentException("Multiple Builder backend providers found. Don't know which one of the following to use: " + providerClassNames);
        }
        return backendProviders.iterator().next().provideBackend();
    }

    public static String createRandomAlphanumeric(int length) {
        ThreadLocalRandom r = ThreadLocalRandom.current();
        char[] randomChars = new char[length];
        for (int i = 0; i < length; ++i) {
            randomChars[i] = TraceConsts.ALPHANUMERICS[((Random)r).nextInt(TraceConsts.ALPHANUMERICS.length)];
        }
        return new String(randomChars);
    }

    public static String createAlphanumericHash(String str, int length) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            byte[] digest = md.digest(str.getBytes(Charset.UTF_8));
            StringBuilder sb = new StringBuilder();
            for (byte b : digest) {
                if (b < 16) {
                    sb.append("0");
                }
                sb.append(Integer.toHexString(b & 0xFF));
            }
            while (sb.length() < length) {
                sb.append(sb.toString());
            }
            return sb.delete(length, sb.length()).toString();
        }
        catch (UnsupportedCharsetException | NoSuchAlgorithmException e) {
            return Builder.createRandomAlphanumeric(length);
        }
    }

    public static void generateInvocationIdIfNecessary(Backend backend) {
        if (backend != null && !backend.containsKey("TPIC.invocationId") && backend.getConfiguration().shouldGenerateInvocationId()) {
            backend.put("TPIC.invocationId", Builder.createRandomAlphanumeric(backend.getConfiguration().generatedInvocationIdLength()));
        }
    }

    public static void generateSessionIdIfNecessary(Backend backend, String sessionId) {
        if (backend != null && !backend.containsKey("TPIC.sessionId") && backend.getConfiguration().shouldGenerateSessionId()) {
            backend.put("TPIC.sessionId", Builder.createAlphanumericHash(sessionId, backend.getConfiguration().generatedSessionIdLength()));
        }
    }
}

