/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.validate;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.aoju.bus.core.lang.Assert;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.toolkit.ObjectKit;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.validate.Collector;
import org.aoju.bus.validate.Context;
import org.aoju.bus.validate.Provider;
import org.aoju.bus.validate.annotation.Array;
import org.aoju.bus.validate.annotation.Complex;
import org.aoju.bus.validate.annotation.Filler;
import org.aoju.bus.validate.annotation.Group;
import org.aoju.bus.validate.annotation.Inside;
import org.aoju.bus.validate.annotation.Valid;
import org.aoju.bus.validate.annotation.ValidEx;
import org.aoju.bus.validate.validators.Checker;
import org.aoju.bus.validate.validators.Property;

public class Validated
extends Provider {
    private List<Property> list;
    private Object object;
    private String field;
    private Context context;

    public Validated(Object object) {
        this.object = object;
        this.context = this.resolve(Context.newInstance(), new Annotation[0]);
        this.list = new ArrayList<Property>();
    }

    public Validated(Object object, Context parentContext) {
        this.object = object;
        this.context = this.resolve(parentContext, new Annotation[0]);
        this.list = new ArrayList<Property>();
    }

    public Validated(Object object, Annotation[] annotations) {
        this.object = object;
        this.context = this.resolve(Context.newInstance(), annotations);
        this.list = this.resolve(annotations);
    }

    public Validated(Object object, Annotation[] annotations, Context context) {
        this.object = object;
        this.context = this.resolve(context, annotations);
        this.list = this.resolve(annotations);
    }

    public Validated(Object object, Annotation[] annotations, Context context, String field) {
        this.field = field;
        this.object = object;
        this.context = this.resolve(context, annotations);
        this.list = this.resolve(annotations);
    }

    private List<Property> resolve(Annotation[] annotations) {
        Property property;
        ArrayList<Property> list = new ArrayList<Property>();
        for (Annotation annotation : annotations) {
            if (!Validated.isAnnotation(annotation)) continue;
            property = this.build(annotation, this.object);
            list.add(property);
        }
        if (ObjectKit.isNotEmpty(this.object)) {
            Class<?> clazz = this.object.getClass();
            List<Annotation> clazzAnnotations = Validated.getAnnotation(clazz);
            for (Annotation annotation : clazzAnnotations) {
                property = this.build(annotation, this.object);
                list.add(property);
            }
        }
        return list;
    }

    private Context resolve(Context context, Annotation[] annotations) {
        Class<?> clazz;
        Inside inside;
        if (ObjectKit.isNotEmpty(this.object) && ObjectKit.isNotEmpty((Object)(inside = (clazz = this.object.getClass()).getAnnotation(Inside.class)))) {
            context.setInside(true);
        }
        for (Annotation annotation : annotations) {
            if (annotation instanceof Valid) {
                context.setInside(((Valid)annotation).inside());
                context.setField(((Valid)annotation).value());
                context.setSkip(((Valid)annotation).skip());
                continue;
            }
            if (annotation instanceof Group) {
                context.addGroups(((Group)annotation).value());
                continue;
            }
            if (annotation instanceof Group) {
                context.addGroups(((Group)annotation).value());
                continue;
            }
            if (annotation instanceof ValidEx) {
                context.setException(((ValidEx)annotation).value());
                continue;
            }
            if (!(annotation instanceof Inside)) continue;
            context.setInside(true);
        }
        return context;
    }

    public Collector access() {
        Collector collector = new Collector(this);
        Checker checker = this.context.getChecker();
        for (Property p : this.list) {
            Collector result = checker.object(this, p);
            collector.collect(result);
        }
        if (this.context.isInside()) {
            Collector result = checker.inside(this);
            collector.collect(result);
        }
        return collector;
    }

    public Property build(Annotation annotation, Object object) {
        Assert.isTrue(Validated.isAnnotation(annotation), "\u5c1d\u8bd5\u4ece\u975e\u6821\u9a8c\u6ce8\u89e3\u4e0a\u83b7\u53d6\u4fe1\u606f:" + annotation, new Object[0]);
        Class<? extends Annotation> annotationType = annotation.annotationType();
        try {
            Annotation[] parentAnnos;
            Method[] declaredMethods;
            String[] groups = (String[])annotationType.getMethod("group", new Class[0]).invoke((Object)annotation, new Object[0]);
            String errmsg = (String)annotationType.getMethod("errmsg", new Class[0]).invoke((Object)annotation, new Object[0]);
            String errcode = (String)annotationType.getMethod("errcode", new Class[0]).invoke((Object)annotation, new Object[0]);
            String name = (String)annotationType.getMethod("field", new Class[0]).invoke((Object)annotation, new Object[0]);
            this.field = "field".equals(name) ? this.field : name;
            Property property = new Property();
            property.setAnnotation(annotation);
            property.setErrmsg(errmsg);
            property.setGroup(groups);
            property.setField(this.field);
            property.setErrcode(errcode);
            property.addParam("field", this.field);
            if (ObjectKit.isNotEmpty(object) && object.getClass().isArray()) {
                property.addParam("val", Arrays.toString((Object[])object));
            } else {
                property.addParam("val", String.valueOf(object));
            }
            for (Method m : declaredMethods = annotationType.getDeclaredMethods()) {
                Filler filler = m.getAnnotation(Filler.class);
                if (!ObjectKit.isNotEmpty((Object)filler)) continue;
                Class<?> returnType = m.getReturnType();
                Object invoke = m.invoke((Object)annotation, new Object[0]);
                if (returnType.isArray()) {
                    property.addParam(filler.value(), Arrays.toString((Object[])invoke));
                    continue;
                }
                property.addParam(filler.value(), invoke);
            }
            for (Annotation anno : parentAnnos = annotationType.getAnnotations()) {
                if (Validated.isAnnotation(anno)) {
                    property.addParentProperty(this.build(anno, object));
                    continue;
                }
                if (anno instanceof Array) {
                    property.setArray(true);
                    continue;
                }
                if (anno instanceof Complex) {
                    property.setClazz(((Complex)anno).clazz());
                    property.setName(((Complex)anno).value());
                    continue;
                }
                if (!(anno instanceof ValidEx)) continue;
                property.setException(((ValidEx)anno).value());
            }
            if (ObjectKit.isEmpty(property.getClazz()) || StringKit.isEmpty(property.getName())) {
                throw new InstrumentException("\u975e\u6cd5\u7684\u6821\u9a8c\u6ce8\u89e3,\u6ca1\u6709\u4f7f\u7528Complex\u5143\u6ce8\u89e3\u8868\u793a\u6821\u9a8c\u5668:" + annotationType.getName());
            }
            return property;
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new InstrumentException("\u975e\u6cd5\u7684\u6821\u9a8c\u6ce8\u89e3,\u6ca1\u6709\u5b9a\u4e49\u901a\u7528\u7684\u6821\u9a8c\u5c5e\u6027:" + annotationType.getName(), e);
        }
    }

    public List<Property> getList() {
        return this.list;
    }

    public Object getObject() {
        return this.object;
    }

    public String getField() {
        return this.field;
    }

    public Context getContext() {
        return this.context;
    }

    public void setList(List<Property> list) {
        this.list = list;
    }

    public void setObject(Object object) {
        this.object = object;
    }

    public void setField(String field) {
        this.field = field;
    }

    public void setContext(Context context) {
        this.context = context;
    }

    public String toString() {
        return "Validated(list=" + this.getList() + ", object=" + this.getObject() + ", field=" + this.getField() + ", context=" + this.getContext() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Validated)) {
            return false;
        }
        Validated other = (Validated)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<Property> this$list = this.getList();
        List<Property> other$list = other.getList();
        if (this$list == null ? other$list != null : !((Object)this$list).equals(other$list)) {
            return false;
        }
        Object this$object = this.getObject();
        Object other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        String this$field = this.getField();
        String other$field = other.getField();
        if (this$field == null ? other$field != null : !this$field.equals(other$field)) {
            return false;
        }
        Context this$context = this.getContext();
        Context other$context = other.getContext();
        return !(this$context == null ? other$context != null : !((Object)this$context).equals(other$context));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Validated;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<Property> $list = this.getList();
        result = result * 59 + ($list == null ? 43 : ((Object)$list).hashCode());
        Object $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        String $field = this.getField();
        result = result * 59 + ($field == null ? 43 : $field.hashCode());
        Context $context = this.getContext();
        result = result * 59 + ($context == null ? 43 : ((Object)$context).hashCode());
        return result;
    }
}

